/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.util.DataBlock;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class CAML {
    private static final Pattern base = Pattern.compile("(\\s*)([^=^:]+)\\s*([=:])\\s?(\"[^\"]*\"|[^#]*)(#.*)?");

    public static DataBlock parse(InputStream stream) throws IOException {
        List<String> lines = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8).stream().filter(s -> !StringUtils.isWhitespace((CharSequence)s.replaceFirst("#.*", ""))).collect(Collectors.toList());
        stream.close();
        return CAML.createBlock(lines, "");
    }

    private static DataBlock createBlock(List<String> lines, final String context) throws ParseException {
        final LinkedHashMap<String, DataBlock.Value> primitives = new LinkedHashMap<String, DataBlock.Value>();
        final LinkedHashMap<String, List> primitiveSets = new LinkedHashMap<String, List>();
        final LinkedHashMap<String, DataBlock> blocks = new LinkedHashMap<String, DataBlock>();
        final LinkedHashMap<String, List> blockSets = new LinkedHashMap<String, List>();
        String spaces = null;
        while (!lines.isEmpty()) {
            String line = lines.get(0);
            Matcher m = base.matcher(line);
            if (!m.matches()) {
                throw new ParseException(String.format("Invalid Block line '%s'", line), new Object[0]);
            }
            String pre = m.group(1);
            String key = m.group(2);
            String mod = m.group(3);
            String val = m.group(4);
            if (spaces == null) {
                spaces = pre;
            }
            if (!pre.startsWith(spaces) && !spaces.startsWith(pre)) {
                throw new ParseException(String.format("Invalid Block line '%s' mismatched indentation '%s' vs '%s'", line, spaces, pre), new Object[0]);
            }
            if (spaces.length() > pre.length()) break;
            if (!spaces.equals(pre)) {
                throw new ParseException(String.format("Invalid Block line '%s' invalid indentation '%s' vs '%s'", line, spaces, pre), new Object[0]);
            }
            lines.remove(0);
            String trimmed = val.trim();
            if (trimmed.startsWith("\"") && trimmed.endsWith("\"")) {
                trimmed = trimmed.substring(1, trimmed.length() - 1);
            }
            if ((key = key.trim()).startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            if (StringUtils.isWhitespace((CharSequence)val)) {
                DataBlock block = CAML.createBlock(lines, String.format("%s > %s", context, key));
                if (mod.equals("=")) {
                    if (blocks.containsKey(key) || blockSets.containsKey(key)) {
                        throw new ParseException(String.format("Invalid line: '%s' can not be specified multiple times at %s", line, context), new Object[0]);
                    }
                    blocks.put(key, block);
                    continue;
                }
                if (blocks.containsKey(key)) {
                    throw new ParseException(String.format("Invalid line: '%s' can not be specified multiple times %s", line, context), new Object[0]);
                }
                blockSets.computeIfAbsent(key, k -> new ArrayList()).add(block);
                continue;
            }
            if (mod.equals("=")) {
                if (primitives.containsKey(key) || primitiveSets.containsKey(key)) {
                    throw new ParseException(String.format("Invalid line: '%s' can not be specified multiple times %s", line, context), new Object[0]);
                }
                primitives.put(key, CAML.createValue(trimmed));
                continue;
            }
            if (primitives.containsKey(key)) {
                throw new ParseException(String.format("Invalid line: '%s' can not be specified multiple times %s", line, context), new Object[0]);
            }
            primitiveSets.computeIfAbsent(key, k -> new ArrayList()).add(CAML.createValue(trimmed));
        }
        return new DataBlock(){

            @Override
            public Map<String, DataBlock.Value> getValueMap() {
                return primitives;
            }

            @Override
            public Map<String, List<DataBlock.Value>> getValuesMap() {
                return primitiveSets;
            }

            @Override
            public Map<String, DataBlock> getBlockMap() {
                return blocks;
            }

            @Override
            public Map<String, List<DataBlock>> getBlocksMap() {
                return blockSets;
            }

            @Override
            public DataBlock.Value getValue(String key) {
                DataBlock.Value value = DataBlock.super.getValue(key);
                if (value.asString() == null && this.getValuesMap().containsKey(key)) {
                    throw new FormatException("Error in CAML file: expected single value '=' but found multiple ':' for key %s '%s'", context, key);
                }
                return value;
            }

            @Override
            public List<DataBlock.Value> getValues(String key) {
                List<DataBlock.Value> values = DataBlock.super.getValues(key);
                if (values == null && this.getValueMap().containsKey(key)) {
                    throw new FormatException("Error in CAML file: multiple values ':' but found single value '=' for key %s '%s'", context, key);
                }
                return values;
            }

            @Override
            public DataBlock getBlock(String key) {
                DataBlock block = DataBlock.super.getBlock(key);
                if (block == null && this.getBlocksMap().containsKey(key)) {
                    throw new FormatException("Error in CAML file: expected single block '=' but found multiple ':' for key %s '%s'", context, key);
                }
                return block;
            }

            @Override
            public List<DataBlock> getBlocks(String key) {
                List<DataBlock> blocks2 = DataBlock.super.getBlocks(key);
                if (blocks2 == null && this.getBlockMap().containsKey(key)) {
                    throw new FormatException("Error in CAML file: multiple blocks ':' but found single value '=' for key %s '%s'", context, key);
                }
                return blocks2;
            }
        };
    }

    private static DataBlock.Value createValue(final String value) {
        if (value == null || value.equalsIgnoreCase("null")) {
            return DataBlock.Value.NULL;
        }
        return new DataBlock.Value(){

            @Override
            public Boolean asBoolean() {
                return Boolean.parseBoolean(value);
            }

            @Override
            public Integer asInteger() {
                return Integer.parseInt(value);
            }

            @Override
            public Float asFloat() {
                return Float.valueOf(Float.parseFloat(value));
            }

            @Override
            public Double asDouble() {
                return Double.parseDouble(value);
            }

            @Override
            public String asString() {
                return value;
            }
        };
    }

    public static class FormatException
    extends RuntimeException {
        public FormatException(String text, Object ... params) {
            super(String.format(text, params));
        }
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String text, Object ... params) {
            super(String.format(text, params));
        }
    }
}

