/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.thirdparty;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.thirdparty.CommonAPI;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.mod.event.CommonEvents;
import cam72cam.mod.math.Vec3i;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ComputerCraft {
    public static void init() {
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new IPeripheralProvider(){

            @Nullable
            public IPeripheral getPeripheral(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumFacing enumFacing) {
                TileRailBase rail = (TileRailBase)cam72cam.mod.world.World.get((World)world).getBlockEntity(new Vec3i(blockPos), TileRailBase.class);
                if (rail != null) {
                    if (rail.getAugment() == Augment.DETECTOR) {
                        return new DetectorPeripheral(world, blockPos);
                    }
                    if (rail.getAugment() == Augment.LOCO_CONTROL) {
                        return new LocoControlPeripheral(world, blockPos);
                    }
                }
                return null;
            }
        });
        CommonEvents.World.TICK.subscribe(TickHandler::onWorldTick);
    }

    private static Object getObjParam(Object[] params, int id, String name) throws LuaException {
        if (params.length > id) {
            return params[id];
        }
        throw new LuaException("Required parameter \"" + name + "\"");
    }

    private static double getDoubleParam(Object[] params, int id, String name) throws LuaException {
        Object obj = ComputerCraft.getObjParam(params, id, name);
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (NumberFormatException ex) {
            throw new LuaException("Required parameter \"" + name + "\" is not a number");
        }
    }

    private static boolean getBooleanParam(Object[] params, int id, String name) throws LuaException {
        Object obj = ComputerCraft.getObjParam(params, id, name);
        try {
            return Boolean.parseBoolean(obj.toString());
        }
        catch (NumberFormatException ex) {
            throw new LuaException("Required parameter \"" + name + "\" is not a number");
        }
    }

    private static class LocoControlPeripheral
    extends BasePeripheral {
        private static LinkedHashMap<String, APICall> methods = new LinkedHashMap();

        public LocoControlPeripheral(World world, BlockPos blockPos) {
            super(world, blockPos, methods);
            this.typeFilter = Locomotive.class;
        }

        @Nonnull
        public String getType() {
            return "ir_augment_control";
        }

        static {
            methods.putAll(DetectorPeripheral.methods);
            methods.put("setThrottle", (api, params) -> {
                api.setThrottle(ComputerCraft.getDoubleParam(params, 0, "throttle"));
                return null;
            });
            methods.put("setReverser", (api, params) -> {
                api.setReverser(ComputerCraft.getDoubleParam(params, 0, "reverser"));
                return null;
            });
            methods.put("setBrake", (api, params) -> {
                api.setTrainBrake(ComputerCraft.getDoubleParam(params, 0, "brake"));
                return null;
            });
            methods.put("setTrainBrake", (api, params) -> {
                api.setTrainBrake(ComputerCraft.getDoubleParam(params, 0, "brake"));
                return null;
            });
            methods.put("setIndependentBrake", (api, params) -> {
                api.setIndependentBrake(ComputerCraft.getDoubleParam(params, 0, "brake"));
                return null;
            });
            methods.put("setHorn", (api, params) -> {
                api.setHorn((int)ComputerCraft.getDoubleParam(params, 0, "horn"));
                return null;
            });
            methods.put("setBell", (api, params) -> {
                api.setBell((int)ComputerCraft.getDoubleParam(params, 0, "bell"));
                return null;
            });
            methods.put("getIgnition", (api, params) -> new Object[]{api.getIgnition()});
            methods.put("setIgnition", (api, params) -> {
                api.setIgnition(ComputerCraft.getBooleanParam(params, 0, "ignition"));
                return null;
            });
        }
    }

    private static class DetectorPeripheral
    extends BasePeripheral {
        private static LinkedHashMap<String, APICall> methods = new LinkedHashMap();

        public DetectorPeripheral(World world, BlockPos blockPos) {
            super(world, blockPos, methods);
        }

        @Nonnull
        public String getType() {
            return "ir_augment_detector";
        }

        static {
            methods.put("info", (api, params) -> new Object[]{api.info()});
            methods.put("consist", (api, params) -> new Object[]{api.consist(false)});
            methods.put("getTag", (api, params) -> new Object[]{api.getTag()});
            methods.put("setTag", (api, params) -> {
                api.setTag(ComputerCraft.getObjParam(params, 0, "tag").toString());
                return null;
            });
        }
    }

    private static abstract class BasePeripheral
    implements IPeripheral {
        private final World world;
        private final BlockPos pos;
        private final String[] fnNames;
        private final APICall[] fnImpls;
        private UUID wasOverhead;
        protected Class<? extends EntityRollingStock> typeFilter = EntityRollingStock.class;

        public BasePeripheral(World world, BlockPos blockPos, LinkedHashMap<String, APICall> methods) {
            this.world = world;
            this.pos = blockPos;
            this.fnNames = methods.keySet().toArray(new String[0]);
            this.fnImpls = methods.values().toArray(new APICall[0]);
            this.wasOverhead = null;
        }

        public void update(Set<IComputerAccess> computers) {
            if (computers.size() > 0) {
                UUID isOverhead;
                TileRailBase te = (TileRailBase)cam72cam.mod.world.World.get((World)this.world).getBlockEntity(new Vec3i(this.pos), TileRailBase.class);
                EntityRollingStock nearby = te.getStockNearBy(this.typeFilter);
                UUID uUID = isOverhead = nearby != null ? nearby.getUUID() : null;
                if (isOverhead != this.wasOverhead) {
                    for (IComputerAccess computer : computers) {
                        computer.queueEvent("ir_train_overhead", (Object[])new String[]{te.getAugment().toString(), isOverhead == null ? null : isOverhead.toString()});
                    }
                }
                this.wasOverhead = isOverhead;
            }
        }

        public void attach(@Nonnull IComputerAccess computer) {
            MinecraftServer server = this.world.func_73046_m();
            if (server != null) {
                server.func_152344_a(() -> TickHandler.attach(this, computer));
            }
        }

        public void detach(@Nonnull IComputerAccess computer) {
            MinecraftServer server = this.world.func_73046_m();
            if (server != null) {
                server.func_152344_a(() -> TickHandler.detach(this, computer));
            }
        }

        @Nonnull
        public String[] getMethodNames() {
            return this.fnNames;
        }

        @Nullable
        public Object[] callMethod(@Nonnull IComputerAccess iComputerAccess, @Nonnull ILuaContext iLuaContext, int i, @Nonnull Object[] objects) throws LuaException, InterruptedException {
            try {
                CommonAPI api = CommonAPI.create(this.world, this.pos);
                if (api != null && i < this.fnImpls.length) {
                    return this.fnImpls[i].apply(api, objects);
                }
            }
            catch (Exception ex) {
                ImmersiveRailroading.catching((Throwable)ex);
            }
            return null;
        }

        public boolean equals(@Nullable IPeripheral iPeripheral) {
            return iPeripheral == this;
        }
    }

    public static class TickHandler {
        private static final Map<BasePeripheral, Set<IComputerAccess>> tickable = new HashMap<BasePeripheral, Set<IComputerAccess>>();

        public static void onWorldTick(World world) {
            tickable.forEach((peripheral, computers) -> {
                if (!world.field_72995_K && ((BasePeripheral)peripheral).world == world) {
                    peripheral.update((Set<IComputerAccess>)computers);
                }
            });
        }

        public static void attach(BasePeripheral p, IComputerAccess c) {
            if (!tickable.containsKey(p)) {
                tickable.put(p, new HashSet());
            }
            tickable.get(p).add(c);
        }

        public static void detach(BasePeripheral p, IComputerAccess c) {
            if (tickable.containsKey(p)) {
                tickable.get(p).remove(c);
                if (tickable.get(p).isEmpty()) {
                    tickable.remove(p);
                }
            }
        }
    }

    @FunctionalInterface
    private static interface APICall {
        public Object[] apply(CommonAPI var1, Object[] var2) throws LuaException;
    }
}

