/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.PaintBrushMode;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.CreativeTab;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.item.Recipes;
import cam72cam.mod.net.Packet;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class ItemPaintBrush
extends CustomItem {
    private static final Random rand = new Random(System.currentTimeMillis());

    public ItemPaintBrush() {
        super("immersiverailroading", "item_paint_brush");
        Recipes.shapedRecipe((CustomItem)this, (int)1, (Fuzzy[])new Fuzzy[]{Fuzzy.WOOL_BLOCK, Fuzzy.IRON_INGOT, Fuzzy.WOOD_STICK});
    }

    public int getStackSize() {
        return 1;
    }

    public List<CreativeTab> getCreativeTabs() {
        return Collections.singletonList(ItemTabs.MAIN_TAB);
    }

    public List<String> getTooltip(ItemStack stack) {
        PaintBrushMode pbm = new Data((ItemStack)stack).mode;
        ArrayList<String> tips = new ArrayList<String>();
        tips.add(GuiText.PAINT_BRUSH_MODE_TOOLTIP.toString(pbm.toTranslatedString()));
        tips.add(GuiText.PAINT_BRUSH_DESCRIPTION_TOOLTIP.toString());
        return tips;
    }

    public static void onStockInteract(EntityRollingStock stock, Player player, Player.Hand hand) {
        if (player.getWorld().isClient) {
            Data data = new Data(player.getHeldItem(hand));
            switch (data.mode) {
                case GUI: {
                    GuiTypes.PAINT_BRUSH.open(player);
                    break;
                }
                case RANDOM_SINGLE: 
                case RANDOM_COUPLED: {
                    new PaintBrushPacket(stock, data.mode, null, false).sendToServer();
                }
            }
        }
    }

    public void onClickAir(Player player, World world, Player.Hand hand) {
        if (player.isCrouching() && world.isServer) {
            ItemStack item = player.getHeldItem(hand);
            Data data = new Data(item);
            data.mode = PaintBrushMode.values()[(data.mode.ordinal() + 1) % PaintBrushMode.values().length];
            data.write();
            player.sendMessage(ChatText.BRUSH_MODE_SET.getMessage(data.mode.toTranslatedString()));
        }
    }

    public static String nextRandomTexture(EntityRollingStock stock, String current) {
        ArrayList<String> choices = new ArrayList<String>(stock.getDefinition().textureNames.keySet());
        if (choices.size() > 1) {
            choices.remove(current);
        }
        return (String)choices.get(rand.nextInt(choices.size()));
    }

    public static class Data
    extends CustomItem.ItemDataSerializer {
        @TagField(value="mode", typeHint=PaintBrushMode.class)
        public PaintBrushMode mode;

        public Data(ItemStack stack) {
            super(stack);
            if (this.mode == null) {
                this.mode = PaintBrushMode.GUI;
            }
        }
    }

    public static class PaintBrushPacket
    extends Packet {
        @TagField(value="stock")
        public EntityRollingStock stock;
        @TagField(value="mode", typeHint=PaintBrushMode.class)
        public PaintBrushMode mode;
        @TagField(value="variant")
        public String variant;
        @TagField
        public boolean gui_connected;

        public PaintBrushPacket(EntityRollingStock stock, PaintBrushMode mode, String variant, boolean gui_connected) {
            this.stock = stock;
            this.mode = mode;
            this.variant = variant;
            this.gui_connected = gui_connected;
        }

        public PaintBrushPacket() {
        }

        protected void handle() {
            if (this.stock == null) {
                ImmersiveRailroading.warn((String)"Invalid paint brush packet!", (Object[])new Object[0]);
                return;
            }
            switch (this.mode) {
                case GUI: {
                    if (this.gui_connected) {
                        EntityCoupleableRollingStock coupled = (EntityCoupleableRollingStock)this.stock;
                        for (EntityCoupleableRollingStock stock : coupled.getTrain(false)) {
                            if (!stock.getDefinition().textureNames.containsKey(this.variant)) continue;
                            stock.setTexture(this.variant);
                        }
                        break;
                    }
                    this.stock.setTexture(this.variant);
                    break;
                }
                case RANDOM_SINGLE: {
                    this.stock.setTexture(ItemPaintBrush.nextRandomTexture(this.stock, this.stock.getTexture()));
                    break;
                }
                case RANDOM_COUPLED: {
                    EntityCoupleableRollingStock coupled = (EntityCoupleableRollingStock)this.stock;
                    for (EntityCoupleableRollingStock stock : coupled.getTrain(false)) {
                        stock.setTexture(ItemPaintBrush.nextRandomTexture(stock, stock.getTexture()));
                    }
                    break;
                }
            }
            if (this.mode != PaintBrushMode.RANDOM_COUPLED) {
                if (this.stock.getDefinition().textureNames.size() == 0) {
                    this.getPlayer().sendMessage(ChatText.BRUSH_NO_VARIANTS.getMessage(new Object[0]));
                } else if (Config.ConfigDebug.debugPaintBrush) {
                    this.getPlayer().sendMessage(ChatText.BRUSH_NEXT.getMessage(this.stock.getDefinition().textureNames.getOrDefault(this.stock.getTexture(), "Unknown"), this.mode.toTranslatedString()));
                }
            }
        }
    }
}

