/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class StorageCacheItem
implements IStorageCache<ItemStack> {
    public static final Consumer<INetwork> INVALIDATE = network -> network.getItemStorageCache().invalidate();
    private INetwork network;
    private CopyOnWriteArrayList<IStorage<ItemStack>> storages = new CopyOnWriteArrayList();
    private IStackList<ItemStack> list = API.instance().createItemStackList();
    private List<IStorageCacheListener<ItemStack>> listeners = new LinkedList<IStorageCacheListener<ItemStack>>();
    private List<Pair<ItemStack, Integer>> batchedChanges = new ArrayList<Pair<ItemStack, Integer>>();

    public StorageCacheItem(INetwork network) {
        this.network = network;
    }

    @Override
    public synchronized void invalidate() {
        this.storages.clear();
        this.network.getNodeGraph().all().stream().filter(node -> node.canUpdate() && node instanceof IStorageProvider).forEach(node -> ((IStorageProvider)((Object)node)).addItemStorages(this.storages));
        this.list.clear();
        this.sort();
        for (IStorage<ItemStack> storage : this.storages) {
            if (storage.getAccessType() == AccessType.INSERT) continue;
            for (ItemStack stack : storage.getStacks()) {
                if (stack.func_190926_b()) continue;
                this.add(stack, stack.func_190916_E(), true, false);
            }
        }
        this.listeners.forEach(IStorageCacheListener::onInvalidated);
    }

    @Override
    public synchronized void add(@Nonnull ItemStack stack, int size, boolean rebuilding, boolean batched) {
        this.list.add(stack, size);
        if (!rebuilding) {
            if (!batched) {
                this.listeners.forEach(l -> l.onChanged(stack, size));
            } else {
                this.batchedChanges.add((Pair<ItemStack, Integer>)Pair.of((Object)stack.func_77946_l(), (Object)size));
            }
        }
    }

    @Override
    public synchronized void remove(@Nonnull ItemStack stack, int size, boolean batched) {
        if (this.list.remove(stack, size)) {
            if (!batched) {
                this.listeners.forEach(l -> l.onChanged(stack, -size));
            } else {
                this.batchedChanges.add((Pair<ItemStack, Integer>)Pair.of((Object)stack.func_77946_l(), (Object)(-size)));
            }
        }
    }

    @Override
    public synchronized void flush() {
        if (!this.batchedChanges.isEmpty()) {
            if (this.batchedChanges.size() > 1) {
                this.listeners.forEach(l -> l.onChangedBulk(this.batchedChanges));
            } else {
                this.batchedChanges.forEach(c -> this.listeners.forEach(l -> l.onChanged(c.getKey(), (Integer)c.getValue())));
            }
            this.batchedChanges.clear();
        }
    }

    @Override
    public void addListener(IStorageCacheListener<ItemStack> listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(IStorageCacheListener<ItemStack> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void sort() {
        this.storages.sort(IStorage.COMPARATOR);
    }

    @Override
    public IStackList<ItemStack> getList() {
        return this.list;
    }

    @Override
    public List<IStorage<ItemStack>> getStorages() {
        return this.storages;
    }
}

