/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import team.creative.enhancedvisuals.common.handler.VisualHandlers;

public class ExplosionPacket
extends CreativeCorePacket {
    public Vec3d pos;
    public float size;
    public int sourceEntity;

    public ExplosionPacket(Vec3d pos, float size, int sourceEntity) {
        this.pos = pos;
        this.size = size;
        this.sourceEntity = sourceEntity;
    }

    public ExplosionPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        ExplosionPacket.writeVec3d((Vec3d)this.pos, (ByteBuf)buf);
        buf.writeFloat(this.size);
        buf.writeInt(this.sourceEntity);
    }

    public void readBytes(ByteBuf buf) {
        this.pos = ExplosionPacket.readVec3d((ByteBuf)buf);
        this.size = buf.readFloat();
        this.sourceEntity = buf.readInt();
    }

    public void executeClient(EntityPlayer player) {
        if (VisualHandlers.EXPLOSION.isEnabled(player)) {
            VisualHandlers.EXPLOSION.onExploded(player, this.pos, this.size, player.field_70170_p.func_73045_a(this.sourceEntity));
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

