/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.helpers.IngredientHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.IngredientWrapper;
import mekanism.common.integration.crafttweaker.util.RemoveAllMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.machines.CombinerRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.combiner")
@ZenRegister
public class Combiner {
    public static final String NAME = "Mekanism Combiner";

    @ZenMethod
    public static void addRecipe(IIngredient ingredientInput, IIngredient ingredientExtra, IItemStack itemOutput) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[]{ingredientInput, ingredientExtra, itemOutput})) {
            ItemStackOutput output = new ItemStackOutput(CraftTweakerMC.getItemStack((IItemStack)itemOutput));
            ArrayList<CombinerRecipe> recipes = new ArrayList<CombinerRecipe>();
            ItemStack[] extraInputs = CraftTweakerMC.getIngredient((IIngredient)ingredientExtra).func_193365_a();
            for (ItemStack stack : CraftTweakerMC.getIngredient((IIngredient)ingredientInput).func_193365_a()) {
                for (ItemStack extra : extraInputs) {
                    recipes.add(new CombinerRecipe(new DoubleMachineInput(stack, extra), output));
                }
            }
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe>(NAME, RecipeHandler.Recipe.COMBINER, recipes));
        }
    }

    @ZenMethod
    @Deprecated
    public static void addRecipe(IIngredient ingredientInput, IItemStack itemOutput) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[]{ingredientInput, itemOutput})) {
            ItemStack output = CraftTweakerMC.getItemStack((IItemStack)itemOutput);
            ArrayList<CombinerRecipe> recipes = new ArrayList<CombinerRecipe>();
            for (ItemStack stack : CraftTweakerMC.getIngredient((IIngredient)ingredientInput).func_193365_a()) {
                recipes.add(new CombinerRecipe(stack, output));
            }
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe>(NAME, RecipeHandler.Recipe.COMBINER, recipes));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, @Optional IIngredient itemInput, @Optional IIngredient extraInput) {
        if (IngredientHelper.checkNotNull(NAME, itemOutput)) {
            CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveMekanismRecipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe>(NAME, RecipeHandler.Recipe.COMBINER, new IngredientWrapper(itemOutput), new IngredientWrapper(itemInput, extraInput)));
        }
    }

    @ZenMethod
    public static void removeAllRecipes() {
        CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveAllMekanismRecipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe>(NAME, RecipeHandler.Recipe.COMBINER));
    }
}

