/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.voice;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import javax.sound.sampled.AudioFormat;
import mekanism.client.voice.VoiceInput;
import mekanism.client.voice.VoiceOutput;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VoiceClient
extends Thread {
    private AudioFormat format = new AudioFormat(16000.0f, 16, 1, true, true);
    private VoiceOutput outputThread;
    private VoiceInput inputThread;
    private DataOutputStream output;
    private DataInputStream input;
    private boolean running;
    private Socket socket;
    private String ip;

    public VoiceClient(String s) {
        this.ip = s;
    }

    @Override
    public void run() {
        Mekanism.logger.info("VoiceServer: Starting client connection...");
        try {
            this.socket = new Socket(this.ip, MekanismConfig.current().general.VOICE_PORT.val());
            this.running = true;
            this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.output = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.outputThread = new VoiceOutput(this);
            this.outputThread.start();
            this.inputThread = new VoiceInput(this);
            this.inputThread.start();
            Mekanism.logger.info("VoiceServer: Successfully connected to server.");
        }
        catch (ConnectException e) {
            Mekanism.logger.error("VoiceServer: Server's VoiceServer is disabled.");
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while starting client connection.", (Throwable)e);
        }
    }

    public void disconnect() {
        Mekanism.logger.info("VoiceServer: Stopping client connection...");
        try {
            if (this.inputThread != null) {
                this.inputThread.interrupt();
                this.inputThread.close();
            }
            if (this.outputThread != null) {
                this.outputThread.interrupt();
                this.outputThread.close();
            }
            if (this.output != null) {
                this.output.close();
            }
            if (this.input != null) {
                this.input.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            this.interrupt();
            this.running = false;
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while stopping client connection.", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public DataOutputStream getOutputStream() {
        return this.output;
    }

    public DataInputStream getInputStream() {
        return this.input;
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }
}

