/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;
import thut.api.maths.Vector3;
import thut.core.client.render.particle.IAnimatedParticle;
import thut.core.client.render.particle.IParticle;

public class ParticleBase
implements IParticle,
IAnimatedParticle {
    public static ResourceLocation TEXTUREMAP = new ResourceLocation("thutcore", "textures/particles.png");
    int duration = 10;
    int lifetime = 10;
    int initTime = 0;
    long lastTick = 0L;
    int animSpeed = 2;
    double size = 1.0;
    int rgba = -1;
    String name;
    boolean billboard = true;
    Vector3 velocity = Vector3.empty;
    int[][] tex = new int[1][2];

    public ParticleBase(int x, int y) {
        this.tex[0][0] = x;
        this.tex[0][1] = y;
        this.name = "";
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public void kill() {
        if (this.velocity == Vector3.empty || this.velocity != null) {
            // empty if block
        }
    }

    @Override
    public long lastTick() {
        return this.lastTick;
    }

    @Override
    public void render(double renderPartialTicks) {
        BufferBuilder tez = Tessellator.func_178181_a().func_178180_c();
        GL11.glPushMatrix();
        if (this.billboard) {
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        this.setColour();
        float alpha = (float)(this.rgba >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.rgba >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.rgba >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.rgba & 0xFF) / 255.0f;
        VertexFormat format = DefaultVertexFormats.field_181706_f;
        ResourceLocation texture = TEXTUREMAP;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(texture);
        format = DefaultVertexFormats.field_181709_i;
        int num = this.getDuration() / this.animSpeed % this.tex.length;
        int u = this.tex[num][0];
        int v = this.tex[num][1];
        Vector3 temp = Vector3.getNewVector();
        double factor = (double)(this.lifetime - this.getDuration()) + renderPartialTicks;
        temp.set(this.velocity).scalarMultBy(factor);
        double u1 = (double)u * 1.0 / 16.0;
        double v1 = (double)v * 1.0 / 16.0;
        double u2 = (double)(u + 1) * 1.0 / 16.0;
        double v2 = (double)(v + 1) * 1.0 / 16.0;
        tez.func_181668_a(7, format);
        tez.func_181662_b(temp.x - this.size, temp.y - this.size, temp.z).func_187315_a(u1, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        tez.func_181662_b(temp.x, temp.y - this.size, temp.z).func_187315_a(u2, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        tez.func_181662_b(temp.x, temp.y + this.size, temp.z).func_187315_a(u2, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        tez.func_181662_b(temp.x - this.size, temp.y + this.size, temp.z).func_187315_a(u1, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        tez.func_181662_b(temp.x - this.size, temp.y - this.size, temp.z).func_187315_a(u1, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        tez.func_181662_b(temp.x - this.size, temp.y + this.size, temp.z).func_187315_a(u1, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        tez.func_181662_b(temp.x, temp.y + this.size, temp.z).func_187315_a(u2, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        tez.func_181662_b(temp.x, temp.y - this.size, temp.z).func_187315_a(u2, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopMatrix();
    }

    void setColour() {
        if (this.name.equalsIgnoreCase("aurora")) {
            this.rgba = -16777216;
            int num = (this.getDuration() + this.initTime) / this.animSpeed % 16;
            this.rgba += EnumDyeColor.func_176764_b((int)num).func_193350_e();
        }
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public void setLastTick(long tick) {
        this.lastTick = tick;
    }

    @Override
    public void setLifetime(int ticks) {
        this.duration = this.lifetime = ticks;
    }

    @Override
    public void setAnimSpeed(int speed) {
        this.animSpeed = Math.max(speed, 5);
    }

    @Override
    public void setTex(int[][] textures) {
        this.tex = textures;
    }

    public void setVelocity(Vector3 v) {
        this.velocity = v;
    }

    @Override
    public void setColour(int colour) {
        this.rgba = colour;
    }

    @Override
    public void setSize(float size) {
        this.size = size;
    }

    @Override
    public void setStartTime(int start) {
        this.initTime = start;
    }
}

