/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network.energy;

import api.hbm.energy.IEnergyConnector;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.hbm.config.GeneralConfig;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.TileEntityLoadedBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyProvider", modid="redstoneflux")})
public class TileEntityConverterHeRf
extends TileEntityLoadedBase
implements ITickable,
IEnergyConnector,
IEnergyProvider,
IEnergyStorage {
    private boolean recursionBrake = false;
    private long lastTransfer = 0L;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int transferToRFMachine(TileEntity entity, int rf, EnumFacing dir) {
        if (entity != null && entity instanceof IEnergyReceiver) {
            IEnergyReceiver receiver = (IEnergyReceiver)entity;
            return receiver.receiveEnergy(dir, rf, false);
        }
        return 0;
    }

    public int transferToFEMachine(TileEntity entity, int fe, EnumFacing dir) {
        IEnergyStorage storage;
        if (entity != null && entity.hasCapability(CapabilityEnergy.ENERGY, dir) && (storage = (IEnergyStorage)entity.getCapability(CapabilityEnergy.ENERGY, dir)).canReceive()) {
            return storage.receiveEnergy(fe, false);
        }
        return 0;
    }

    @Override
    public long transferPower(long power) {
        if (this.recursionBrake) {
            return power;
        }
        this.recursionBrake = true;
        int toRF = (int)Math.min(Integer.MAX_VALUE, power);
        int transfer = 0;
        int totalTransferred = 0;
        boolean skipRF = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity entity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ));
            if (!skipRF) {
                try {
                    transfer = this.transferToRFMachine(entity, toRF, dir.getOpposite().toEnumFacing());
                    totalTransferred += transfer;
                    toRF -= transfer;
                }
                catch (NoSuchMethodError e) {
                    skipRF = true;
                }
            }
            transfer = this.transferToFEMachine(entity, toRF, dir.getOpposite().toEnumFacing());
            totalTransferred += transfer;
            toRF -= transfer;
        }
        this.recursionBrake = false;
        this.lastTransfer = (long)((float)totalTransferred / (float)GeneralConfig.rfConversionRate);
        return power - (long)((float)totalTransferred / (float)GeneralConfig.rfConversionRate);
    }

    @Override
    public long getPower() {
        return 0L;
    }

    @Override
    public long getMaxPower() {
        return (long)(2.1474836E9f / (float)GeneralConfig.rfConversionRate);
    }

    @Override
    public long getTransferWeight() {
        if (this.lastTransfer > 0L) {
            return this.lastTransfer * 2L;
        }
        return this.getMaxPower();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }
}

