/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.RefineryRecipes;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineRefinery
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
IFluidHandler,
ITankPacketAcceptor {
    public long power = 0L;
    public int itemOutputTimer = 0;
    public static final int totalItemTime = 50;
    public static final long maxPower = 1000L;
    public int age = 0;
    public boolean needsUpdate = false;
    public FluidTank[] tanks;
    public Fluid[] tankTypes;
    private String customName;
    private long detectPower;
    private FluidTank[] detectTanks = new FluidTank[]{null, null, null, null, null};

    public TileEntityMachineRefinery() {
        super(12);
        this.tanks = new FluidTank[5];
        this.tankTypes = new Fluid[]{ModForgeFluids.hotoil, ModForgeFluids.heavyoil, ModForgeFluids.naphtha, ModForgeFluids.lightoil, ModForgeFluids.petroleum};
        this.tanks[0] = new FluidTank(64000);
        this.tanks[1] = new FluidTank(24000);
        this.tanks[2] = new FluidTank(24000);
        this.tanks[3] = new FluidTank(24000);
        this.tanks[4] = new FluidTank(24000);
    }

    @Override
    public String getName() {
        return "container.machineRefinery";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("f")) {
            this.tankTypes[0] = FluidRegistry.getFluid((String)nbt.func_74779_i("f"));
        }
        this.power = nbt.func_74763_f("power");
        this.itemOutputTimer = nbt.func_74762_e("itemOutputTimer");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.tankTypes[0] != null) {
            nbt.func_74778_a("f", this.tankTypes[0].getName());
        } else if (this.tanks[0].getFluid() != null) {
            nbt.func_74778_a("f", this.tanks[0].getFluid().getFluid().getName());
        }
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("itemOutputTimer", this.itemOutputTimer);
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(nbt);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            this.updateConnections();
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tanks[0], this.tanks[1], this.tanks[2], this.tanks[3], this.tanks[4]}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 1000L);
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 1 || this.age == 11) {
                this.fillFluidInit(this.tanks[1]);
            }
            if (this.age == 2 || this.age == 12) {
                this.fillFluidInit(this.tanks[2]);
            }
            if (this.age == 3 || this.age == 13) {
                this.fillFluidInit(this.tanks[3]);
            }
            if (this.age == 4 || this.age == 14) {
                this.fillFluidInit(this.tanks[4]);
            }
            if (this.inputValidForTank(0, 1)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 1, 2);
            }
            this.refine();
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 3, 4);
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[2], 5, 6);
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[3], 7, 8);
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[4], 9, 10);
            this.detectAndSendChanges();
        }
    }

    private void updateConnections() {
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 1), Library.POS_X);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, -1), Library.POS_X);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 1), Library.NEG_X);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, -1), Library.NEG_X);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, 2), Library.POS_Z);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, 2), Library.POS_Z);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, -2), Library.NEG_Z);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, -2), Library.NEG_Z);
    }

    private void setupTanks(FluidStack[] fluids) {
        if (fluids != null) {
            this.setTankType(1, fluids[0].getFluid());
            this.setTankType(2, fluids[1].getFluid());
            this.setTankType(3, fluids[2].getFluid());
            this.setTankType(4, fluids[3].getFluid());
        }
    }

    public void setTankType(int idx, Fluid type) {
        if (this.tankTypes[idx] != type) {
            this.tankTypes[idx] = type;
            if (type != null) {
                this.tanks[idx].setFluid(new FluidStack(type, 0));
            } else {
                this.tanks[idx].setFluid(null);
            }
        }
    }

    private void refine() {
        Tuple.Pair<FluidStack[], ItemStack> recipe = RefineryRecipes.getRecipe(this.tankTypes[0]);
        FluidStack[] outputFluids = recipe.getKey();
        ItemStack outputItem = recipe.getValue();
        this.setupTanks(outputFluids);
        if (this.power >= 5L && this.tanks[0].getFluidAmount() >= 100 && this.tanks[1].getFluidAmount() + outputFluids[0].amount <= this.tanks[1].getCapacity() && this.tanks[2].getFluidAmount() + outputFluids[1].amount <= this.tanks[2].getCapacity() && this.tanks[3].getFluidAmount() + outputFluids[2].amount <= this.tanks[3].getCapacity() && this.tanks[4].getFluidAmount() + outputFluids[3].amount <= this.tanks[4].getCapacity()) {
            this.tanks[0].drain(100, true);
            this.tanks[1].fill(outputFluids[0].copy(), true);
            this.tanks[2].fill(outputFluids[1].copy(), true);
            this.tanks[3].fill(outputFluids[2].copy(), true);
            this.tanks[4].fill(outputFluids[3].copy(), true);
            ++this.itemOutputTimer;
            this.power -= 5L;
            this.needsUpdate = true;
        }
        if (this.itemOutputTimer >= 50) {
            if (this.inventory.getStackInSlot(11).func_190926_b()) {
                this.inventory.setStackInSlot(11, outputItem.func_77946_l());
                this.itemOutputTimer = 0;
            } else if (!this.inventory.getStackInSlot(11).func_190926_b() && this.inventory.getStackInSlot(11).func_77973_b() == outputItem.func_77973_b() && this.inventory.getStackInSlot(11).func_190916_E() < this.inventory.getStackInSlot(11).func_77976_d()) {
                this.inventory.getStackInSlot(11).func_190917_f(1);
                this.itemOutputTimer = 0;
            }
        }
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectPower != this.power) {
            mark = true;
            this.detectPower = this.power;
        }
        if (!FFUtils.areTanksEqual(this.tanks[0], this.detectTanks[0])) {
            mark = true;
            this.needsUpdate = true;
            this.detectTanks[0] = FFUtils.copyTank(this.tanks[0]);
        }
        if (!FFUtils.areTanksEqual(this.tanks[1], this.detectTanks[1])) {
            mark = true;
            this.needsUpdate = true;
            this.detectTanks[1] = FFUtils.copyTank(this.tanks[1]);
        }
        if (!FFUtils.areTanksEqual(this.tanks[2], this.detectTanks[2])) {
            mark = true;
            this.needsUpdate = true;
            this.detectTanks[2] = FFUtils.copyTank(this.tanks[2]);
        }
        if (!FFUtils.areTanksEqual(this.tanks[3], this.detectTanks[3])) {
            mark = true;
            this.needsUpdate = true;
            this.detectTanks[3] = FFUtils.copyTank(this.tanks[3]);
        }
        if (!FFUtils.areTanksEqual(this.tanks[4], this.detectTanks[4])) {
            mark = true;
            this.needsUpdate = true;
            this.detectTanks[4] = FFUtils.copyTank(this.tanks[4]);
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
        if (mark) {
            this.func_70296_d();
        }
    }

    protected boolean inputValidForTank(int tank, int slot) {
        FluidStack containerFluid;
        if (!this.inventory.getStackInSlot(slot).func_190926_b() && (containerFluid = FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot))) != null && RefineryRecipes.getRecipe(containerFluid.getFluid()) != null) {
            this.setTankType(tank, containerFluid.getFluid());
            return true;
        }
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    }

    @Override
    public boolean canExtractItem(int i, ItemStack stack, int amount) {
        return i == 2 || i == 4 || i == 6 || i == 8 || i == 10 || i == 11;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000L;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000L;
    }

    public void fillFluidInit(FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, -2), 2000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, 2), 2000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, -2), 2000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, 2), 2000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 1), 2000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 1), 2000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, -1), 2000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, -1), 2000);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0], this.tanks[3].getTankProperties()[0], this.tanks[4].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.tankTypes[0] != null && resource.getFluid() == this.tankTypes[0]) {
            return this.tanks[0].fill(resource, doFill);
        }
        if (this.tanks[0].getFluidAmount() == 0 && RefineryRecipes.getRecipe(resource.getFluid()) != null) {
            this.tankTypes[0] = resource.getFluid();
            this.func_70296_d();
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (resource.isFluidEqual(this.tanks[1].getFluid())) {
            return this.tanks[1].drain(resource.amount, doDrain);
        }
        if (resource.isFluidEqual(this.tanks[2].getFluid())) {
            return this.tanks[2].drain(resource.amount, doDrain);
        }
        if (resource.isFluidEqual(this.tanks[3].getFluid())) {
            return this.tanks[3].drain(resource.amount, doDrain);
        }
        if (resource.isFluidEqual(this.tanks[4].getFluid())) {
            return this.tanks[4].drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tanks[1].getFluid() != null) {
            return this.tanks[1].drain(maxDrain, doDrain);
        }
        if (this.tanks[2].getFluid() != null) {
            return this.tanks[2].drain(maxDrain, doDrain);
        }
        if (this.tanks[3].getFluid() != null) {
            return this.tanks[3].drain(maxDrain, doDrain);
        }
        if (this.tanks[4].getFluid() != null) {
            return this.tanks[4].drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 5) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
        this.tanks[2].readFromNBT(tags[2]);
        this.tanks[3].readFromNBT(tags[3]);
        this.tanks[4].readFromNBT(tags[4]);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

