/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.inventory.PressRecipes;
import com.hbm.items.machine.ItemStamp;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEPressPacket;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMachinePress
extends TileEntityMachineBase
implements ITickable,
ICapabilityProvider {
    public int progress = 0;
    public int power = 0;
    public int burnTime = 0;
    public static final int maxProgress = 200;
    public static final int maxPower = 700;
    public int maxBurn = 160;
    public int item;
    public int meta;
    public boolean isRetracting = false;
    public boolean test = true;
    private int detectProgress;
    private int detectPower;
    private int detectBurnTime;
    private int detectMaxBurn;
    private boolean detectIsRetracting;

    public TileEntityMachinePress() {
        super(4);
    }

    public int getPowerScaled(int i) {
        return this.power * i / 700;
    }

    public int getBurnScaled(int i) {
        if (this.maxBurn == 0) {
            return 0;
        }
        return this.burnTime * i / this.maxBurn;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 200;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
        this.detectProgress = this.progress + 1;
        this.power = nbt.func_74762_e("power");
        this.detectPower = this.power + 1;
        this.burnTime = nbt.func_74762_e("burnTime");
        this.detectBurnTime = this.burnTime + 1;
        this.maxBurn = nbt.func_74762_e("maxBurn");
        this.detectMaxBurn = this.maxBurn + 1;
        this.isRetracting = nbt.func_74767_n("ret");
        boolean bl = this.detectIsRetracting = !this.isRetracting;
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("inventory"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("power", this.power);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("maxBurn", this.maxBurn);
        nbt.func_74757_a("ret", this.isRetracting);
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return nbt;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.burnTime > 0) {
                --this.burnTime;
                ++this.power;
                if (this.power > 700) {
                    this.power = 700;
                }
            } else if (this.power > 0) {
                --this.power;
            }
            if (this.field_145850_b.func_175687_A(this.field_174879_c) <= 0) {
                if (this.inventory.getStackInSlot(0) != ItemStack.field_190927_a && this.burnTime == 0 && TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(0)) > 0) {
                    this.maxBurn = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(0)) / 8;
                    ItemStack copy = this.inventory.getStackInSlot(0).func_77946_l();
                    this.inventory.getStackInSlot(0).func_190918_g(1);
                    if (this.inventory.getStackInSlot(0).func_190916_E() <= 0) {
                        if (copy.func_77973_b().func_77668_q() != null) {
                            this.inventory.setStackInSlot(0, new ItemStack(copy.func_77973_b().func_77668_q()));
                        } else {
                            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                        }
                    }
                }
                if (this.power >= 233) {
                    int speed = this.power * 25 / 700;
                    if (this.inventory.getStackInSlot(1) != ItemStack.field_190927_a && this.inventory.getStackInSlot(2) != ItemStack.field_190927_a) {
                        ItemStack stack = PressRecipes.getPressResult(this.inventory.getStackInSlot(2).func_77946_l(), this.inventory.getStackInSlot(1).func_77946_l());
                        if (stack != null && (this.inventory.getStackInSlot(3) == ItemStack.field_190927_a || this.inventory.getStackInSlot(3).func_77973_b() == stack.func_77973_b() && this.inventory.getStackInSlot(3).func_190916_E() + stack.func_190916_E() <= this.inventory.getStackInSlot(3).func_77976_d())) {
                            if (this.progress >= 200) {
                                this.isRetracting = true;
                                if (this.inventory.getStackInSlot(3) == ItemStack.field_190927_a) {
                                    this.inventory.setStackInSlot(3, stack.func_77946_l());
                                } else {
                                    this.inventory.getStackInSlot(3).func_190917_f(stack.func_190916_E());
                                }
                                this.inventory.getStackInSlot(2).func_190918_g(1);
                                if (this.inventory.getStackInSlot(2).func_190916_E() <= 0) {
                                    this.inventory.setStackInSlot(2, ItemStack.field_190927_a);
                                }
                                if (this.inventory.getStackInSlot(1).func_77958_k() > 0) {
                                    this.inventory.getStackInSlot(1).func_77964_b(this.inventory.getStackInSlot(1).func_77952_i() + 1);
                                    if (this.inventory.getStackInSlot(1).func_77952_i() >= this.inventory.getStackInSlot(1).func_77958_k()) {
                                        this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
                                    }
                                }
                                this.field_145850_b.func_184133_a(null, this.field_174879_c, HBMSoundHandler.pressOperate, SoundCategory.BLOCKS, 1.5f, 1.0f);
                            }
                            if (!this.isRetracting) {
                                this.progress += speed;
                            }
                        } else {
                            this.isRetracting = true;
                        }
                    } else {
                        this.isRetracting = true;
                    }
                    if (this.isRetracting) {
                        this.progress -= speed;
                    }
                } else {
                    this.isRetracting = true;
                }
                if (this.progress <= 0) {
                    this.isRetracting = false;
                    this.progress = 0;
                }
            }
            this.detectAndSendChanges();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return super.getCapability(capability, facing);
    }

    @Override
    public String getName() {
        return "container.press";
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        if (player.field_70170_p.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int[] nArray;
        int i = e.ordinal();
        if (i == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 3;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        }
        return nArray;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot == 3;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemStamp && i == 1) {
            return true;
        }
        if (TileEntityFurnace.func_145952_a((ItemStack)stack) > 0 && i == 0) {
            return true;
        }
        return i == 2;
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectProgress != this.progress) {
            mark = true;
            this.detectProgress = this.progress;
        }
        if (this.detectPower != this.power) {
            mark = true;
            this.detectPower = this.power;
        }
        if (this.detectBurnTime != this.burnTime) {
            mark = true;
            this.detectBurnTime = this.burnTime;
        }
        if (this.detectMaxBurn != this.maxBurn) {
            mark = true;
            this.detectMaxBurn = this.maxBurn;
        }
        if (this.detectIsRetracting != this.isRetracting) {
            mark = true;
            this.detectIsRetracting = this.isRetracting;
        }
        if (mark) {
            this.func_70296_d();
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEPressPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.inventory.getStackInSlot(2), this.progress), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
    }
}

