/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.machine.MachineDiFurnaceRTG;
import com.hbm.inventory.DiFurnaceRecipes;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.RTGUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileEntityDiFurnaceRTG
extends TileEntityMachineBase
implements ITickable,
ICapabilityProvider {
    public int rtgPower;
    public static final int maxRTGPower = 6000;
    public short progress;
    private static final short progressRequired = 2400;
    private static final int[] slots_top = new int[]{0, 1};
    private static final int[] slots_bottom = new int[]{2};
    private static final int[] slots_side = new int[]{3, 4, 5, 6, 7, 8};
    private boolean lastTrigger = false;

    public TileEntityDiFurnaceRTG() {
        super(9);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.progress = compound.func_74765_d("progress");
        this.rtgPower = compound.func_74762_e("rtgPower");
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT((NBTTagCompound)compound.func_74781_a("inventory"));
        }
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74777_a("progress", this.progress);
        compound.func_74768_a("rtgPower", this.rtgPower);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean trigger;
            this.rtgPower = Math.min(RTGUtil.updateRTGs(this.inventory, new int[]{3, 4, 5, 6, 7, 8}), 6000);
            if (this.hasPower() && this.canProcess()) {
                this.progress = (short)(this.progress + this.rtgPower);
                if (this.progress >= 2400) {
                    this.processItem();
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
            boolean bl = trigger = this.isProcessing() || this.canProcess() && this.hasPower();
            if (trigger != this.lastTrigger) {
                MachineDiFurnaceRTG.updateBlockState(trigger, this.field_145850_b, this.field_174879_c);
            }
            this.lastTrigger = trigger;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("progress", this.progress);
            data.func_74768_a("rtgPower", this.rtgPower);
            this.networkPack(data, 10);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.progress = nbt.func_74765_d("progress");
        this.rtgPower = nbt.func_74765_d("rtgPower");
    }

    @Override
    public String getName() {
        return "container.diFurnaceRTG";
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int i = e.ordinal();
        return i == 0 ? slots_bottom : (i == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return i != 2;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        if (slot == 0 && this.isItemValidForSlot(slot, itemStack)) {
            return this.inventory.getStackInSlot(1).func_77973_b() != itemStack.func_77973_b();
        }
        if (slot == 1 && this.isItemValidForSlot(slot, itemStack)) {
            return this.inventory.getStackInSlot(0).func_77973_b() != itemStack.func_77973_b();
        }
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot == 2;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.progress * i / 2400;
    }

    public int getPowerRemainingScaled(int i) {
        return this.rtgPower * i / 6000;
    }

    public int getPower() {
        return this.rtgPower;
    }

    public boolean canProcess() {
        if (this.inventory.getStackInSlot(0) == null || this.inventory.getStackInSlot(1) == null) {
            return false;
        }
        ItemStack itemStack = DiFurnaceRecipes.getFurnaceProcessingResult(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1));
        if (itemStack == null) {
            return false;
        }
        if (this.inventory.getStackInSlot(2) == ItemStack.field_190927_a) {
            return true;
        }
        if (this.inventory.getStackInSlot(2).func_77973_b() != ItemStack.field_190927_a.func_77973_b() && !this.inventory.getStackInSlot(2).func_77969_a(itemStack)) {
            return false;
        }
        if (this.inventory.getStackInSlot(2).func_190916_E() < this.inventory.getSlotLimit(2) && this.inventory.getStackInSlot(2).func_190916_E() < this.inventory.getStackInSlot(2).func_77976_d()) {
            return true;
        }
        return this.inventory.getStackInSlot(2).func_190916_E() < itemStack.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack itemStack = DiFurnaceRecipes.getFurnaceProcessingResult(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1));
            if (this.inventory.getStackInSlot(2).func_190926_b()) {
                this.inventory.setStackInSlot(2, itemStack.func_77946_l());
            } else if (this.inventory.getStackInSlot(2).func_77969_a(itemStack)) {
                this.inventory.getStackInSlot(2).func_190917_f(itemStack.func_190916_E());
            }
            for (int i = 0; i < 2; ++i) {
                if (this.inventory.getStackInSlot(i).func_190916_E() <= 0) {
                    this.inventory.setStackInSlot(i, new ItemStack(this.inventory.getStackInSlot(i).func_77973_b().func_77664_n()));
                } else {
                    this.inventory.getStackInSlot(i).func_190918_g(1);
                }
                if (this.inventory.getStackInSlot(i).func_190916_E() > 0) continue;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
            this.func_70296_d();
        }
    }

    public boolean hasPower() {
        return this.rtgPower > 0;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }
}

