/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.gear;

import com.hbm.config.PotionConfig;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemGeigerCounter;
import com.hbm.main.ClientProxy;
import com.hbm.packet.KeybindPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.RenderHelper;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.I18nUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmorFSB
extends ItemArmor {
    public static Field nextStepDistance = null;
    public static Field distanceWalkedOnStepModified = null;
    @SideOnly(value=Side.CLIENT)
    public static boolean flashlightPress;
    private String texture = "";
    private ResourceLocation overlay = null;
    public List<PotionEffect> effects = new ArrayList<PotionEffect>();
    public HashMap<String, Float> resistance = new HashMap();
    public float blastProtection = -1.0f;
    public float projectileProtection = -1.0f;
    public float damageCap = -1.0f;
    public float damageMod = -1.0f;
    public float damageThreshold = 0.0f;
    public float protectionYield = 50.0f;
    public boolean fireproof = false;
    public boolean noHelmet = false;
    public boolean vats = false;
    public boolean thermal = false;
    public boolean geigerSound = false;
    public boolean customGeiger = false;
    public boolean hardLanding = false;
    public Vec3d flashlightPosition = null;
    public double gravity = 0.0;
    public SoundEvent step;
    public SoundEvent jump;
    public SoundEvent fall;

    public ArmorFSB(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn, String texture, String name) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.texture = texture;
        ModItems.ALL_ITEMS.add((Item)this);
    }

    public static boolean hasFSBArmor(EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        ItemStack plate = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        if (plate != null && plate.func_77973_b() instanceof ArmorFSB) {
            ArmorFSB chestplate = (ArmorFSB)plate.func_77973_b();
            boolean noHelmet = chestplate.noHelmet;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                if (slot == EntityEquipmentSlot.MAINHAND || slot == EntityEquipmentSlot.OFFHAND || noHelmet && slot == EntityEquipmentSlot.HEAD) continue;
                ItemStack armor = entity.func_184582_a(slot);
                if (armor == null || !(armor.func_77973_b() instanceof ArmorFSB)) {
                    return false;
                }
                if (((ArmorFSB)armor.func_77973_b()).func_82812_d() != chestplate.func_82812_d()) {
                    return false;
                }
                if (((ArmorFSB)armor.func_77973_b()).isArmorEnabled(armor)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasFSBArmorHelmet(EntityLivingBase entity) {
        ItemStack plate = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        if (plate != null && plate.func_77973_b() instanceof ArmorFSB) {
            return !((ArmorFSB)plate.func_77973_b()).noHelmet && ArmorFSB.hasFSBArmor(entity);
        }
        return false;
    }

    public static boolean hasFSBArmorIgnoreCharge(EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        ItemStack plate = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        if (plate != null && plate.func_77973_b() instanceof ArmorFSB) {
            ArmorFSB chestplate = (ArmorFSB)plate.func_77973_b();
            boolean noHelmet = chestplate.noHelmet;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                if (slot == EntityEquipmentSlot.MAINHAND || slot == EntityEquipmentSlot.OFFHAND || noHelmet && slot == EntityEquipmentSlot.HEAD) continue;
                ItemStack armor = entity.func_184582_a(slot);
                if (armor == null || !(armor.func_77973_b() instanceof ArmorFSB)) {
                    return false;
                }
                if (((ArmorFSB)armor.func_77973_b()).func_82812_d() == chestplate.func_82812_d()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void handleAttack(LivingAttackEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (ArmorFSB.hasFSBArmor(e)) {
            ItemStack plate = e.func_184582_a(EntityEquipmentSlot.CHEST);
            ArmorFSB chestplate = (ArmorFSB)plate.func_77973_b();
            chestplate.handleAttack(event, chestplate);
        }
    }

    public void handleAttack(LivingAttackEvent event, ArmorFSB chestplate) {
        if (chestplate.damageThreshold >= event.getAmount() && !event.getSource().func_76363_c()) {
            event.setCanceled(true);
        }
        if (chestplate.fireproof && event.getSource().func_76347_k()) {
            event.getEntityLiving().func_70066_B();
            event.setCanceled(true);
        }
        if (chestplate.resistance.get(event.getSource().func_76355_l()) != null && chestplate.resistance.get(event.getSource().func_76355_l()).floatValue() <= 0.0f) {
            event.setCanceled(true);
        }
    }

    public static void handleHurt(LivingHurtEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (ArmorFSB.hasFSBArmor(e)) {
            ArmorFSB chestplate = (ArmorFSB)e.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b();
            chestplate.handleHurt(event, chestplate);
        }
    }

    public void handleHurt(LivingHurtEvent event, ArmorFSB chestplate) {
        float overFlow = Math.max(0.0f, event.getAmount() - chestplate.protectionYield);
        event.setAmount(Math.min(event.getAmount(), chestplate.protectionYield));
        if (!event.getSource().func_76363_c()) {
            event.setAmount(event.getAmount() - chestplate.damageThreshold);
        }
        if (chestplate.damageMod != -1.0f) {
            event.setAmount(event.getAmount() * chestplate.damageMod);
        }
        if (chestplate.resistance.get(event.getSource().func_76355_l()) != null) {
            event.setAmount(event.getAmount() * chestplate.resistance.get(event.getSource().func_76355_l()).floatValue());
        }
        if (chestplate.blastProtection != -1.0f && event.getSource().func_94541_c()) {
            event.setAmount(event.getAmount() * chestplate.blastProtection);
        }
        if (chestplate.projectileProtection != -1.0f && event.getSource().func_76352_a()) {
            event.setAmount(event.getAmount() * chestplate.projectileProtection);
        }
        if (chestplate.damageCap != -1.0f) {
            event.setAmount(Math.min(event.getAmount(), chestplate.damageCap));
        }
        event.setAmount(event.getAmount() + overFlow);
    }

    public boolean isArmorEnabled(ItemStack stack) {
        return true;
    }

    public static void handleTick(TickEvent.PlayerTickEvent event) {
        ArmorFSB.handleTick((EntityLivingBase)event.player, event.phase == TickEvent.Phase.START);
    }

    public static void handleTick(EntityLivingBase entity) {
        ArmorFSB.handleTick(entity, true);
    }

    public static void handleTick(EntityLivingBase entity, boolean isStart) {
        if (ArmorFSB.hasFSBArmor(entity)) {
            ItemStack plate = entity.func_184582_a(EntityEquipmentSlot.CHEST);
            ArmorFSB chestplate = (ArmorFSB)plate.func_77973_b();
            if (!chestplate.effects.isEmpty()) {
                for (PotionEffect i : chestplate.effects) {
                    entity.func_70690_d(new PotionEffect(i.func_188419_a(), i.func_76459_b(), i.func_76458_c(), i.func_82720_e(), i.func_188418_e()));
                }
            }
            if (!entity.func_70090_H() && (!(entity instanceof EntityPlayer) || entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75100_b)) {
                entity.field_70181_x -= chestplate.gravity;
            }
            if (chestplate.step != null && entity.field_70170_p.field_72995_K && entity.field_70122_E && isStart && !entity.func_70093_af()) {
                try {
                    int pz;
                    int py;
                    int px;
                    IBlockState block;
                    if (nextStepDistance == null) {
                        nextStepDistance = ReflectionHelper.findField(Entity.class, (String)"nextStepDistance", (String)"field_70150_b");
                    }
                    if (distanceWalkedOnStepModified == null) {
                        distanceWalkedOnStepModified = ReflectionHelper.findField(Entity.class, (String)"distanceWalkedOnStepModified", (String)"field_82151_R");
                    }
                    if (entity.getEntityData().func_74760_g("hfr_nextStepDistance") == 0.0f) {
                        entity.getEntityData().func_74776_a("hfr_nextStepDistance", nextStepDistance.getFloat(entity));
                    }
                    if ((block = entity.field_70170_p.func_180495_p(new BlockPos(px = MathHelper.func_76128_c((double)entity.field_70165_t), py = MathHelper.func_76128_c((double)(entity.field_70163_u - 0.2)), pz = MathHelper.func_76128_c((double)entity.field_70161_v)))).func_185904_a() != Material.field_151579_a && entity.getEntityData().func_74760_g("hfr_nextStepDistance") <= distanceWalkedOnStepModified.getFloat(entity)) {
                        entity.func_184185_a(chestplate.step, 1.0f, 1.0f);
                    }
                    entity.getEntityData().func_74776_a("hfr_nextStepDistance", nextStepDistance.getFloat(entity));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }

    public static void handleJump(EntityLivingBase entity) {
        if (ArmorFSB.hasFSBArmor(entity)) {
            ArmorFSB chestplate = (ArmorFSB)entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b();
            if (chestplate.jump != null) {
                entity.func_184185_a(chestplate.jump, 1.0f, 1.0f);
            }
        }
    }

    public static void handleFall(EntityLivingBase entity) {
        if (ArmorFSB.hasFSBArmor(entity)) {
            ArmorFSB chestplate = (ArmorFSB)entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b();
            if (chestplate.hardLanding && entity.field_70143_R > 10.0f) {
                List entities = entity.field_70170_p.func_72839_b((Entity)entity, entity.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0));
                for (Entity e : entities) {
                    Vec3 vec = Vec3.createVectorHelper(entity.field_70165_t - e.field_70165_t, 0.0, entity.field_70161_v - e.field_70161_v);
                    if (!(vec.lengthVector() < 3.0)) continue;
                    double intensity = 3.0 - vec.lengthVector();
                    e.field_70159_w += vec.xCoord * intensity * -2.0;
                    e.field_70181_x += 0.1 * intensity;
                    e.field_70179_y += vec.zCoord * intensity * -2.0;
                    e.func_70097_a(DamageSource.func_188403_a((Entity)e, (EntityLivingBase)entity).func_76348_h(), (float)(intensity * 10.0));
                }
            }
            if (chestplate.fall != null && (double)entity.field_70143_R > 0.25 && !entity.func_70093_af()) {
                entity.func_184185_a(chestplate.fall, 1.0f, 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClient(ItemStack stack, ArmorFSB fsbarmor, World world, Entity entity, int slot, boolean selected) {
        if (fsbarmor.flashlightPosition != null) {
            if (!flashlightPress && ClientProxy.fsbFlashlight.func_151470_d()) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new KeybindPacket(1));
            }
            flashlightPress = ClientProxy.fsbFlashlight.func_151470_d();
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity e, int itemSlot, boolean isSelected) {
        if (this.field_77881_a != EntityEquipmentSlot.CHEST || !(e instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        if (!ArmorFSB.hasFSBArmor(entity)) {
            return;
        }
        ArmorFSB fsbarmor = (ArmorFSB)entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b();
        if (world.field_72995_K) {
            this.updateClient(stack, fsbarmor, world, e, itemSlot, isSelected);
        }
        if (!fsbarmor.geigerSound || !(entity instanceof EntityPlayer)) {
            return;
        }
        ItemGeigerCounter.playGeiger(world, (EntityPlayer)entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleOverlay(RenderGameOverlayEvent.Pre event, EntityPlayer player) {
    }

    public ArmorFSB enableThermalSight(boolean thermal) {
        this.thermal = thermal;
        return this;
    }

    public ArmorFSB setHasGeigerSound(boolean geiger) {
        this.geigerSound = geiger;
        return this;
    }

    public ArmorFSB setHasCustomGeiger(boolean geiger) {
        this.customGeiger = geiger;
        return this;
    }

    public ArmorFSB setHasHardLanding(boolean hardLanding) {
        this.hardLanding = hardLanding;
        return this;
    }

    public ArmorFSB setGravity(double gravity) {
        this.gravity = gravity;
        return this;
    }

    public ArmorFSB setProtectionLevel(float damageYield) {
        this.protectionYield = damageYield;
        return this;
    }

    public ArmorFSB setBlastProtection(float blastProtection) {
        this.blastProtection = blastProtection;
        return this;
    }

    public ArmorFSB setProjectileProtection(float projectileProtection) {
        this.projectileProtection = projectileProtection;
        return this;
    }

    public ArmorFSB setStep(SoundEvent step) {
        this.step = step;
        return this;
    }

    public ArmorFSB setJump(SoundEvent jump) {
        this.jump = jump;
        return this;
    }

    public ArmorFSB setFall(SoundEvent fall) {
        this.fall = fall;
        return this;
    }

    public ArmorFSB addEffect(PotionEffect effect) {
        if (!PotionConfig.doJumpBoost && effect.func_188419_a() == MobEffects.field_76430_j) {
            return this;
        }
        this.effects.add(effect);
        return this;
    }

    public ArmorFSB addResistance(String damage, float mod) {
        this.resistance.put(damage, Float.valueOf(mod));
        return this;
    }

    public ArmorFSB setCap(float cap) {
        this.damageCap = cap;
        return this;
    }

    public ArmorFSB setMod(float mod) {
        this.damageMod = mod;
        return this;
    }

    public ArmorFSB setThreshold(float threshold) {
        this.damageThreshold = threshold;
        return this;
    }

    public ArmorFSB setFireproof(boolean fire) {
        this.fireproof = fire;
        return this;
    }

    public ArmorFSB setNoHelmet(boolean noHelmet) {
        this.noHelmet = noHelmet;
        return this;
    }

    public ArmorFSB enableVATS(boolean vats) {
        this.vats = vats;
        return this;
    }

    public ArmorFSB enableFlashlight(Vec3d pos) {
        this.flashlightPosition = pos;
        return this;
    }

    public ArmorFSB setOverlay(String path) {
        this.overlay = new ResourceLocation(path);
        return this;
    }

    public ArmorFSB cloneStats(ArmorFSB original) {
        this.effects = original.effects;
        this.resistance = original.resistance;
        this.damageCap = original.damageCap;
        this.damageMod = original.damageMod;
        this.damageThreshold = original.damageThreshold;
        this.protectionYield = original.protectionYield;
        this.blastProtection = original.blastProtection;
        this.projectileProtection = original.projectileProtection;
        this.fireproof = original.fireproof;
        this.noHelmet = original.noHelmet;
        this.vats = original.vats;
        this.thermal = original.thermal;
        this.geigerSound = original.geigerSound;
        this.customGeiger = original.customGeiger;
        this.hardLanding = original.hardLanding;
        this.gravity = original.gravity;
        this.step = original.step;
        this.jump = original.jump;
        this.fall = original.fall;
        this.flashlightPosition = original.flashlightPosition;
        return this;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return this.texture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.add(TextFormatting.GOLD + I18nUtil.resolveKey("armor.fullSetBonus", new Object[0]));
        if (!this.effects.isEmpty()) {
            for (PotionEffect potionEffect : this.effects) {
                list.add(TextFormatting.AQUA + "  " + I18n.func_135052_a((String)potionEffect.func_188419_a().func_76393_a(), (Object[])new Object[0]));
            }
        }
        if (!this.resistance.isEmpty()) {
            for (Map.Entry entry : this.resistance.entrySet()) {
                if (((Float)entry.getValue()).floatValue() != 0.0f) {
                    list.add(TextFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.damageModifier", entry.getValue(), I18n.func_135052_a((String)((String)entry.getKey()), (Object[])new Object[0])));
                    continue;
                }
                list.add(TextFormatting.RED + "  " + I18nUtil.resolveKey("armor.nullDamage", I18n.func_135052_a((String)((String)entry.getKey()), (Object[])new Object[0])));
            }
        }
        if (this.blastProtection != -1.0f) {
            list.add(TextFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.blastProtection", Float.valueOf(this.blastProtection)));
        }
        if (this.projectileProtection != -1.0f) {
            list.add(TextFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.projectileProtection", Float.valueOf(this.projectileProtection)));
        }
        if (this.damageCap != -1.0f) {
            list.add(TextFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.cap", Float.valueOf(this.damageCap)));
        }
        if (this.damageMod != -1.0f) {
            list.add(TextFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.modifier", Float.valueOf(this.damageMod)));
        }
        if (this.damageThreshold > 0.0f) {
            list.add(TextFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.threshold", Float.valueOf(this.damageThreshold)));
        }
        if (this.fireproof) {
            list.add(TextFormatting.RED + "  " + I18nUtil.resolveKey("armor.fireproof", new Object[0]));
        }
        if (this.geigerSound) {
            list.add(TextFormatting.GOLD + "  " + I18nUtil.resolveKey("armor.geigerSound", new Object[0]));
        }
        if (this.customGeiger) {
            list.add(TextFormatting.GOLD + "  " + I18nUtil.resolveKey("armor.geigerHUD", new Object[0]));
        }
        if (this.vats) {
            list.add(TextFormatting.RED + "  " + I18nUtil.resolveKey("armor.vats", new Object[0]));
        }
        if (this.thermal) {
            list.add(TextFormatting.RED + "  " + I18nUtil.resolveKey("armor.thermal", new Object[0]));
        }
        if (this.hardLanding) {
            list.add(TextFormatting.RED + "  " + I18nUtil.resolveKey("armor.hardLanding", new Object[0]));
        }
        if (this.gravity != 0.0) {
            list.add(TextFormatting.DARK_AQUA + "  " + I18nUtil.resolveKey("armor.gravity", this.gravity));
        }
        if (this.protectionYield > 0.0f) {
            list.add(TextFormatting.GREEN + "  " + I18nUtil.resolveKey("armor.yield", Float.valueOf(this.protectionYield)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks) {
        if (this.overlay == null) {
            return;
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.overlay);
        RenderHelper.startDrawingTexturedQuads();
        RenderHelper.addVertexWithUV(0.0, resolution.func_78328_b(), -90.0, 0.0, 1.0);
        RenderHelper.addVertexWithUV(resolution.func_78326_a(), resolution.func_78328_b(), -90.0, 1.0, 1.0);
        RenderHelper.addVertexWithUV(resolution.func_78326_a(), 0.0, -90.0, 1.0, 0.0);
        RenderHelper.addVertexWithUV(0.0, 0.0, -90.0, 0.0, 0.0);
        RenderHelper.draw();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

