/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.material;

import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;

public class NTMMaterial {
    public final int id;
    public String[] names;
    public MaterialShapes[] shapes = new MaterialShapes[0];
    public boolean omitItemGen = false;
    public SmeltingBehavior smeltable = SmeltingBehavior.NOT_SMELTABLE;
    public int solidColor = 16730624;
    public int moltenColor = 16730624;
    public NTMMaterial smeltsInto;
    public int convIn;
    public int convOut;

    public NTMMaterial(int id, OreDictManager.DictFrame dict) {
        this.names = dict.mats;
        this.id = id;
        this.smeltsInto = this;
        this.convIn = 1;
        this.convOut = 1;
        for (String name : dict.mats) {
            Mats.matByName.put(name, this);
        }
        Mats.orderedList.add(this);
        Mats.matById.put(id, this);
    }

    public String getUnlocalizedName() {
        return "hbmmat." + this.names[0].toLowerCase();
    }

    public NTMMaterial setConversion(NTMMaterial mat, int in, int out) {
        this.smeltsInto = mat;
        this.convIn = in;
        this.convOut = out;
        return this;
    }

    public NTMMaterial setShapes(MaterialShapes ... shapes) {
        this.shapes = shapes;
        return this;
    }

    public NTMMaterial omitAutoGen() {
        this.omitItemGen = true;
        return this;
    }

    public NTMMaterial smeltable(SmeltingBehavior behavior) {
        this.smeltable = behavior;
        return this;
    }

    public NTMMaterial setMoltenColor(int color) {
        this.moltenColor = color;
        return this;
    }

    public static enum SmeltingBehavior {
        NOT_SMELTABLE,
        VAPORIZES,
        BREAKS,
        SMELTABLE,
        ADDITIVE;

    }
}

