/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.regs;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.ForgeBlockContainer;
import com.endertech.minecraft.forge.items.ForgeStack;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.forge.materials.SmeltingRecipe;
import com.endertech.minecraft.forge.messages.Connection;
import com.endertech.minecraft.forge.regs.INeedRender;
import com.endertech.minecraft.forge.regs.IPostInit;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.IUnitWithMeshDefinition;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

public class ForgeRegistrator {
    public static final String FORMAT_REGISTERED = "registered: <{}>";
    public static final String FORMAT_REMAINS_UNREGISTERED = "remains UNREGISTERED: <{}>";
    public static final String FORMAT_SKIPPED = "SKIPPED: <{}>";
    public static final String FORMAT_INVALID = "INVALID: <{}>";
    public static final String FORMAT_NOT_FOUND = "NOT FOUND: <{}>";
    public static final String FORMAT_ALREADY_REGISTERED = "ALREADY REGISTERED: <{}>";
    public static boolean registerDisabledUnits = true;
    private final ForgeMod mod;
    private final SimpleNetworkWrapper channel;
    private final Connection connection;
    protected int discriminator = 0;
    protected List<IForgeUnit> unregisteredUnits = new ArrayList<IForgeUnit>();
    protected List<IForgeUnit> registeredUnits = new ArrayList<IForgeUnit>();
    protected Map<CraftingRecipe, CraftingRecipe> craftings = new HashMap<CraftingRecipe, CraftingRecipe>();
    protected List<SmeltingRecipe> smeltings = new ArrayList<SmeltingRecipe>();
    protected List<IGuiHandler> guiHandlers = new ArrayList<IGuiHandler>();
    protected List<IPostInit> postInits = new ArrayList<IPostInit>();

    public ForgeRegistrator(ForgeMod mod) {
        this.mod = mod;
        this.channel = NetworkRegistry.INSTANCE.newSimpleChannel(mod.getId());
        this.connection = new Connection(this.channel);
    }

    public void addUnit(IForgeUnit unit) {
        if (unit.isEnabled() || registerDisabledUnits) {
            this.unregisteredUnits.add(unit);
        }
    }

    public void removeUnit(IForgeUnit unit) {
        this.unregisteredUnits.remove(unit);
    }

    public void addGuiHandler(IGuiHandler handler) {
        this.guiHandlers.add(handler);
    }

    public void addBlockCrafting(String itemId, String blockId) {
        CraftingRecipe recipe = new CraftingRecipe("111 111 111", blockId, 1, itemId);
        this.addCrafting(recipe);
    }

    public void addBlockCrafting(IForgeUnit item, IForgeUnit block) {
        this.addBlockCrafting(item.getStringId(), block.getStringId());
    }

    public void addPostInit(IPostInit postInit) {
        this.postInits.add(postInit);
    }

    protected void registerGiuHandlers() {
        Iterator<IGuiHandler> iterator = this.guiHandlers.iterator();
        while (iterator.hasNext()) {
            IGuiHandler handler = iterator.next();
            NetworkRegistry.INSTANCE.registerGuiHandler((Object)this.mod, handler);
            iterator.remove();
        }
    }

    private Logger getLogger() {
        return this.mod.getLogger();
    }

    protected void registerRenders(Side side) {
        if (side == Side.CLIENT) {
            for (IForgeUnit unit : this.unregisteredUnits) {
                if (!(unit instanceof INeedRender)) continue;
                ((INeedRender)((Object)unit)).registerRender();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void registerUnits(Side side) {
        String format = "registered: <{}> as {}";
        Iterator<IForgeUnit> iterator = this.unregisteredUnits.iterator();
        while (true) {
            block15: {
                IForgeUnit unit;
                block14: {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    unit = iterator.next();
                    if (unit == null) break block14;
                    if (unit.isReadyToRegister()) {
                        ResourceLocation location = unit.getId().toResLoc();
                        if (unit instanceof Block) {
                            Block block = (Block)unit;
                            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
                            ItemBlock itemBlock = unit instanceof ForgeBlock ? ((ForgeBlock)block).createBlockItem() : new ItemBlock(block);
                            ForgeRegistries.ITEMS.register(itemBlock.setRegistryName(location));
                            if (side == Side.CLIENT) {
                                this.registerItemModel((Item)itemBlock);
                            }
                            if (!(unit instanceof IRelatedUnit)) {
                                OreDictionary.registerOre((String)unit.getId().getDictName(), (Block)block);
                            }
                            if (unit instanceof ForgeBlockContainer) {
                                ForgeBlockContainer container = (ForgeBlockContainer)unit;
                                this.registerTileEntity(container.getTileEntityClass(), container.getId().getRegName());
                            }
                            this.getLogger().debug("registered: <{}> as {}", (Object)unit.getId(), (Object)block.toString());
                        } else if (unit instanceof Item) {
                            Item item = (Item)unit;
                            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
                            if (side == Side.CLIENT) {
                                this.registerItemModel(item);
                            }
                            if (!(unit instanceof IRelatedUnit)) {
                                OreDictionary.registerOre((String)unit.getId().getDictName(), (Item)item);
                            }
                            this.getLogger().debug("registered: <{}> as {}", (Object)unit.getId(), (Object)item.toString());
                        } else {
                            this.getLogger().error("FAILED to register: '{}' is neither block nor item!", (Object)unit.getId());
                        }
                        if (unit.isRegistered()) {
                            this.registeredUnits.add(unit);
                        }
                        break block15;
                    } else {
                        this.getLogger().debug(FORMAT_SKIPPED, (Object)unit);
                        continue;
                    }
                }
                this.getLogger().error(FORMAT_SKIPPED, (Object)IForgeUnit.getStatus(unit));
            }
            iterator.remove();
        }
    }

    public void registerTileEntity(Class<? extends TileEntity> clazz, String name) {
        String unitName = UnitId.buildRegName(name, "tile");
        UnitId unitId = UnitId.from(this.mod.getId(), unitName);
        GameRegistry.registerTileEntity(clazz, (String)unitId.toString());
    }

    public void addCrafting(CraftingRecipe recipe) {
        this.addCrafting(recipe, null);
    }

    public void addCrafting(CraftingRecipe main, CraftingRecipe reserve) {
        this.craftings.put(main, reserve);
    }

    public void addSmelting(SmeltingRecipe recipe) {
        this.smeltings.add(recipe);
    }

    protected void processInits(Side side) {
        Iterator<IForgeUnit> iterator = this.registeredUnits.iterator();
        while (iterator.hasNext()) {
            IForgeUnit unit = iterator.next();
            if (unit != null) {
                if (unit.isRegistered()) {
                    unit.onInit();
                    if (side == Side.CLIENT) {
                        unit.onInitClient();
                    }
                } else {
                    this.getLogger().error("Attempt to init NOT REGISTERED unit: {}", (Object)unit);
                }
            }
            iterator.remove();
        }
    }

    public void onPreInit(FMLPreInitializationEvent event) {
        this.registerRenders(event.getSide());
        this.registerUnits(event.getSide());
    }

    public void onInit(FMLInitializationEvent event) {
        this.registerUnits(event.getSide());
        this.registerRecipes(false);
        this.registerGiuHandlers();
        this.processInits(event.getSide());
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        this.registerUnits(event.getSide());
        this.registerRecipes(false);
        this.registerRecipes(true);
        this.processInits(event.getSide());
        for (IPostInit iPostInit : this.postInits) {
            iPostInit.onPostInit(event);
        }
        this.postInits.clear();
        for (IForgeUnit iForgeUnit : this.unregisteredUnits) {
            this.getLogger().debug(FORMAT_REMAINS_UNREGISTERED, (Object)iForgeUnit);
        }
        for (Map.Entry entry : this.craftings.entrySet()) {
            this.getLogger().debug(FORMAT_REMAINS_UNREGISTERED, (Object)("MAIN: " + entry.getKey() + ", RESERVE: " + entry.getValue()));
        }
        for (SmeltingRecipe smeltingRecipe : this.smeltings) {
            this.getLogger().debug(FORMAT_REMAINS_UNREGISTERED, (Object)smeltingRecipe);
        }
        this.unregisteredUnits.clear();
        this.registeredUnits.clear();
        this.craftings.clear();
        this.smeltings.clear();
    }

    public <M extends IMessage, H extends IMessageHandler<M, IMessage>> void registerNetMessageHandledOnClient(Class<M> msgClass, Class<H> handlerClass) {
        this.channel.registerMessage(handlerClass, msgClass, this.discriminator++, Side.CLIENT);
    }

    public <M extends IMessage, H extends IMessageHandler<M, IMessage>> void registerNetMessageHandledOnServer(Class<M> msgClass, Class<H> handlerClass) {
        this.channel.registerMessage(handlerClass, msgClass, this.discriminator++, Side.SERVER);
    }

    public <M extends IMessage, H extends IMessageHandler<M, IMessage>> void registerNetMessageHandledOnBothSides(Class<M> msgClass, Class<H> handlerClass) {
        this.registerNetMessageHandledOnClient(msgClass, handlerClass);
        this.registerNetMessageHandledOnServer(msgClass, handlerClass);
    }

    public void registerInEventBus(Object target) {
        MinecraftForge.EVENT_BUS.register(target);
    }

    public <T extends Entity> void registerRenderingHandler(Class<T> entityClass, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, renderFactory);
    }

    protected void registerRecipes(boolean useReserve) {
        this.registerCraftings(useReserve);
        this.registerSmeltings();
    }

    protected void registerCraftings(boolean useReserve) {
        Iterator<Map.Entry<CraftingRecipe, CraftingRecipe>> iterator = this.craftings.entrySet().iterator();
        while (iterator.hasNext()) {
            CraftingRecipe recipe;
            Map.Entry<CraftingRecipe, CraftingRecipe> entry = iterator.next();
            CraftingRecipe craftingRecipe = recipe = useReserve ? entry.getValue() : entry.getKey();
            if (recipe != null && recipe.isValid()) {
                if (!recipe.isReadyToRegister()) continue;
                ForgeStack outputStack = recipe.getOutputStack();
                ResourceLocation name = new ResourceLocation(recipe.getId().getModId(), outputStack.toString());
                if (recipe.isShapeless()) {
                    ArrayList<Ingredient> ingredientsList = new ArrayList<Ingredient>();
                    for (Object obj : recipe.getParams()) {
                        Ingredient ingredient = CraftingHelper.getIngredient((Object)obj);
                        ingredientsList.add(ingredient);
                    }
                    GameRegistry.addShapelessRecipe((ResourceLocation)name, null, (ItemStack)outputStack.toItemStack(), (Ingredient[])ingredientsList.toArray(new Ingredient[0]));
                } else {
                    GameRegistry.addShapedRecipe((ResourceLocation)name, null, (ItemStack)outputStack.toItemStack(), (Object[])recipe.getParams());
                }
                iterator.remove();
                continue;
            }
            if (recipe == null) continue;
            this.getLogger().error(FORMAT_INVALID, (Object)recipe);
            iterator.remove();
        }
    }

    protected void registerSmeltings() {
        Iterator<SmeltingRecipe> iterator = this.smeltings.iterator();
        while (iterator.hasNext()) {
            SmeltingRecipe recipe = iterator.next();
            if (recipe != null && recipe.isValid()) {
                if (!recipe.isReadyToRegister()) continue;
                GameRegistry.addSmelting((ItemStack)recipe.getInputStack().toItemStack(), (ItemStack)recipe.getOutputStack().toItemStack(), (float)recipe.getSmeltingData().getXp());
                iterator.remove();
                continue;
            }
            if (recipe == null) continue;
            this.getLogger().error(FORMAT_INVALID, (Object)recipe);
            iterator.remove();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel(Item item) {
        Block block;
        IForgeUnit unit = null;
        if (item instanceof ItemBlock && (block = ((ItemBlock)item).func_179223_d()) instanceof IForgeUnit) {
            unit = (IForgeUnit)block;
        }
        if (item instanceof IForgeUnit) {
            unit = (IForgeUnit)item;
        }
        if (unit != null) {
            if (unit instanceof IUnitWithMeshDefinition) {
                ItemMeshDefinition definition = ((IUnitWithMeshDefinition)((Object)unit)).getItemMeshDefinition();
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)definition);
                if (unit.getUnitVariants().isEmpty()) {
                    ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{unit.getDefaultVariant().toModelResLoc()});
                } else {
                    for (UnitVariant variant : unit.getUnitVariants().values()) {
                        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{variant.toModelResLoc()});
                    }
                }
            } else if (unit.getUnitVariants().isEmpty()) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)unit.getId().getMeta(), (ModelResourceLocation)unit.getDefaultVariant().toModelResLoc());
            } else {
                for (UnitVariant variant : unit.getUnitVariants().values()) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)variant.getId().getMeta(), (ModelResourceLocation)variant.toModelResLoc());
                }
            }
        } else {
            UnitId id = UnitId.from(item);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)id.getMeta(), (ModelResourceLocation)id.toModelResLoc_Inventory());
        }
    }

    public <T extends Entity> void registerEntity(Class<T> entityClass, int trackingRange, int updateFrequency, boolean sendVelocity) {
        String entityName = entityClass.getSimpleName();
        ResourceLocation registryName = UnitId.from(this.mod.getId(), entityName).toResLoc();
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)entityName, (int)this.discriminator++, (Object)this.mod, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocity);
    }

    public Connection getConnection() {
        return this.connection;
    }
}

