/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.quest;

import CoroUtil.quest.PlayerQuests;
import CoroUtil.quest.quests.ActiveQuest;
import CoroUtil.util.CoroUtilEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerQuestManager {
    public HashMap<String, PlayerQuests> playerQuests = new HashMap();
    private static PlayerQuestManager serverManager;
    private static PlayerQuestManager clientManager;

    public static PlayerQuestManager i() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (serverManager == null) {
                serverManager = new PlayerQuestManager();
            }
            return serverManager;
        }
        if (clientManager == null) {
            clientManager = new PlayerQuestManager();
        }
        return clientManager;
    }

    public void check(String username) {
        if (!this.playerQuests.containsKey(username)) {
            PlayerQuests quests = new PlayerQuests(this, username);
            this.playerQuests.put(username, quests);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                quests.diskLoadFromFile();
            }
        }
    }

    public PlayerQuests getPlayerQuests(String username) {
        this.check(username);
        return this.playerQuests.get(username);
    }

    public PlayerQuests getPlayerQuests(EntityPlayer entP) {
        this.check(CoroUtilEntity.getName((Entity)entP));
        return this.playerQuests.get(CoroUtilEntity.getName((Entity)entP));
    }

    public void tick(World parWorld) {
        for (int i = 0; i < parWorld.field_73010_i.size(); ++i) {
            EntityPlayer entP = (EntityPlayer)parWorld.field_73010_i.get(i);
            this.check(CoroUtilEntity.getName((Entity)entP));
            this.playerQuests.get(CoroUtilEntity.getName((Entity)entP)).tick(parWorld);
        }
    }

    public void clearQuests(World parWorld, boolean save, String username) {
        if (username == null || username.equals("")) {
            for (int i = 0; i < parWorld.field_73010_i.size(); ++i) {
                EntityPlayer entP = (EntityPlayer)parWorld.field_73010_i.get(i);
                if (!this.playerQuests.containsKey(CoroUtilEntity.getName((Entity)entP))) continue;
                this.playerQuests.get(CoroUtilEntity.getName((Entity)entP)).questsClearAll();
            }
        } else if (this.playerQuests.containsKey(username)) {
            this.playerQuests.get(username).questsClearAll();
        }
        if (save) {
            this.saveData(true, false);
        }
    }

    public void markQuestCompleteForAll(World parWorld, ActiveQuest quest) {
        for (int i = 0; i < parWorld.field_73010_i.size(); ++i) {
            EntityPlayer entP = (EntityPlayer)parWorld.field_73010_i.get(i);
            this.check(CoroUtilEntity.getName((Entity)entP));
            this.playerQuests.get(CoroUtilEntity.getName((Entity)entP)).questRemove(quest);
        }
    }

    public void onEvent(Event event) {
        for (Map.Entry<String, PlayerQuests> entry : this.playerQuests.entrySet()) {
            entry.getValue().onEvent(event);
        }
    }

    public void saveData(boolean andSync, boolean andUnload) {
        for (Map.Entry<String, PlayerQuests> entry : this.playerQuests.entrySet()) {
            if (andSync) {
                entry.getValue().saveAndSyncPlayer();
            } else {
                entry.getValue().diskSaveToFile();
            }
            if (!andUnload) continue;
            entry.getValue().reset();
        }
    }

    public void reset() {
        for (Map.Entry<String, PlayerQuests> entry : this.playerQuests.entrySet()) {
            entry.getValue().reset();
        }
        this.playerQuests.clear();
    }
}

