/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimatedObject;
import minecrafttransportsimulator.jsondefs.JSONLight;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.AModelParser;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.rendering.RenderableObject;
import minecrafttransportsimulator.rendering.TreadRoller;
import minecrafttransportsimulator.systems.ConfigSystem;

public class RenderableModelObject {
    protected final String modelLocation;
    public final RenderableObject object;
    private final boolean isWindow;
    private final boolean isOnlineTexture;
    private final RenderableObject interiorWindowObject;
    private RenderableObject colorObject;
    private RenderableObject coverObject;
    private final Map<JSONLight, RenderableObject> flareObjects = new HashMap<JSONLight, RenderableObject>();
    private final Map<JSONLight, RenderableObject> beamObjects = new HashMap<JSONLight, RenderableObject>();
    private static final Map<String, Map<Integer, Map<Float, List<Double[]>>>> treadPoints = new HashMap<String, Map<Integer, Map<Float, List<Double[]>>>>();
    private static final TransformationMatrix treadPathBaseTransform = new TransformationMatrix();
    private static final RotationMatrix treadRotation = new RotationMatrix();
    private static final float COLOR_OFFSET = 2.0E-4f;
    private static final float FLARE_OFFSET = 4.0E-4f;
    private static final float COVER_OFFSET = 5.9999997E-4f;
    private static final float BEAM_OFFSET = -0.15f;
    private static final int BEAM_SEGMENTS = 40;

    public RenderableModelObject(String modelLocation, RenderableObject object) {
        this.modelLocation = modelLocation;
        this.isWindow = object.name.toLowerCase(Locale.ROOT).contains("window");
        boolean bl = this.isOnlineTexture = object.name.toLowerCase(Locale.ROOT).startsWith("url") || object.name.toLowerCase(Locale.ROOT).endsWith("url");
        if (this.isWindow) {
            this.object = new RenderableObject(object.name, "mts:textures/rendering/glass.png", object.color, object.vertices, false);
            this.object.normalizeUVs();
            this.interiorWindowObject = new RenderableObject(object.name + "_interior", "mts:textures/rendering/glass.png", object.color, FloatBuffer.allocate(object.vertices.capacity()), false);
            float[] vertexSet = new float[8];
            for (int i = object.vertices.capacity() - 8; i >= 0; i -= 8) {
                object.vertices.get(vertexSet);
                this.interiorWindowObject.vertices.position(i);
                this.interiorWindowObject.vertices.put(vertexSet);
            }
            object.vertices.rewind();
            this.interiorWindowObject.vertices.position(0);
            this.interiorWindowObject.vertices.limit(object.vertices.limit());
        } else {
            this.object = object;
            this.interiorWindowObject = null;
        }
        if (object.name.startsWith("&")) {
            this.colorObject = RenderableModelObject.generateColors(object);
            this.coverObject = RenderableModelObject.generateCovers(object);
        }
    }

    public void render(AEntityD_Definable<?> entity, TransformationMatrix transform, boolean blendingEnabled, float partialTicks) {
        JSONLight lightDef;
        JSONAnimatedObject objectDef = entity.animatedObjectDefinitions.get(this.object.name);
        if (this.shouldRender(entity, objectDef, lightDef = entity.lightObjectDefinitions.get(this.object.name), blendingEnabled, partialTicks)) {
            AnimationSwitchbox switchbox = entity.animatedObjectSwitchboxes.get(this.object.name);
            if (objectDef == null || objectDef.blendedAnimations || switchbox == null || switchbox.runSwitchbox(partialTicks, false)) {
                JSONText textDef;
                if (objectDef != null && objectDef.blendedAnimations && switchbox != null) {
                    switchbox.runSwitchbox(partialTicks, false);
                }
                float lightLevel = lightDef != null ? entity.lightBrightnessValues.get(lightDef).floatValue() : 0.0f;
                this.object.worldLightValue = entity.worldLightValue;
                this.object.transform.set(transform);
                if (switchbox != null) {
                    this.object.transform.multiply(switchbox.netMatrix);
                }
                if (!this.isWindow) {
                    this.object.texture = entity.getTexture();
                }
                if (this.isOnlineTexture) {
                    for (Map.Entry<JSONText, String> textEntry : entity.text.entrySet()) {
                        textDef = textEntry.getKey();
                        if (textDef.fieldName == null || !this.object.name.contains(textDef.fieldName)) continue;
                        String textValue = entity.text.get(textDef);
                        if (textValue.isEmpty() || textValue.contains(" ")) break;
                        String errorString = InterfaceManager.renderingInterface.downloadURLTexture(textValue);
                        if (errorString != null) {
                            textEntry.setValue(errorString);
                            break;
                        }
                        this.object.texture = textValue;
                        break;
                    }
                }
                if (lightDef != null) {
                    lightLevel = entity.lightBrightnessValues.get(lightDef).floatValue();
                    if (lightDef.isElectric && entity instanceof EntityVehicleF_Physics) {
                        double electricPower = ((EntityVehicleF_Physics)entity).electricPower;
                        if (electricPower < 3.0) {
                            lightLevel = 0.0f;
                        } else if (electricPower < 10.0) {
                            lightLevel = (float)((double)lightLevel * ((electricPower - 3.0) / 7.0));
                        }
                    }
                }
                if (entity instanceof PartGroundDevice && ((JSONPart)((PartGroundDevice)entity).definition).ground.isTread && !((PartGroundDevice)entity).isSpare) {
                    if (!blendingEnabled) {
                        this.doTreadRendering((PartGroundDevice)entity, partialTicks);
                    }
                } else {
                    if (blendingEnabled && lightDef != null && lightLevel > 0.0f && lightDef.isBeam && entity.shouldRenderBeams()) {
                        this.object.disableLighting = (Boolean)ConfigSystem.client.renderingSettings.brightLights.value;
                        this.object.enableBrightBlending = (Boolean)ConfigSystem.client.renderingSettings.blendedLights.value;
                        this.object.setAlpha(Math.min((1.0f - entity.world.getLightBrightness(entity.position, false)) * lightLevel, 1.0f));
                        this.object.render(entity);
                    } else if (blendingEnabled == this.object.isTranslucent) {
                        boolean bl = this.object.disableLighting = (Boolean)ConfigSystem.client.renderingSettings.brightLights.value != false && lightDef != null && lightLevel > 0.0f && !lightDef.emissive && !lightDef.isBeam;
                        if (blendingEnabled && objectDef != null && objectDef.blendedAnimations && switchbox != null && switchbox.lastVisibilityClock != null) {
                            if (switchbox.lastVisibilityValue < (double)switchbox.lastVisibilityClock.animation.clampMin) {
                                this.object.setAlpha(0.0f);
                            } else if (switchbox.lastVisibilityValue >= (double)switchbox.lastVisibilityClock.animation.clampMax) {
                                this.object.setAlpha(1.0f);
                            } else {
                                this.object.setAlpha((float)(switchbox.lastVisibilityValue - (double)switchbox.lastVisibilityClock.animation.clampMin) / (switchbox.lastVisibilityClock.animation.clampMax - switchbox.lastVisibilityClock.animation.clampMin));
                            }
                        }
                        this.object.render(entity);
                        if (this.interiorWindowObject != null && ((Boolean)ConfigSystem.client.renderingSettings.innerWindows.value).booleanValue()) {
                            this.interiorWindowObject.worldLightValue = this.object.worldLightValue;
                            this.interiorWindowObject.transform.set(this.object.transform);
                            this.interiorWindowObject.render(entity);
                        }
                    }
                    if (lightDef != null && !lightDef.isBeam) {
                        this.doLightRendering(entity, lightDef, lightLevel, entity.lightColorValues.get(lightDef), blendingEnabled);
                    }
                    if (!blendingEnabled) {
                        for (Map.Entry<JSONText, String> textEntry : entity.text.entrySet()) {
                            textDef = textEntry.getKey();
                            if (!this.object.name.equals(textDef.attachedTo)) continue;
                            RenderText.draw3DText(textEntry.getValue(), entity, this.object.transform, textDef, false);
                        }
                    }
                }
            }
        }
    }

    public void destroy(AEntityD_Definable<?> entity) {
        this.object.destroy(entity);
        treadPoints.remove(this.modelLocation);
    }

    private boolean shouldRender(AEntityD_Definable<?> entity, JSONAnimatedObject objectDef, JSONLight lightDef, boolean blendingEnabled, float partialTicks) {
        if (this.object.isTranslucent && !blendingEnabled) {
            return false;
        }
        if (this.isWindow && !((Boolean)ConfigSystem.client.renderingSettings.renderWindows.value).booleanValue()) {
            return false;
        }
        if (this.isOnlineTexture) {
            for (JSONText textDef : entity.text.keySet()) {
                if (textDef.fieldName == null || !this.object.name.contains(textDef.fieldName)) continue;
                if (!entity.text.get(textDef).isEmpty()) break;
                return false;
            }
        }
        if (!(lightDef == null || !blendingEnabled || this.object.isTranslucent || lightDef.emissive || lightDef.isBeam || lightDef.blendableComponents != null && !lightDef.blendableComponents.isEmpty())) {
            return false;
        }
        if (objectDef != null && objectDef.applyAfter != null) {
            AnimationSwitchbox switchbox = entity.animatedObjectSwitchboxes.get(objectDef.applyAfter);
            if (switchbox == null) {
                throw new IllegalArgumentException("Was told to applyAfter the object " + objectDef.applyAfter + " on " + ((AJSONMultiModelProvider)entity.definition).packID + ":" + ((AJSONMultiModelProvider)entity.definition).systemName + " for the object " + this.object.name + ", but there aren't any animations to applyAfter!");
            }
            return switchbox.runSwitchbox(partialTicks, false);
        }
        return true;
    }

    private void doTreadRendering(PartGroundDevice tread, float partialTicks) {
        float treadLinearPosition;
        float treadMovementPercentage;
        List<Double[]> points;
        Map<Float, List<Double[]>> treadPointsSubMap;
        String treadPathModel = ((AJSONPartProvider)tread.entityOn.definition).getModelLocation(tread.entityOn.subDefinition);
        Map<Integer, Map<Float, List<Double[]>>> treadPointsMap = treadPoints.get(treadPathModel);
        if (treadPointsMap == null) {
            treadPointsMap = new HashMap<Integer, Map<Float, List<Double[]>>>();
        }
        if ((treadPointsSubMap = treadPointsMap.get(tread.placementSlot)) == null) {
            treadPointsSubMap = new HashMap<Float, List<Double[]>>();
        }
        if ((points = treadPointsSubMap.get(Float.valueOf(((JSONPart)tread.definition).ground.spacing))) == null) {
            points = RenderableModelObject.generateTreads(tread.entityOn, treadPathModel, treadPointsSubMap, tread);
            treadPointsSubMap.put(Float.valueOf(((JSONPart)tread.definition).ground.spacing), points);
            treadPointsMap.put(tread.placementSlot, treadPointsSubMap);
            treadPoints.put(treadPathModel, treadPointsMap);
        }
        if ((treadMovementPercentage = (treadLinearPosition = (float)(tread.getRawVariableValue("ground_rotation", partialTicks) / 360.0)) % ((JSONPart)tread.definition).ground.spacing / ((JSONPart)tread.definition).ground.spacing) < 0.0f) {
            treadMovementPercentage += 1.0f;
        }
        if (!(tread.entityOn instanceof APart)) {
            this.object.transform.applyTranslation(0.0, -tread.localOffset.y, -tread.localOffset.z);
        }
        Double[] point = points.get(0);
        this.object.transform.applyTranslation(0.0, point[0], point[1]);
        boolean[] renderIndexes = null;
        if (((JSONPart)tread.definition).ground.treadOrder != null) {
            double treadCycleTotalDistance;
            int treadCycleCount = ((JSONPart)tread.definition).ground.treadOrder.size();
            int treadCycleIndex = (int)Math.floor((double)treadCycleCount * ((double)treadLinearPosition % (treadCycleTotalDistance = (double)((float)treadCycleCount * ((JSONPart)tread.definition).ground.spacing)) / treadCycleTotalDistance));
            if (treadCycleIndex < 0) {
                treadCycleIndex += treadCycleCount;
            }
            renderIndexes = new boolean[treadCycleCount];
            for (int i = 0; i < treadCycleCount; ++i) {
                String treadObject = ((JSONPart)tread.definition).ground.treadOrder.get(i);
                renderIndexes[(i + treadCycleIndex) % treadCycleCount] = treadObject.equals(this.object.name);
            }
        }
        for (int i = 0; i < points.size() - 1; ++i) {
            double angleDelta;
            Double[] nextPoint;
            point = points.get(i);
            if (i == points.size() - 1) {
                nextPoint = points.get(0);
                angleDelta = nextPoint[2] + 360.0 - point[2];
            } else {
                nextPoint = points.get(i + 1);
                angleDelta = nextPoint[2] - point[2];
            }
            double yDelta = nextPoint[0] - point[0];
            double zDelta = nextPoint[1] - point[1];
            if (angleDelta > 180.0) {
                angleDelta -= 360.0;
            } else if (angleDelta < -180.0) {
                angleDelta += 360.0;
            }
            if (renderIndexes != null && !renderIndexes[i % renderIndexes.length]) {
                this.object.transform.applyTranslation(0.0, yDelta, zDelta);
                continue;
            }
            this.object.transform.applyTranslation(0.0, yDelta * (double)treadMovementPercentage, zDelta * (double)treadMovementPercentage);
            if (point[2] != 0.0 || angleDelta != 0.0) {
                treadPathBaseTransform.set(this.object.transform);
                treadRotation.setToAxisAngle(1.0, 0.0, 0.0, point[2] + angleDelta * (double)treadMovementPercentage);
                this.object.transform.applyRotation(treadRotation);
                this.object.render(tread);
                this.object.transform.set(treadPathBaseTransform);
            } else {
                this.object.render(tread);
            }
            this.object.transform.applyTranslation(0.0, yDelta * (double)(1.0f - treadMovementPercentage), zDelta * (double)(1.0f - treadMovementPercentage));
        }
    }

    private void doLightRendering(AEntityD_Definable<?> entity, JSONLight lightDef, float lightLevel, ColorRGB color, boolean blendingEnabled) {
        float blendableBrightness;
        if (blendingEnabled && lightLevel > 0.0f && lightDef.emissive) {
            if (this.colorObject == null) {
                for (RenderableObject testObject : AModelParser.parseModel(this.modelLocation)) {
                    if (!this.object.name.equals(testObject.name)) continue;
                    this.colorObject = RenderableModelObject.generateColors(testObject);
                    break;
                }
            }
            this.colorObject.worldLightValue = this.object.worldLightValue;
            this.colorObject.disableLighting = (Boolean)ConfigSystem.client.renderingSettings.brightLights.value;
            this.colorObject.setColor(color);
            this.colorObject.setAlpha(lightLevel);
            this.colorObject.transform.set(this.object.transform);
            this.colorObject.render(entity);
        }
        if (blendingEnabled && lightLevel > 0.0f && lightDef.blendableComponents != null && !lightDef.blendableComponents.isEmpty() && (blendableBrightness = Math.min((1.0f - entity.world.getLightBrightness(entity.position, false)) * lightLevel, 1.0f)) > 0.0f) {
            RenderableObject flareObject = this.flareObjects.get(lightDef);
            RenderableObject beamObject = this.beamObjects.get(lightDef);
            if (flareObject == null && beamObject == null) {
                ArrayList<JSONLight.JSONLightBlendableComponent> flareDefs = new ArrayList<JSONLight.JSONLightBlendableComponent>();
                ArrayList<JSONLight.JSONLightBlendableComponent> beamDefs = new ArrayList<JSONLight.JSONLightBlendableComponent>();
                for (JSONLight.JSONLightBlendableComponent component : lightDef.blendableComponents) {
                    if (component.flareHeight > 0.0f) {
                        flareDefs.add(component);
                    }
                    if (!(component.beamDiameter > 0.0f)) continue;
                    beamDefs.add(component);
                }
                if (!flareDefs.isEmpty()) {
                    flareObject = RenderableModelObject.generateFlares(flareDefs);
                    this.flareObjects.put(lightDef, flareObject);
                }
                if (!beamDefs.isEmpty()) {
                    beamObject = RenderableModelObject.generateBeams(beamDefs);
                    this.beamObjects.put(lightDef, beamObject);
                }
            }
            if (flareObject != null) {
                flareObject.isTranslucent = true;
                flareObject.worldLightValue = this.object.worldLightValue;
                flareObject.disableLighting = (Boolean)ConfigSystem.client.renderingSettings.brightLights.value;
                flareObject.setColor(color);
                flareObject.setAlpha(blendableBrightness);
                flareObject.transform.set(this.object.transform);
                flareObject.render(entity);
            }
            if (beamObject != null && entity.shouldRenderBeams()) {
                beamObject.isTranslucent = true;
                beamObject.worldLightValue = this.object.worldLightValue;
                beamObject.disableLighting = (Boolean)ConfigSystem.client.renderingSettings.brightLights.value;
                beamObject.enableBrightBlending = (Boolean)ConfigSystem.client.renderingSettings.blendedLights.value;
                beamObject.setColor(color);
                beamObject.setAlpha(blendableBrightness);
                beamObject.transform.set(this.object.transform);
                beamObject.render(entity);
            }
        }
        if (!blendingEnabled && lightDef.covered) {
            if (this.coverObject == null) {
                for (RenderableObject testObject : AModelParser.parseModel(this.modelLocation)) {
                    if (!this.object.name.equals(testObject.name)) continue;
                    this.coverObject = RenderableModelObject.generateCovers(testObject);
                    break;
                }
            }
            this.coverObject.worldLightValue = this.object.worldLightValue;
            this.coverObject.disableLighting = (Boolean)ConfigSystem.client.renderingSettings.brightLights.value != false && lightLevel > 0.0f;
            this.coverObject.transform.set(this.object.transform);
            this.coverObject.render(entity);
        }
    }

    private static RenderableObject generateColors(RenderableObject parsedObject) {
        RenderableObject offsetObject = new RenderableObject("color", "mts:textures/rendering/light.png", new ColorRGB(), FloatBuffer.allocate(parsedObject.vertices.capacity()), false);
        float[] vertexData = new float[8];
        while (parsedObject.vertices.hasRemaining()) {
            parsedObject.vertices.get(vertexData);
            offsetObject.vertices.put(vertexData, 0, 5);
            offsetObject.vertices.put(vertexData[5] + vertexData[0] * 2.0E-4f);
            offsetObject.vertices.put(vertexData[6] + vertexData[1] * 2.0E-4f);
            offsetObject.vertices.put(vertexData[7] + vertexData[2] * 2.0E-4f);
        }
        parsedObject.vertices.rewind();
        offsetObject.normalizeUVs();
        offsetObject.vertices.flip();
        return offsetObject;
    }

    private static RenderableObject generateCovers(RenderableObject parsedObject) {
        RenderableObject offsetObject = new RenderableObject("cover", "mts:textures/rendering/glass.png", parsedObject.color, FloatBuffer.allocate(parsedObject.vertices.capacity()), false);
        float[] vertexData = new float[8];
        while (parsedObject.vertices.hasRemaining()) {
            parsedObject.vertices.get(vertexData);
            offsetObject.vertices.put(vertexData, 0, 5);
            offsetObject.vertices.put(vertexData[5] + vertexData[0] * 5.9999997E-4f);
            offsetObject.vertices.put(vertexData[6] + vertexData[1] * 5.9999997E-4f);
            offsetObject.vertices.put(vertexData[7] + vertexData[2] * 5.9999997E-4f);
        }
        parsedObject.vertices.rewind();
        offsetObject.normalizeUVs();
        offsetObject.vertices.flip();
        return offsetObject;
    }

    private static RenderableObject generateFlares(List<JSONLight.JSONLightBlendableComponent> flareDefs) {
        RenderableObject flareObject = new RenderableObject("flares", "mts:textures/rendering/lensflare.png", new ColorRGB(), FloatBuffer.allocate(flareDefs.size() * 6 * 8), false);
        for (JSONLight.JSONLightBlendableComponent flareDef : flareDefs) {
            RotationMatrix rotation = new RotationMatrix().setToVector(flareDef.axis, false);
            Point3D vertexOffset = new Point3D();
            Point3D centerOffset = flareDef.axis.copy().scale(4.0E-4f).add(flareDef.pos);
            for (int j = 0; j < 6; ++j) {
                float[] newVertex = new float[8];
                switch (j) {
                    case 0: 
                    case 3: {
                        newVertex[3] = 0.0f;
                        newVertex[4] = 0.0f;
                        break;
                    }
                    case 1: {
                        newVertex[3] = 0.0f;
                        newVertex[4] = 1.0f;
                        break;
                    }
                    case 2: 
                    case 4: {
                        newVertex[3] = 1.0f;
                        newVertex[4] = 1.0f;
                        break;
                    }
                    case 5: {
                        newVertex[3] = 1.0f;
                        newVertex[4] = 0.0f;
                    }
                }
                vertexOffset.x = (double)newVertex[3] == 0.0 ? (double)(-flareDef.flareWidth) / 2.0 : (double)flareDef.flareWidth / 2.0;
                vertexOffset.y = (double)newVertex[4] == 0.0 ? (double)flareDef.flareHeight / 2.0 : (double)(-flareDef.flareHeight) / 2.0;
                vertexOffset.z = 0.0;
                vertexOffset.rotate(rotation).add(centerOffset);
                newVertex[5] = (float)vertexOffset.x;
                newVertex[6] = (float)vertexOffset.y;
                newVertex[7] = (float)vertexOffset.z;
                newVertex[0] = (float)flareDef.axis.x;
                newVertex[1] = (float)flareDef.axis.y;
                newVertex[2] = (float)flareDef.axis.z;
                flareObject.vertices.put(newVertex);
            }
        }
        flareObject.vertices.flip();
        return flareObject;
    }

    private static RenderableObject generateBeams(List<JSONLight.JSONLightBlendableComponent> beamDefs) {
        RenderableObject beamObject = new RenderableObject("beams", "mts:textures/rendering/lightbeam.png", new ColorRGB(), FloatBuffer.allocate(beamDefs.size() * 2 * 40 * 3 * 8), false);
        for (JSONLight.JSONLightBlendableComponent beamDef : beamDefs) {
            RotationMatrix rotation = new RotationMatrix().setToVector(beamDef.axis, false);
            Point3D vertexOffset = new Point3D();
            Point3D centerOffset = beamDef.axis.copy().scale(-0.15f).add(beamDef.pos);
            for (int j = -40; j < 40; ++j) {
                for (int k = 0; k < 3; ++k) {
                    double currentAngleRad;
                    float[] newVertex = new float[8];
                    switch (k % 3) {
                        case 0: {
                            newVertex[3] = 0.0f;
                            newVertex[4] = 0.0f;
                            break;
                        }
                        case 1: {
                            newVertex[3] = 0.0f;
                            newVertex[4] = 1.0f;
                            break;
                        }
                        case 2: {
                            newVertex[3] = 1.0f;
                            newVertex[4] = 1.0f;
                        }
                    }
                    if (j < 0) {
                        currentAngleRad = newVertex[3] == 0.0f ? Math.PI * 2 * ((double)(j + 1) / 40.0) : Math.PI * 2 * ((double)j / 40.0);
                    } else {
                        double d = currentAngleRad = newVertex[3] == 0.0f ? Math.PI * 2 * ((double)j / 40.0) : Math.PI * 2 * ((double)(j + 1) / 40.0);
                    }
                    if ((double)newVertex[4] == 0.0) {
                        vertexOffset.set(0.0, 0.0, 0.0);
                    } else {
                        vertexOffset.x = (double)(beamDef.beamDiameter / 2.0f) * Math.cos(currentAngleRad);
                        vertexOffset.y = (double)(beamDef.beamDiameter / 2.0f) * Math.sin(currentAngleRad);
                        vertexOffset.z = beamDef.beamLength;
                    }
                    vertexOffset.rotate(rotation).add(centerOffset);
                    newVertex[5] = (float)vertexOffset.x;
                    newVertex[6] = (float)vertexOffset.y;
                    newVertex[7] = (float)vertexOffset.z;
                    newVertex[0] = 0.0f;
                    newVertex[1] = 0.0f;
                    newVertex[2] = 0.0f;
                    beamObject.vertices.put(newVertex);
                }
            }
        }
        beamObject.vertices.flip();
        return beamObject;
    }

    private static <TreadEntity extends AEntityD_Definable<?>> List<Double[]> generateTreads(TreadEntity entityTreadAttachedTo, String treadPathModel, Map<Float, List<Double[]>> treadPointsMap, PartGroundDevice tread) {
        int i;
        List<RenderableObject> parsedModel = AModelParser.parseModel(((AJSONMultiModelProvider)entityTreadAttachedTo.definition).getModelLocation(((AJSONMultiModelProvider)entityTreadAttachedTo.definition).definitions.get(0)));
        ArrayList<TreadRoller> rollers = new ArrayList<TreadRoller>();
        if (tread.placementDefinition.treadPath == null) {
            throw new IllegalArgumentException("No tread path found for part slot on " + entityTreadAttachedTo + "!");
        }
        for (String rollerName : tread.placementDefinition.treadPath) {
            boolean foundRoller = false;
            for (RenderableObject modelObject : parsedModel) {
                if (!modelObject.name.equals(rollerName)) continue;
                rollers.add(new TreadRoller(modelObject));
                foundRoller = true;
                break;
            }
            if (foundRoller) continue;
            throw new IllegalArgumentException("Could not create tread path for " + entityTreadAttachedTo + " Due to missing roller " + rollerName + " in the model!");
        }
        for (i = 0; i < rollers.size(); ++i) {
            if (i < rollers.size() - 1) {
                ((TreadRoller)rollers.get(i)).calculateEndpoints((TreadRoller)rollers.get(i + 1));
                continue;
            }
            ((TreadRoller)rollers.get(i)).calculateEndpoints((TreadRoller)rollers.get(0));
        }
        ((TreadRoller)rollers.get(0)).setEndAngle(180.0);
        for (i = 1; i < rollers.size(); ++i) {
            TreadRoller roller = (TreadRoller)rollers.get(i);
            TreadRoller priorRoller = (TreadRoller)rollers.get(i - 1);
            double d = roller.startAngle = i == 1 ? 180.0 : priorRoller.endAngle;
            while (roller.endAngle < roller.startAngle - 30.0) {
                roller.endAngle += 360.0;
            }
            while (roller.endAngle > roller.startAngle + 330.0) {
                roller.endAngle -= 360.0;
            }
            if (roller.endAngle < roller.startAngle) {
                double midPoint;
                roller.startAngle = midPoint = roller.endAngle + (roller.startAngle - roller.endAngle) / 2.0;
                roller.endAngle = midPoint;
            }
            roller.setStartAngle(roller.startAngle);
            roller.setEndAngle(roller.endAngle);
        }
        ((TreadRoller)rollers.get(0)).setStartAngle(((TreadRoller)rollers.get((int)(rollers.size() - 1))).endAngle);
        double totalPathLength = 0.0;
        for (int i2 = 0; i2 < rollers.size(); ++i2) {
            TreadRoller roller = (TreadRoller)rollers.get(i2);
            double angleDelta = roller.endAngle - roller.startAngle;
            if (i2 == 0) {
                angleDelta += 360.0;
            }
            totalPathLength += Math.PI * 2 * roller.radius * angleDelta / 360.0;
            TreadRoller nextRoller = i2 == rollers.size() - 1 ? (TreadRoller)rollers.get(0) : (TreadRoller)rollers.get(i2 + 1);
            double straightPathLength = Math.hypot(nextRoller.startY - roller.endY, nextRoller.startZ - roller.endZ);
            if (tread.placementDefinition.treadDroopConstant > 0.0f && (roller.endAngle % 360.0 < 10.0 || roller.endAngle % 360.0 > 350.0) && (nextRoller.startAngle % 360.0 < 10.0 || nextRoller.startAngle % 360.0 > 350.0)) {
                totalPathLength += 2.0 * (double)tread.placementDefinition.treadDroopConstant * Math.sinh(straightPathLength / 2.0 / (double)tread.placementDefinition.treadDroopConstant);
                continue;
            }
            totalPathLength += straightPathLength;
        }
        double deltaDist = (double)((JSONPart)tread.definition).ground.spacing + totalPathLength % (double)((JSONPart)tread.definition).ground.spacing / (totalPathLength / (double)((JSONPart)tread.definition).ground.spacing);
        double leftoverPathLength = 0.0;
        double yPoint = 0.0;
        double zPoint = 0.0;
        ArrayList<Double[]> points = new ArrayList<Double[]>();
        for (int i3 = 0; i3 < rollers.size(); ++i3) {
            TreadRoller roller = (TreadRoller)rollers.get(i3);
            double currentAngle = roller.startAngle;
            double angleDelta = roller.endAngle - roller.startAngle;
            if (i3 == 0) {
                angleDelta += 360.0;
            }
            double rollerPathLength = Math.PI * 2 * roller.radius * angleDelta / 360.0;
            if (i3 == 0) {
                yPoint = roller.centerPoint.y + roller.radius * Math.cos(Math.toRadians(currentAngle));
                zPoint = roller.centerPoint.z + roller.radius * Math.sin(Math.toRadians(currentAngle));
                points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0});
            }
            if (deltaDist - leftoverPathLength < rollerPathLength) {
                if (leftoverPathLength > 0.0) {
                    currentAngle -= 360.0 * leftoverPathLength / roller.circumference;
                    rollerPathLength += leftoverPathLength;
                    leftoverPathLength = 0.0;
                }
                while (rollerPathLength > deltaDist) {
                    rollerPathLength -= deltaDist;
                    yPoint = roller.centerPoint.y + roller.radius * Math.cos(Math.toRadians(currentAngle += 360.0 * (deltaDist / roller.circumference)));
                    zPoint = roller.centerPoint.z + roller.radius * Math.sin(Math.toRadians(currentAngle));
                    points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0});
                }
            }
            currentAngle = roller.endAngle;
            TreadRoller nextRoller = i3 == rollers.size() - 1 ? (TreadRoller)rollers.get(0) : (TreadRoller)rollers.get(i3 + 1);
            double straightPathLength = Math.hypot(nextRoller.startY - roller.endY, nextRoller.startZ - roller.endZ);
            double extraPathLength = rollerPathLength + leftoverPathLength;
            double normalizedY = (nextRoller.startY - roller.endY) / straightPathLength;
            double normalizedZ = (nextRoller.startZ - roller.endZ) / straightPathLength;
            if (tread.placementDefinition.treadDroopConstant > 0.0f && (roller.endAngle % 360.0 < 10.0 || roller.endAngle % 360.0 > 350.0) && (nextRoller.startAngle % 360.0 < 10.0 || nextRoller.startAngle % 360.0 > 350.0)) {
                double catenaryPathLength = 2.0 * (double)tread.placementDefinition.treadDroopConstant * Math.sinh(straightPathLength / 2.0 / (double)tread.placementDefinition.treadDroopConstant);
                double catenaryPathEdgeY = (double)tread.placementDefinition.treadDroopConstant * Math.cosh(straightPathLength / 2.0 / (double)tread.placementDefinition.treadDroopConstant);
                double catenaryFunctionCurrent = -catenaryPathLength / 2.0;
                double startingCatenaryPathLength = catenaryPathLength;
                while (catenaryPathLength + extraPathLength > deltaDist) {
                    if (extraPathLength > 0.0) {
                        catenaryFunctionCurrent += deltaDist - extraPathLength;
                        catenaryPathLength -= deltaDist - extraPathLength;
                        extraPathLength = 0.0;
                    } else {
                        catenaryFunctionCurrent += deltaDist;
                        catenaryPathLength -= deltaDist;
                    }
                    double value = catenaryFunctionCurrent / (double)tread.placementDefinition.treadDroopConstant;
                    double arcSin = catenaryFunctionCurrent == 0.0 ? 0.0 : Math.log(value + Math.sqrt(value * value + 1.0));
                    double catenaryFunctionPercent = (catenaryFunctionCurrent + startingCatenaryPathLength / 2.0) / startingCatenaryPathLength;
                    double catenaryPointZ = (double)tread.placementDefinition.treadDroopConstant * arcSin;
                    double catenaryPointY = (double)tread.placementDefinition.treadDroopConstant * Math.cosh(catenaryPointZ / (double)tread.placementDefinition.treadDroopConstant);
                    yPoint = roller.endY + normalizedY * catenaryFunctionPercent + catenaryPointY - catenaryPathEdgeY;
                    zPoint = roller.endZ + catenaryPointZ + straightPathLength / 2.0;
                    points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0 - Math.toDegrees(Math.asin(catenaryFunctionCurrent / (double)tread.placementDefinition.treadDroopConstant))});
                }
                leftoverPathLength = catenaryPathLength;
                continue;
            }
            while (straightPathLength + extraPathLength > deltaDist) {
                if (extraPathLength > 0.0) {
                    yPoint = roller.endY + normalizedY * (deltaDist - extraPathLength);
                    zPoint = roller.endZ + normalizedZ * (deltaDist - extraPathLength);
                    straightPathLength -= deltaDist - extraPathLength;
                    extraPathLength = 0.0;
                } else {
                    yPoint += normalizedY * deltaDist;
                    zPoint += normalizedZ * deltaDist;
                    straightPathLength -= deltaDist;
                }
                points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0});
            }
            leftoverPathLength = straightPathLength;
        }
        return points;
    }
}

