/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.blocks.tileentities.instances.ATileEntityFuelPump;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketTileEntityFuelPumpConnection
extends APacketEntity<ATileEntityFuelPump> {
    private final UUID linkedID;

    public PacketTileEntityFuelPumpConnection(ATileEntityFuelPump pump) {
        super(pump);
        this.linkedID = null;
    }

    public PacketTileEntityFuelPumpConnection(ATileEntityFuelPump pump, EntityVehicleF_Physics connectedVehicle) {
        super(pump);
        this.linkedID = connectedVehicle.uniqueUUID;
    }

    public PacketTileEntityFuelPumpConnection(ByteBuf buf) {
        super(buf);
        this.linkedID = buf.readBoolean() ? PacketTileEntityFuelPumpConnection.readUUIDFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        if (this.linkedID != null) {
            buf.writeBoolean(true);
            PacketTileEntityFuelPumpConnection.writeUUIDToBuffer(this.linkedID, buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    protected boolean handle(AWrapperWorld world, ATileEntityFuelPump pump) {
        if (this.linkedID != null) {
            EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)world.getEntity(this.linkedID);
            if (vehicle != null) {
                pump.setConnection(vehicle);
            }
        } else {
            pump.setConnection(null);
        }
        return true;
    }
}

