/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONPack;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONSkin;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.packloading.PackParser;

public class GUIPackEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Font MAIN_BUTTON_FONT = new Font("Arial", 1, 30);
    private static final Font NORMAL_FONT = new Font("Arial", 0, 15);
    private static final Dimension NUMBER_TEXT_BOX_DIM = new Dimension(100, NORMAL_FONT.getSize() + 5);
    private static final Dimension STRING_TEXT_BOX_DIM = new Dimension(200, NORMAL_FONT.getSize() + 5);
    private static final GridBagConstraints LABEL_CONSTRAINTS = new GridBagConstraints();
    private static final GridBagConstraints FIELD_CONSTRAINTS = new GridBagConstraints();
    private static File lastFileAccessed = new File(InterfaceManager.gameDirectory);
    private Class<?> currentJSONClass = null;
    private Object currentJSON = null;
    private final JPanel editingPanel;

    public GUIPackEditor() {
        this.setTitle("MTS Pack Edtior");
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        long displaySize = InterfaceManager.clientInterface.getPackedDisplaySize();
        this.setMaximumSize(new Dimension((int)(displaySize >> 32), (int)displaySize));
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new FlowLayout());
        filePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2), "File Selection", 1, 2, NORMAL_FONT));
        this.add((Component)filePanel, "First");
        JButton newButton = new JButton();
        newButton.setEnabled(false);
        newButton.setFont(MAIN_BUTTON_FONT);
        newButton.setText("New JSON");
        newButton.addActionListener(event -> {
            try {
                this.currentJSON = this.currentJSONClass.newInstance();
                if (this.currentJSON != null) {
                    this.initEditor();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        filePanel.add(newButton);
        JButton openButton = new JButton();
        openButton.setEnabled(false);
        openButton.setFont(MAIN_BUTTON_FONT);
        openButton.setText("Open JSON");
        openButton.addActionListener(event -> {
            JFileChooser fileSelection = lastFileAccessed != null ? new JFileChooser(lastFileAccessed.getParent()) : new JFileChooser();
            fileSelection.setFont(MAIN_BUTTON_FONT);
            fileSelection.setDialogTitle(openButton.getText());
            if (fileSelection.showOpenDialog(filePanel) == 0) {
                try {
                    File file = fileSelection.getSelectedFile();
                    this.currentJSON = JSONParser.parseStream(Files.newInputStream(file.toPath(), new OpenOption[0]), this.currentJSONClass, null, null);
                    lastFileAccessed = file;
                    if (this.currentJSON != null) {
                        this.initEditor();
                        lastFileAccessed = file;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        filePanel.add(openButton);
        JButton saveButton = new JButton();
        saveButton.setEnabled(false);
        saveButton.setFont(MAIN_BUTTON_FONT);
        saveButton.setText("Save JSON");
        saveButton.addActionListener(event -> {
            block7: {
                JFileChooser fileSelection = lastFileAccessed != null ? new JFileChooser(lastFileAccessed.getParent()) : new JFileChooser();
                fileSelection.setApproveButtonText("Save");
                fileSelection.setApproveButtonToolTipText("Saves the JSON in the editor to the file.");
                fileSelection.setFont(MAIN_BUTTON_FONT);
                fileSelection.setDialogTitle(saveButton.getText());
                if (lastFileAccessed != null) {
                    fileSelection.setSelectedFile(lastFileAccessed);
                }
                if (fileSelection.showOpenDialog(filePanel) == 0) {
                    try {
                        File file = fileSelection.getSelectedFile();
                        JSONParser.exportStream(this.currentJSON, Files.newOutputStream(file.toPath(), new OpenOption[0]));
                        lastFileAccessed = file;
                        try {
                            if (!(this.currentJSON instanceof AJSONItem)) break block7;
                            AJSONItem definition = (AJSONItem)this.currentJSON;
                            if (definition.packID == null || definition.systemName == null) break block7;
                            if (definition instanceof AJSONMultiModelProvider) {
                                JOptionPane.showMessageDialog(null, JSONParser.importJSON(file, ((AItemPack)PackParser.getItem((String)definition.packID, (String)definition.systemName, (String)((AJSONMultiModelProvider)definition).definitions.get((int)0).subName)).definition, false));
                                JSONParser.applyImports(InterfaceManager.clientInterface.getClientWorld());
                                break block7;
                            }
                            JOptionPane.showMessageDialog(null, JSONParser.importJSON(file, ((AItemPack)PackParser.getItem((String)definition.packID, (String)definition.systemName)).definition, false));
                            JSONParser.applyImports(InterfaceManager.clientInterface.getClientWorld());
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        filePanel.add(saveButton);
        LinkedHashMap<String, Class<JSONSkin>> jsonClasses = new LinkedHashMap<String, Class<JSONSkin>>();
        jsonClasses.put("JSON Type - Select first!.", null);
        jsonClasses.put(JSONPack.class.getSimpleName(), JSONPack.class);
        jsonClasses.put(JSONVehicle.class.getSimpleName(), JSONVehicle.class);
        jsonClasses.put(JSONPart.class.getSimpleName(), JSONPart.class);
        jsonClasses.put(JSONInstrument.class.getSimpleName(), JSONInstrument.class);
        jsonClasses.put(JSONDecor.class.getSimpleName(), JSONDecor.class);
        jsonClasses.put(JSONPoleComponent.class.getSimpleName(), JSONPoleComponent.class);
        jsonClasses.put(JSONSkin.class.getSimpleName(), JSONSkin.class);
        JComboBox<Object> typeComboBox = new JComboBox<Object>();
        typeComboBox.setFont(MAIN_BUTTON_FONT);
        typeComboBox.setAlignmentX(0.0f);
        for (String className : jsonClasses.keySet()) {
            typeComboBox.addItem(className);
        }
        typeComboBox.setRenderer(GUIPackEditor.generateClassTooltipRenderer(jsonClasses.values().toArray(new Class[jsonClasses.size()])));
        typeComboBox.addActionListener(e -> {
            this.currentJSONClass = (Class)jsonClasses.get(typeComboBox.getSelectedItem());
            if (this.currentJSONClass != null) {
                newButton.setEnabled(true);
                openButton.setEnabled(true);
                saveButton.setEnabled(true);
            } else {
                newButton.setEnabled(false);
                openButton.setEnabled(false);
                saveButton.setEnabled(false);
            }
        });
        filePanel.add(typeComboBox);
        this.editingPanel = new JPanel();
        this.editingPanel.setLayout(new GridBagLayout());
        JScrollPane editingPane = new JScrollPane();
        editingPane.add(this.editingPanel);
        editingPane.setViewportView(this.editingPanel);
        editingPane.getVerticalScrollBar().setUnitIncrement(20);
        this.add((Component)editingPane, "Center");
        GUIPackEditor.LABEL_CONSTRAINTS.anchor = 22;
        GUIPackEditor.FIELD_CONSTRAINTS.anchor = 21;
        GUIPackEditor.FIELD_CONSTRAINTS.gridwidth = 0;
        this.pack();
        this.setVisible(true);
    }

    private void initEditor() {
        this.editingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2), "Editing: " + this.currentJSON.getClass().getSimpleName(), 1, 2, NORMAL_FONT));
        this.editingPanel.removeAll();
        GUIPackEditor.populatePanel(this.editingPanel, this.currentJSON);
        this.pack();
    }

    private static void populatePanel(JPanel panel, Object objectToParse) {
        for (Field field : objectToParse.getClass().getFields()) {
            if (!field.isAnnotationPresent(JSONParser.JSONDescription.class)) continue;
            JComponent newComponent = null;
            try {
                FieldChanger listenter = new FieldChanger(field, objectToParse);
                newComponent = field.isAnnotationPresent(JSONParser.JSONDefaults.class) ? GUIPackEditor.createNewStringBox(field.getAnnotation(JSONParser.JSONDefaults.class).value(), listenter) : GUIPackEditor.getComponentForObject(field.get(objectToParse), field.getType(), listenter, listenter);
                if (newComponent == null) {
                    newComponent = GUIPackEditor.getComponentForField(field, objectToParse);
                } else {
                    listenter.component = newComponent;
                    if (field.isAnnotationPresent(JSONParser.JSONRequired.class)) {
                        newComponent.setBackground(Color.CYAN);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newComponent == null) continue;
            String annotationText = field.getAnnotation(JSONParser.JSONDescription.class).value();
            JLabel componentLabel = new JLabel(field.getName() + ":");
            componentLabel.setFont(NORMAL_FONT);
            panel.add((Component)componentLabel, LABEL_CONSTRAINTS);
            componentLabel.setToolTipText(GUIPackEditor.formatTooltipText(annotationText));
            panel.add((Component)newComponent, FIELD_CONSTRAINTS);
        }
    }

    private static JComponent getComponentForField(Field field, Object declaringObject) {
        Object obj;
        try {
            obj = field.get(declaringObject);
        }
        catch (Exception e) {
            return null;
        }
        Class<?> fieldClass = field.getType();
        if (List.class.isAssignableFrom(fieldClass)) {
            if (obj == null) {
                obj = new ArrayList();
                try {
                    field.set(declaringObject, obj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Class paramClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            List listObject = (List)obj;
            JPanel listObjectPanel = new JPanel();
            listObjectPanel.setLayout(new BorderLayout());
            listObjectPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2), field.getName(), 1, 2, NORMAL_FONT));
            JPanel listContentsPanel = new JPanel();
            listContentsPanel.setLayout(new BoxLayout(listContentsPanel, 1));
            for (Object listEntry : listObject) {
                ListElementPanel newPanel = new ListElementPanel(listContentsPanel, listObject, listEntry);
                listContentsPanel.add(newPanel);
            }
            listObjectPanel.add((Component)listContentsPanel, "Center");
            JButton newEntryButton = new JButton();
            newEntryButton.setFont(NORMAL_FONT);
            newEntryButton.setText("New Entry");
            newEntryButton.addActionListener(event -> {
                try {
                    Object listEntry = GUIPackEditor.createNewObjectInstance(paramClass, declaringObject);
                    listObject.add(listEntry);
                    ListElementPanel newPanel = new ListElementPanel(listContentsPanel, listObject, listEntry);
                    listContentsPanel.add(newPanel);
                    listContentsPanel.revalidate();
                    listContentsPanel.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            listObjectPanel.add((Component)newEntryButton, "First");
            return listObjectPanel;
        }
        if (obj == null) {
            obj = GUIPackEditor.createNewObjectInstance(fieldClass, declaringObject);
            try {
                field.set(declaringObject, obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JPanel subPanel = new JPanel();
        subPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2), field.getName(), 1, 2, NORMAL_FONT));
        subPanel.setFont(NORMAL_FONT);
        subPanel.setLayout(new GridBagLayout());
        GUIPackEditor.populatePanel(subPanel, obj);
        return subPanel;
    }

    private static JComponent getComponentForObject(Object obj, Class<?> objectClass, FocusListener focusListener, ActionListener actionListener) {
        if (objectClass.equals(Boolean.TYPE)) {
            JCheckBox checkBox = new JCheckBox();
            checkBox.setSelected((Boolean)obj);
            checkBox.addActionListener(actionListener);
            return checkBox;
        }
        if (objectClass.equals(Integer.TYPE) || objectClass.equals(Integer.class)) {
            JTextField textBox = new JTextField();
            textBox.setFont(NORMAL_FONT);
            textBox.setText(String.valueOf(obj));
            textBox.setPreferredSize(NUMBER_TEXT_BOX_DIM);
            textBox.addFocusListener(focusListener);
            return textBox;
        }
        if (objectClass.equals(Float.TYPE) || objectClass.equals(Float.class)) {
            JTextField textBox = new JTextField();
            textBox.setFont(NORMAL_FONT);
            textBox.setText(String.valueOf(obj));
            textBox.setPreferredSize(NUMBER_TEXT_BOX_DIM);
            textBox.addFocusListener(focusListener);
            return textBox;
        }
        if (objectClass.equals(String.class)) {
            JTextField textBox = new JTextField();
            textBox.setPreferredSize(STRING_TEXT_BOX_DIM);
            if (obj != null) {
                textBox.setText(String.valueOf(obj));
            } else {
                textBox.setText("");
            }
            textBox.addFocusListener(focusListener);
            return textBox;
        }
        if (objectClass.equals(Point3D.class)) {
            JPanel pointPanel = new JPanel();
            pointPanel.setLayout(new FlowLayout());
            pointPanel.setBorder(BorderFactory.createLoweredBevelBorder());
            pointPanel.addFocusListener(focusListener);
            JLabel xLabel = new JLabel("X:");
            xLabel.setFont(NORMAL_FONT);
            JTextField xText = new JTextField();
            xText.setPreferredSize(NUMBER_TEXT_BOX_DIM);
            xText.addFocusListener(new FocusForwarder(focusListener));
            JLabel yLabel = new JLabel("Y:");
            yLabel.setFont(NORMAL_FONT);
            JTextField yText = new JTextField();
            yText.setPreferredSize(NUMBER_TEXT_BOX_DIM);
            yText.addFocusListener(new FocusForwarder(focusListener));
            JLabel zLabel = new JLabel("Z:");
            zLabel.setFont(NORMAL_FONT);
            JTextField zText = new JTextField();
            zText.setPreferredSize(NUMBER_TEXT_BOX_DIM);
            zText.addFocusListener(new FocusForwarder(focusListener));
            if (obj != null) {
                Point3D point = (Point3D)obj;
                xText.setText(String.valueOf(point.x));
                yText.setText(String.valueOf(point.y));
                zText.setText(String.valueOf(point.z));
            } else {
                xText.setText(String.valueOf(0.0));
                yText.setText(String.valueOf(0.0));
                zText.setText(String.valueOf(0.0));
            }
            pointPanel.add(xLabel);
            pointPanel.add(xText);
            pointPanel.add(yLabel);
            pointPanel.add(yText);
            pointPanel.add(zLabel);
            pointPanel.add(zText);
            return pointPanel;
        }
        if (objectClass.isEnum()) {
            return GUIPackEditor.createNewEnumBox(obj, objectClass, focusListener);
        }
        return null;
    }

    private static <EnumType> JComboBox<EnumType> createNewEnumBox(Object obj, Class<EnumType> objectClass, FocusListener listener) {
        EnumType[] enumConstants;
        JComboBox<Object> comboBox = new JComboBox<Object>();
        comboBox.setFont(NORMAL_FONT);
        comboBox.setPreferredSize(STRING_TEXT_BOX_DIM);
        for (EnumType enumConstant : enumConstants = objectClass.getEnumConstants()) {
            comboBox.addItem(enumConstant);
        }
        comboBox.addFocusListener(listener);
        comboBox.setRenderer(GUIPackEditor.generateEnumTooltipRenderer(enumConstants));
        comboBox.setSelectedItem(obj);
        return comboBox;
    }

    private static <EnumType> JComboBox<String> createNewStringBox(Class<EnumType> objectClass, ItemListener listener) {
        EnumType[] enumConstants;
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.setEditable(true);
        comboBox.setFont(NORMAL_FONT);
        comboBox.setPreferredSize(STRING_TEXT_BOX_DIM);
        for (EnumType enumConstant : enumConstants = objectClass.getEnumConstants()) {
            comboBox.addItem(((Enum)enumConstant).name().toLowerCase(Locale.ROOT));
        }
        comboBox.addItemListener(listener);
        comboBox.setRenderer(GUIPackEditor.generateEnumTooltipRenderer(enumConstants));
        return comboBox;
    }

    private static <EnumType> DefaultListCellRenderer generateEnumTooltipRenderer(final EnumType[] enumConstants) {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JComponent component = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (index > -1 && index < enumConstants.length) {
                    Object currentEnum = enumConstants[index];
                    try {
                        String enumName = ((Enum)currentEnum).name();
                        Field enumField = currentEnum.getClass().getField(enumName);
                        if (enumField.isAnnotationPresent(JSONParser.JSONDescription.class)) {
                            String tooltipText = GUIPackEditor.formatTooltipText(enumField.getAnnotation(JSONParser.JSONDescription.class).value());
                            list.setToolTipText(tooltipText);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return component;
            }
        };
    }

    private static DefaultListCellRenderer generateClassTooltipRenderer(final Class<?>[] classes) {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JComponent component = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (index > -1 && index < classes.length) {
                    Class currentClass = classes[index];
                    try {
                        String tooltipText = GUIPackEditor.formatTooltipText(currentClass.getAnnotation(JSONParser.JSONDescription.class).value());
                        list.setToolTipText(tooltipText);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return component;
            }
        };
    }

    /*
     * Loose catch block
     */
    private static Object createNewObjectInstance(Class<?> fieldClass, Object declaringObject) {
        block8: {
            if (fieldClass.isMemberClass()) {
                for (Class<?> objectClass : declaringObject.getClass().getClasses()) {
                    if (!fieldClass.isAssignableFrom(objectClass)) continue;
                    return objectClass.getConstructor(fieldClass.getDeclaringClass()).newInstance(declaringObject);
                }
                return null;
            }
            if (fieldClass.equals(Integer.class)) {
                return 0;
            }
            if (!fieldClass.equals(Float.class)) break block8;
            return Float.valueOf(0.0f);
            {
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        try {
            return fieldClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return fieldClass.getConstructor(declaringObject.getClass()).newInstance(declaringObject);
        }
    }

    private static String formatTooltipText(String annotationText) {
        StringBuilder tooltipText = new StringBuilder("<html>");
        for (String annotationSegment : annotationText.split("\n")) {
            int breakIndex = annotationSegment.indexOf(" ", 150);
            while (breakIndex != -1) {
                tooltipText.append(annotationSegment.substring(0, breakIndex)).append("<br>");
                annotationSegment = annotationSegment.substring(breakIndex);
                breakIndex = annotationSegment.indexOf(" ", 150);
                int listStartIndex = annotationSegment.indexOf("<ul>");
                if (listStartIndex <= 0 || listStartIndex >= breakIndex) continue;
                breakIndex = annotationSegment.indexOf("</ul>");
            }
            tooltipText.append(annotationSegment).append("<br><br>");
        }
        return tooltipText + "</html>";
    }

    private static class FocusForwarder
    implements FocusListener {
        private final FocusListener target;

        private FocusForwarder(FocusListener target) {
            this.target = target;
        }

        @Override
        public void focusGained(FocusEvent arg0) {
            this.target.focusGained(arg0);
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            this.target.focusLost(arg0);
        }
    }

    private static class FieldChanger
    implements FocusListener,
    ItemListener,
    ActionListener {
        private final Field objectField;
        private final Class<?> objectClass;
        private final Object declaringObject;
        private JComponent component;

        private FieldChanger(Field objectField, Object declaringObject) {
            this.objectField = objectField;
            this.objectClass = objectField.getType();
            this.declaringObject = declaringObject;
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            try {
                if (this.objectClass.equals(Integer.TYPE)) {
                    this.objectField.set(this.declaringObject, Integer.valueOf(((JTextField)this.component).getText()));
                } else if (this.objectClass.equals(Float.TYPE)) {
                    this.objectField.set(this.declaringObject, Float.valueOf(((JTextField)this.component).getText()));
                } else if (this.objectClass.equals(String.class)) {
                    String text = ((JTextField)this.component).getText();
                    if (text.isEmpty()) {
                        this.objectField.set(this.declaringObject, null);
                    } else {
                        this.objectField.set(this.declaringObject, text);
                    }
                } else {
                    if (this.objectClass.equals(Point3D.class)) {
                        int fieldChecking = 1;
                        try {
                            double x = Float.parseFloat(((JTextField)this.component.getComponent(fieldChecking)).getText());
                            this.component.getComponent(fieldChecking).setBackground(Color.WHITE);
                            double y = Float.parseFloat(((JTextField)this.component.getComponent(fieldChecking += 2)).getText());
                            this.component.getComponent(fieldChecking).setBackground(Color.WHITE);
                            double z = Float.parseFloat(((JTextField)this.component.getComponent(fieldChecking += 2)).getText());
                            this.component.getComponent(fieldChecking).setBackground(Color.WHITE);
                            Point3D newPoint = new Point3D(x, y, z);
                            if (newPoint.isZero()) {
                                this.objectField.set(this.declaringObject, null);
                            } else {
                                this.objectField.set(this.declaringObject, newPoint);
                            }
                            return;
                        }
                        catch (Exception e) {
                            this.component.getComponent(fieldChecking).setBackground(Color.RED);
                            return;
                        }
                    }
                    if (this.objectClass.isEnum()) {
                        this.objectField.set(this.declaringObject, ((JComboBox)this.component).getSelectedItem());
                    }
                }
                this.component.setBackground(Color.WHITE);
            }
            catch (Exception e) {
                this.component.setBackground(Color.RED);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 2) {
                try {
                    if (this.component instanceof JComboBox) {
                        String text = ((JComboBox)this.component).getSelectedItem().toString();
                        if (text == null || text.isEmpty()) {
                            this.objectField.set(this.declaringObject, null);
                        } else {
                            this.objectField.set(this.declaringObject, text);
                        }
                        this.component.setBackground(Color.WHITE);
                    }
                }
                catch (Exception e) {
                    this.component.setBackground(Color.RED);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            try {
                if (this.objectClass.equals(Boolean.TYPE)) {
                    this.objectField.set(this.declaringObject, ((JCheckBox)this.component).isSelected());
                }
            }
            catch (Exception e) {
                this.component.setBackground(Color.RED);
            }
        }
    }

    private static class ListElementChanger
    implements FocusListener {
        private final List<Object> list;
        private final Class<?> objectClass;
        private final int index;
        private JComponent component;

        private ListElementChanger(List<Object> list, Object obj) {
            this.list = list;
            this.objectClass = obj.getClass();
            this.index = list.indexOf(obj);
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            try {
                if (this.objectClass.equals(Integer.TYPE)) {
                    this.list.set(this.index, Integer.valueOf(((JTextField)this.component).getText()));
                } else if (this.objectClass.equals(Float.TYPE)) {
                    this.list.set(this.index, Float.valueOf(((JTextField)this.component).getText()));
                } else if (this.objectClass.equals(String.class)) {
                    this.list.set(this.index, ((JTextField)this.component).getText());
                } else {
                    if (this.objectClass.equals(Point3D.class)) {
                        int fieldChecking = 1;
                        try {
                            double x = Float.parseFloat(((JTextField)this.component.getComponent(fieldChecking)).getText());
                            this.component.getComponent(fieldChecking).setBackground(Color.WHITE);
                            double y = Float.parseFloat(((JTextField)this.component.getComponent(fieldChecking += 2)).getText());
                            this.component.getComponent(fieldChecking).setBackground(Color.WHITE);
                            double z = Float.parseFloat(((JTextField)this.component.getComponent(fieldChecking += 2)).getText());
                            this.component.getComponent(fieldChecking).setBackground(Color.WHITE);
                            Point3D newPoint = new Point3D(x, y, z);
                            this.list.set(this.index, newPoint);
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.component.getComponent(fieldChecking).setBackground(Color.RED);
                            return;
                        }
                    }
                    if (this.objectClass.isEnum()) {
                        this.list.set(this.index, ((JComboBox)this.component).getSelectedItem());
                    }
                }
                this.component.setBackground(Color.WHITE);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.component.setBackground(Color.RED);
            }
        }
    }

    private static class ListElementPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private ListElementPanel(JPanel parentPanel, List<Object> list, Object listEntry) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            ListElementChanger listenter = new ListElementChanger(list, listEntry);
            JComponent newComponent = GUIPackEditor.getComponentForObject(listEntry, listEntry.getClass(), listenter, null);
            if (newComponent != null) {
                listenter.component = newComponent;
                buttonPanel.add(newComponent);
            } else {
                this.setLayout(new GridBagLayout());
                this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                GUIPackEditor.populatePanel(this, listEntry);
            }
            ListElementPanel thisPanel = this;
            JButton deleteEntryButton = new JButton();
            deleteEntryButton.setFont(NORMAL_FONT);
            deleteEntryButton.setText("Delete");
            deleteEntryButton.addActionListener(event -> {
                list.remove(listEntry);
                parentPanel.remove(thisPanel);
                parentPanel.revalidate();
                parentPanel.repaint();
            });
            buttonPanel.add(deleteEntryButton);
            JButton copyEntryButton = new JButton();
            copyEntryButton.setFont(NORMAL_FONT);
            copyEntryButton.setText("Copy");
            copyEntryButton.addActionListener(event -> {
                try {
                    Object newObj = JSONParser.duplicateJSON(listEntry);
                    list.add(newObj);
                    parentPanel.add(new ListElementPanel(parentPanel, list, newObj));
                    parentPanel.revalidate();
                    parentPanel.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            buttonPanel.add(copyEntryButton);
            this.add(buttonPanel);
        }
    }
}

