/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.items.instances.ItemPartEffector;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPartEffector;

public class PartEffector
extends APart {
    private final List<IWrapperItemStack> drops = new ArrayList<IWrapperItemStack>();
    private final Map<IWrapperEntity, IWrapperItemStack> entityItems = new HashMap<IWrapperEntity, IWrapperItemStack>();
    public int blocksBroken;
    public boolean activatedThisTick;
    private final Point3D flooredCenter = new Point3D();
    private final Map<BoundingBox, Point3D> boxLastPositionsFloored = new HashMap<BoundingBox, Point3D>();
    private final Map<BoundingBox, Integer> boxTimeSpentAtPosition = new HashMap<BoundingBox, Integer>();
    private final Set<Point3D> blockFlooredPositionsBrokeThisTick = new HashSet<Point3D>();
    private int placerDelay;

    public PartEffector(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, ItemPartEffector item, IWrapperNBT data) {
        super(entityOn, placingPlayer, placementDefinition, item, data);
        if (data != null) {
            this.blocksBroken = data.getInteger("blocksBroken");
        }
    }

    @Override
    public void update() {
        super.update();
        this.activatedThisTick = false;
        if (this.isActive && !this.world.isClient() && !this.outOfHealth) {
            this.drops.clear();
            this.entityItems.clear();
            this.blockFlooredPositionsBrokeThisTick.clear();
            for (BoundingBox box : this.entityCollisionBoxes) {
                switch (((JSONPart)this.definition).effector.type) {
                    case FERTILIZER: {
                        IWrapperItemStack stack;
                        int i;
                        Object inventory;
                        block12: for (APart part : this.linkedParts) {
                            if (!(part instanceof PartInteractable) || !((JSONPart)part.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles) continue;
                            inventory = ((PartInteractable)part).inventory;
                            for (i = 0; i < ((EntityInventoryContainer)inventory).getSize(); ++i) {
                                stack = ((EntityInventoryContainer)inventory).getStack(i);
                                if (!this.world.fertilizeBlock(box.globalCenter, stack)) continue;
                                inventory.removeFromSlot(i, 1);
                                this.activatedThisTick = true;
                                continue block12;
                            }
                        }
                        break;
                    }
                    case HARVESTER: {
                        List<IWrapperItemStack> drops = this.world.harvestBlock(box.globalCenter);
                        if (drops.isEmpty()) break;
                        drops.addAll(this.world.harvestBlock(box.globalCenter));
                        this.activatedThisTick = true;
                        break;
                    }
                    case PLANTER: {
                        IWrapperItemStack stack;
                        int i;
                        Object inventory;
                        block14: for (APart part : this.linkedParts) {
                            if (!(part instanceof PartInteractable) || !((JSONPart)part.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles) continue;
                            inventory = ((PartInteractable)part).inventory;
                            for (i = 0; i < ((EntityInventoryContainer)inventory).getSize(); ++i) {
                                stack = ((EntityInventoryContainer)inventory).getStack(i);
                                if (!this.world.plantBlock(box.globalCenter, stack)) continue;
                                inventory.removeFromSlot(i, 1);
                                this.activatedThisTick = true;
                                continue block14;
                            }
                        }
                        break;
                    }
                    case PLOW: {
                        if (!this.world.plowBlock(box.globalCenter)) break;
                        this.activatedThisTick = true;
                        List<IWrapperItemStack> harvestedDrops = this.world.harvestBlock(box.globalCenter);
                        if (harvestedDrops.isEmpty()) break;
                        for (IWrapperItemStack stack : harvestedDrops) {
                            if (stack.getSize() <= 0) continue;
                            this.world.spawnItemStack(stack, this.position);
                        }
                        break;
                    }
                    case SNOWPLOW: {
                        if (!this.world.removeSnow(box.globalCenter)) break;
                        this.activatedThisTick = true;
                        break;
                    }
                    case DRILL: {
                        float blockHardness;
                        if (!this.world.isAir(box.globalCenter) && (blockHardness = this.world.getBlockHardness(box.globalCenter)) <= ((JSONPart)this.definition).effector.drillHardness) {
                            if (!this.boxLastPositionsFloored.containsKey(box)) {
                                this.boxLastPositionsFloored.put(box, new Point3D());
                                this.boxTimeSpentAtPosition.put(box, 0);
                            }
                            this.flooredCenter.set(Math.floor(box.globalCenter.x), Math.floor(box.globalCenter.y), Math.floor(box.globalCenter.z));
                            if (this.boxLastPositionsFloored.get(box).equals(this.flooredCenter) && !this.blockFlooredPositionsBrokeThisTick.contains(this.flooredCenter)) {
                                int timeSpentBreaking = this.boxTimeSpentAtPosition.get(box);
                                if ((float)timeSpentBreaking >= ((JSONPart)this.definition).effector.drillSpeed * blockHardness / ((JSONPart)this.definition).effector.drillHardness) {
                                    this.drops.addAll(this.world.getBlockDrops(this.flooredCenter));
                                    this.world.destroyBlock(this.flooredCenter, false);
                                    this.boxTimeSpentAtPosition.put(box, 0);
                                    this.blockFlooredPositionsBrokeThisTick.add(this.flooredCenter.copy());
                                    if (++this.blocksBroken == ((JSONPart)this.definition).effector.drillDurability) {
                                        this.remove();
                                    } else {
                                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEffector(this, true));
                                    }
                                    this.activatedThisTick = true;
                                    break;
                                }
                                this.boxTimeSpentAtPosition.put(box, timeSpentBreaking + 1);
                                break;
                            }
                            this.boxLastPositionsFloored.put(box, this.flooredCenter.copy());
                        }
                        this.boxTimeSpentAtPosition.put(box, 0);
                        break;
                    }
                    case PLACER: {
                        IWrapperItemStack stack;
                        int i;
                        Object inventory;
                        if (this.placerDelay == ((JSONPart)this.definition).effector.placerDelay) {
                            if (this.world.isAir(box.globalCenter)) {
                                for (APart part : this.linkedParts) {
                                    if (part instanceof PartInteractable && ((JSONPart)part.definition).interactable.interactionType == JSONPart.InteractableComponentType.CRATE && part.isActive && ((JSONPart)part.definition).interactable.feedsVehicles) {
                                        inventory = ((PartInteractable)part).inventory;
                                        for (i = 0; i < ((EntityInventoryContainer)inventory).getSize(); ++i) {
                                            stack = ((EntityInventoryContainer)inventory).getStack(i);
                                            if (!this.world.placeBlock(box.globalCenter, stack)) continue;
                                            inventory.removeFromSlot(i, 1);
                                            this.activatedThisTick = true;
                                            break;
                                        }
                                    }
                                    if (!this.activatedThisTick) continue;
                                    break;
                                }
                            }
                            this.placerDelay = 0;
                        } else {
                            ++this.placerDelay;
                        }
                    }
                    case COLLECTOR: {
                        this.world.populateItemStackEntities(this.entityItems, box);
                        this.drops.addAll(this.entityItems.values());
                        break;
                    }
                    case DROPPER: {
                        IWrapperItemStack stack;
                        int i;
                        Object inventory;
                        if (this.placerDelay == ((JSONPart)this.definition).effector.placerDelay) {
                            this.world.populateItemStackEntities(this.entityItems, box);
                            if (this.entityItems.isEmpty()) {
                                for (APart part : this.linkedParts) {
                                    if (part instanceof PartInteractable && ((JSONPart)part.definition).interactable.interactionType == JSONPart.InteractableComponentType.CRATE && part.isActive && ((JSONPart)part.definition).interactable.feedsVehicles) {
                                        inventory = ((PartInteractable)part).inventory;
                                        for (i = 0; i < ((EntityInventoryContainer)inventory).getSize(); ++i) {
                                            stack = ((EntityInventoryContainer)inventory).getStack(i);
                                            if (stack.isEmpty()) continue;
                                            IWrapperItemStack stackToDrop = stack.split(1);
                                            this.world.spawnItemStack(stackToDrop, box.globalCenter);
                                            this.activatedThisTick = true;
                                            break;
                                        }
                                    }
                                    if (!this.activatedThisTick) continue;
                                    break;
                                }
                            }
                            this.placerDelay = 0;
                            break;
                        }
                        ++this.placerDelay;
                    }
                }
                if (this.drops.isEmpty()) continue;
                Iterator<IWrapperItemStack> iterator = this.drops.iterator();
                block21: while (iterator.hasNext()) {
                    IWrapperItemStack dropStack = iterator.next();
                    for (APart part : this.linkedParts) {
                        if (!(part instanceof PartInteractable) || !part.isActive || !((JSONPart)part.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE)) continue;
                        if (((JSONPart)this.definition).effector.type == JSONPart.EffectorComponentType.COLLECTOR && ((PartInteractable)part).inventory.addStack(dropStack, dropStack.getSize(), false)) {
                            this.activatedThisTick = true;
                            for (Map.Entry<IWrapperEntity, IWrapperItemStack> entry : this.entityItems.entrySet()) {
                                if (entry.getValue() != dropStack) continue;
                                this.world.removeItemStackEntity(entry.getKey());
                            }
                        }
                        if (!((PartInteractable)part).inventory.addStack(dropStack)) continue;
                        iterator.remove();
                        continue block21;
                    }
                }
                if (((JSONPart)this.definition).effector.type != JSONPart.EffectorComponentType.COLLECTOR) {
                    for (IWrapperItemStack dropStack : this.drops) {
                        this.world.spawnItemStack(dropStack, this.position);
                    }
                }
                this.drops.clear();
            }
            if (this.activatedThisTick) {
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEffector(this, false));
            }
        }
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "effector_active": {
                return this.isActive ? 1.0 : 0.0;
            }
            case "effector_operated": {
                return this.activatedThisTick ? 1.0 : 0.0;
            }
            case "effector_drill_broken": {
                return this.blocksBroken;
            }
            case "effector_drill_max": {
                return ((JSONPart)this.definition).effector.drillDurability;
            }
            case "effector_drill_percentage": {
                return (double)this.blocksBroken / (double)((JSONPart)this.definition).effector.drillDurability;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setInteger("blocksBroken", this.blocksBroken);
        return data;
    }
}

