/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.JSONDummyPartProvider;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.ConfigSystem;

public class EntityPlacedPart
extends AEntityF_Multipart<JSONDummyPartProvider> {
    private static final List<String> allPartTypes = new ArrayList<String>();
    public APart currentPart;
    private boolean riderPresentLastCheck;
    private boolean riderPresentThisCheck;
    private boolean needToFindGround = true;

    public EntityPlacedPart(AWrapperWorld world, IWrapperPlayer placingPlayer, IWrapperNBT data) {
        super(world, placingPlayer, null, data);
    }

    @Override
    public JSONDummyPartProvider generateDefaultDefinition() {
        JSONDummyPartProvider defaultDefinition = JSONDummyPartProvider.generateDummy();
        if (allPartTypes.isEmpty()) {
            for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
                if (!(packItem instanceof AItemPart)) continue;
                AItemPart partItem = (AItemPart)packItem;
                if (allPartTypes.contains(((JSONPart)partItem.definition).generic.type)) continue;
                allPartTypes.add(((JSONPart)partItem.definition).generic.type);
            }
        }
        ((JSONPartDefinition)defaultDefinition.parts.get((int)0)).types.addAll(allPartTypes);
        return defaultDefinition;
    }

    @Override
    public void update() {
        super.update();
        if (this.parts.isEmpty()) {
            if (this.ticksExisted > 100L) {
                this.remove();
            }
        } else {
            this.currentPart = (APart)this.parts.get(0);
            if (this.currentPart != null) {
                this.currentPart.placementDefinition.pos.y = ((JSONPart)this.currentPart.definition).generic.placedOffset;
                this.forceCollisionUpdateThisTick = this.currentPart.requiresDeltaUpdates();
                this.riderPresentLastCheck = this.riderPresentThisCheck;
                boolean bl = this.riderPresentThisCheck = this.currentPart.rider != null;
                if (this.needToFindGround) {
                    if (((JSONPart)this.currentPart.definition).generic.fallsToGround) {
                        if (this.ticksExisted > 1L) {
                            if (this.motion.y > -3.9) {
                                this.motion.y += -0.08;
                            }
                            Point3D motionApplied = new Point3D();
                            while (this.needToFindGround && motionApplied.y > this.motion.y) {
                                motionApplied.y -= 1.0;
                                if (motionApplied.y < this.motion.y) {
                                    motionApplied.y = this.motion.y;
                                }
                                this.encompassingBox.globalCenter.set(this.position).add(motionApplied);
                                this.world.updateBoundingBoxCollisions(this.encompassingBox, motionApplied, true);
                                if (this.encompassingBox.currentCollisionDepth.y == 0.0) continue;
                                this.position.add(motionApplied).subtract(this.encompassingBox.currentCollisionDepth);
                                this.motion.y = 0.0;
                                this.needToFindGround = false;
                                this.allInteractionBoxes.forEach(box -> box.updateToEntity(this, null));
                            }
                            this.position.add(this.motion);
                        }
                    } else {
                        this.needToFindGround = false;
                    }
                }
            }
        }
    }

    @Override
    public boolean requiresDeltaUpdates() {
        return super.requiresDeltaUpdates() || this.needToFindGround || this.riderPresentLastCheck != this.riderPresentThisCheck;
    }

    @Override
    protected void updateEncompassingBox() {
        super.updateEncompassingBox();
        this.allEntityCollisionBoxes.addAll(this.allInteractionBoxes);
        this.allEntityCollisionBoxes.removeAll(this.allPartSlotBoxes.keySet());
    }

    @Override
    public boolean shouldRenderBeams() {
        return (Boolean)ConfigSystem.client.renderingSettings.vehicleBeams.value;
    }

    @Override
    public boolean disableRendering() {
        return true;
    }
}

