/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityEnergyCharger;
import minecrafttransportsimulator.blocks.tileentities.instances.ATileEntityFuelPump;
import minecrafttransportsimulator.entities.instances.AEntityVehicleE_Powered;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.systems.ConfigSystem;

public class TileEntityCharger
extends ATileEntityFuelPump
implements ITileEntityEnergyCharger {
    private int internalBuffer;

    public TileEntityCharger(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
    }

    @Override
    protected boolean hasFuel() {
        return this.internalBuffer > 0;
    }

    @Override
    protected AEntityVehicleE_Powered.FuelTankResult checkPump(EntityVehicleF_Physics vehicle) {
        for (APart part : vehicle.allParts) {
            if (!(part instanceof PartEngine) || ((JSONPart)part.definition).engine.type != JSONPart.EngineType.ELECTRIC) continue;
            return AEntityVehicleE_Powered.FuelTankResult.VALID;
        }
        return AEntityVehicleE_Powered.FuelTankResult.INVALID;
    }

    @Override
    public void fuelVehicle(double amount) {
        int bufferToUse = (int)(amount / (Double)ConfigSystem.settings.general.rfToElectricityFactor.value);
        if (bufferToUse > this.internalBuffer) {
            bufferToUse = this.internalBuffer;
        }
        amount = (double)bufferToUse * (Double)ConfigSystem.settings.general.rfToElectricityFactor.value;
        this.internalBuffer -= bufferToUse;
        double amountFilled = this.connectedVehicle.fuelTank.fill(PartEngine.ELECTRICITY_FUEL, amount, true);
        this.fuelDispensedThisConnection += amountFilled;
    }

    @Override
    public int getChargeAmount() {
        double amountPurchasedRemaining;
        int maxAmount = 200;
        if (!this.isCreative && (double)maxAmount > (amountPurchasedRemaining = (double)this.fuelPurchased - this.fuelDispensedThisPurchase)) {
            maxAmount = (int)amountPurchasedRemaining;
        }
        return maxAmount - this.internalBuffer;
    }

    @Override
    public void chargeEnergy(int amount) {
        this.internalBuffer += amount;
        this.fuelDispensedThisPurchase += (double)amount;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "charger_active": {
                return this.connectedVehicle != null ? 1.0 : 0.0;
            }
            case "charger_dispensed": {
                return this.fuelDispensedThisConnection;
            }
            case "charger_free": {
                return this.isCreative ? 1.0 : 0.0;
            }
            case "charger_purchased": {
                return this.fuelPurchased;
            }
            case "charger_vehicle_percentage": {
                return this.connectedVehicle != null ? this.connectedVehicle.fuelTank.getFluidLevel() / (double)this.connectedVehicle.fuelTank.getMaxLevel() : 0.0;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }
}

