/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import mcinterface1122.BuilderEntityRenderForwarder;
import mcinterface1122.BuilderItem;
import mcinterface1122.InterfaceRender;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.packloading.PackResourceLoader;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InterfaceEventsModelLoader {
    private static boolean enableDebug = true;

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(BuilderEntityRenderForwarder.class, manager -> new Render<BuilderEntityRenderForwarder>(manager){

            protected ResourceLocation getEntityTexture(BuilderEntityRenderForwarder builder) {
                return null;
            }

            public boolean shouldRender(BuilderEntityRenderForwarder builder, ICamera camera, double camX, double camY, double camZ) {
                return true;
            }

            public void doRender(BuilderEntityRenderForwarder builder, double x, double y, double z, float entityYaw, float partialTicks) {
                ConcurrentLinkedQueue allEntities;
                WrapperWorld world = WrapperWorld.getWrapperFor(builder.field_70170_p);
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                Entity cameraEntity = Minecraft.func_71410_x().func_175606_aa();
                if (player.equals((Object)builder.playerFollowing) && builder.shouldRenderEntity(partialTicks) && (allEntities = world.renderableEntities) != null) {
                    boolean blendingEnabled = (MinecraftForgeClient.getRenderPass() == -1 ? InterfaceRender.lastRenderPassActualPass : MinecraftForgeClient.getRenderPass()) == 1;
                    GL11.glShadeModel((int)7425);
                    if (blendingEnabled) {
                        GlStateManager.func_179118_c();
                    }
                    GlStateManager.func_179091_B();
                    for (AEntityC_Renderable entity : allEntities) {
                        world.beginProfiling("MTSRendering", true);
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)(entity.position.x - (cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)partialTicks)), (double)(entity.position.y - (cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)partialTicks)), (double)(entity.position.z - (cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)partialTicks)));
                        entity.render(blendingEnabled, partialTicks);
                        GL11.glPopMatrix();
                        world.endProfiling();
                    }
                    GL11.glShadeModel((int)7424);
                    if (blendingEnabled) {
                        GlStateManager.func_179141_d();
                    }
                    GlStateManager.func_179101_C();
                }
            }
        });
        List defaultPacks = null;
        for (Field field : Minecraft.class.getDeclaredFields()) {
            if (!field.getName().equals("defaultResourcePacks") && !field.getName().equals("field_110449_ao")) continue;
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                defaultPacks = (List)field.get(Minecraft.func_71410_x());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (defaultPacks == null) {
            InterfaceManager.coreInterface.logError("Could not get default pack list. Item icons will be disabled.");
            return;
        }
        defaultPacks.add(new PackResourcePack(InterfaceManager.coreModID + "_packs"));
        for (AItemBase item : BuilderItem.itemMap.keySet()) {
            if (!(item instanceof AItemPack)) continue;
            AItemPack packItem = (AItemPack)item;
            if (!PackResourcePack.createdLoaders.containsKey(((AJSONItem)packItem.definition).packID)) {
                defaultPacks.add(new PackResourcePack(((AJSONItem)packItem.definition).packID));
            }
            ModelLoader.setCustomModelResourceLocation((Item)BuilderItem.itemMap.get(packItem), (int)0, (ModelResourceLocation)new ModelResourceLocation(InterfaceManager.coreModID + "_packs:" + packItem.getRegistrationName(), "inventory"));
        }
        FMLClientHandler.instance().refreshResources(new IResourceType[]{VanillaResourceType.MODELS});
    }

    private static class PackResourcePack
    implements IResourcePack {
        private static final Map<String, PackResourcePack> createdLoaders = new HashMap<String, PackResourcePack>();
        private final String domain;
        private final Set<String> domains;

        private PackResourcePack(String domain) {
            this.domain = domain;
            this.domains = new HashSet<String>();
            this.domains.add(domain);
            createdLoaders.put(domain, this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public InputStream func_110590_a(ResourceLocation location) throws IOException {
            InputStream stream;
            String rawPackInfo = location.func_110623_a();
            if (rawPackInfo.endsWith(".json")) {
                String strippedSuffix = rawPackInfo.substring(0, rawPackInfo.lastIndexOf("."));
                if (!strippedSuffix.contains(".")) {
                    stream = InterfaceManager.coreInterface.getPackResource("/assets/" + this.domain + "/" + rawPackInfo);
                    if (stream != null) return stream;
                    if (!enableDebug) throw new FileNotFoundException(rawPackInfo);
                    if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                    InterfaceManager.coreInterface.logError("Could not find JSON-specified file: " + rawPackInfo);
                    throw new FileNotFoundException(rawPackInfo);
                }
                String resourcePath = "";
                String itemTexturePath = "";
                String combinedPackInfo = strippedSuffix.substring("models/item/".length());
                try {
                    String packID = combinedPackInfo.substring(0, combinedPackInfo.indexOf("."));
                    String systemName = combinedPackInfo.substring(combinedPackInfo.indexOf(".") + 1);
                    Object packItem = PackParser.getItem(packID, systemName);
                    resourcePath = PackResourceLoader.getPackResource(((AItemPack)packItem).definition, PackResourceLoader.ResourceType.ITEM_JSON, systemName);
                    stream = InterfaceManager.coreInterface.getPackResource(resourcePath);
                    if (stream != null) return stream;
                    itemTexturePath = PackResourceLoader.getPackResource(((AItemPack)packItem).definition, PackResourceLoader.ResourceType.ITEM_PNG, systemName);
                    itemTexturePath = itemTexturePath.substring(("/assets/" + packID + "/").length());
                    itemTexturePath = itemTexturePath.substring(0, itemTexturePath.length() - ".png".length());
                    itemTexturePath = packID + ":" + itemTexturePath;
                    String fakeJSON = "{\"parent\":\"mts:item/basic\",\"textures\":{\"layer0\": \"" + itemTexturePath + "\"}}";
                    return new ByteArrayInputStream(fakeJSON.getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    if (!enableDebug) throw new FileNotFoundException(rawPackInfo);
                    if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                    InterfaceManager.coreInterface.logError("Could not parse out item JSON from: " + rawPackInfo + "  Looked for JSON at:" + resourcePath + (itemTexturePath.isEmpty() ? ", with fallback at:" + itemTexturePath : ", but could not find it."));
                    throw new FileNotFoundException(rawPackInfo);
                }
            }
            try {
                Object packItem;
                boolean isItemPNG = rawPackInfo.contains("/items/") || rawPackInfo.contains("_item");
                String combinedPackInfo = rawPackInfo;
                combinedPackInfo = combinedPackInfo.substring("textures/".length(), combinedPackInfo.length() - ".png".length());
                String packID = this.domain;
                String systemName = combinedPackInfo.substring(combinedPackInfo.lastIndexOf(47) + 1);
                if (systemName.endsWith("_item")) {
                    systemName = systemName.substring(0, systemName.length() - "_item".length());
                }
                if ((packItem = PackParser.getItem(packID, systemName)) != null) {
                    String streamLocation = PackResourceLoader.getPackResource(((AItemPack)packItem).definition, isItemPNG ? PackResourceLoader.ResourceType.ITEM_PNG : PackResourceLoader.ResourceType.PNG, systemName);
                    stream = InterfaceManager.coreInterface.getPackResource(streamLocation);
                    if (stream != null) return stream;
                    if (isItemPNG) {
                        String streamJSONLocation = "/assets/" + packID + "/" + rawPackInfo;
                        stream = InterfaceManager.coreInterface.getPackResource(streamJSONLocation);
                        if (stream != null) return stream;
                        if (!enableDebug) throw new FileNotFoundException(rawPackInfo);
                        if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                        if (streamLocation != null) {
                            InterfaceManager.coreInterface.logError("Could not find item PNG at specified location: " + streamLocation + "  Or potential JSON location: " + streamJSONLocation);
                            throw new FileNotFoundException(rawPackInfo);
                        } else {
                            InterfaceManager.coreInterface.logError("Could not find JSON PNG: " + streamJSONLocation);
                        }
                        throw new FileNotFoundException(rawPackInfo);
                    }
                    if (!enableDebug) throw new FileNotFoundException(rawPackInfo);
                    if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                    InterfaceManager.coreInterface.logError("Could not find OBJ PNG: " + streamLocation);
                    throw new FileNotFoundException(rawPackInfo);
                }
                String streamLocation = "/assets/" + this.domain + "/" + rawPackInfo;
                stream = InterfaceManager.coreInterface.getPackResource(streamLocation);
                if (stream != null) return stream;
                if (!enableDebug) throw new FileNotFoundException(rawPackInfo);
                if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                InterfaceManager.coreInterface.logError("Couldn't find...whatever this is: " + streamLocation);
                throw new FileNotFoundException(rawPackInfo);
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException) {
                    throw e;
                }
                if (!enableDebug) throw new FileNotFoundException(rawPackInfo);
                if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                InterfaceManager.coreInterface.logError("Could not parse which item PNG to get from: " + rawPackInfo);
                throw new FileNotFoundException(rawPackInfo);
            }
        }

        public boolean func_110589_b(ResourceLocation location) {
            try {
                enableDebug = false;
                boolean returnValue = this.func_110590_a(location) != null;
                enableDebug = true;
                return returnValue;
            }
            catch (IOException e) {
                return false;
            }
        }

        public Set<String> func_110587_b() {
            return this.domains;
        }

        public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) {
            return null;
        }

        public BufferedImage func_110586_a() {
            return null;
        }

        public String func_130077_b() {
            return "Internal:" + this.domain;
        }
    }
}

