/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.common.utils.TektopiaUtils;
import bletch.tektopiainformation.network.data.ResidentData;
import bletch.tektopiainformation.network.data.VillageData;
import bletch.tektopiainformation.network.data.VisitorData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.tangotek.tektopia.VillagerRole;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import net.tangotek.tektopia.structures.VillageStructure;
import net.tangotek.tektopia.structures.VillageStructureRancherPen;
import net.tangotek.tektopia.structures.VillageStructureType;

public class StructureData {
    protected static final String NBTTAG_VILLAGE_STRUCTUREID = "id";
    protected static final String NBTTAG_VILLAGE_STRUCTURETYPE = "type";
    protected static final String NBTTAG_VILLAGE_STRUCTUREPOSITION = "pos";
    protected static final String NBTTAG_VILLAGE_STRUCTUREVALID = "valid";
    protected static final String NBTTAG_VILLAGE_STRUCTUREFLOORTILECOUNT = "tiles";
    protected static final String NBTTAG_VILLAGE_STRUCTURETILESPEROCCUPANT = "tilesper";
    protected static final String NBTTAG_VILLAGE_STRUCTUREOCCUPANTS = "occupants";
    protected static final String NBTTAG_VILLAGE_STRUCTUREANIMALPEN = "pen";
    protected static final String NBTTAG_VILLAGE_STRUCTUREANIMALCOUNT = "animalcount";
    protected static final String NBTTAG_VILLAGE_STRUCTUREANIMALSIZE = "animalsize";
    protected static final Random rand = new Random();
    protected VillageData villageData;
    protected int structureId;
    protected VillageStructureType structureType;
    protected BlockPos framePosition;
    protected boolean isValid;
    protected int floorTileCount;
    protected int tilesPerOccupant;
    protected boolean isAnimalPen;
    protected int animalCount;
    protected int animalSize;
    protected List<ResidentData> occupants;

    public StructureData(VillageData villageData, VillageStructure structure) {
        this.villageData = villageData;
        this.populateData(structure);
    }

    public StructureData(VillageData villageData, NBTTagCompound nbtTag) {
        this.villageData = villageData;
        this.readNBT(nbtTag);
    }

    protected VillageData getVillageData() {
        return this.villageData;
    }

    public int getStructureId() {
        return this.structureId;
    }

    public VillageStructureType getStructureType() {
        return this.structureType;
    }

    public String getStructureTypeName() {
        return this.structureType != null && this.structureType.itemStack != null ? this.structureType.itemStack.func_82833_r() : "";
    }

    public BlockPos getFramePosition() {
        return this.framePosition;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getFloorTileCount() {
        return this.floorTileCount;
    }

    public int getTilesPerOccupant() {
        return this.tilesPerOccupant;
    }

    public boolean isAnimalPen() {
        return this.isAnimalPen;
    }

    public int getAnimalCount() {
        return this.animalCount;
    }

    public int getAnimalSize() {
        return this.animalSize;
    }

    public int getOccupantCount() {
        return this.occupants == null ? 0 : this.occupants.size();
    }

    public List<ResidentData> getOccupants() {
        return this.occupants == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.occupants);
    }

    public int getOccupantDensityRatio() {
        if (this.tilesPerOccupant == 0 || this.getOccupantCount() == 0) {
            return 0;
        }
        return this.floorTileCount / this.getOccupantCount();
    }

    public Boolean isOvercrowded() {
        int densityRatio = this.getOccupantDensityRatio();
        return densityRatio > 0 && densityRatio < this.tilesPerOccupant;
    }

    public int getAnimalDensityRatio() {
        if (this.animalSize == 0 || this.animalCount == 0) {
            return 0;
        }
        return this.floorTileCount / this.animalCount;
    }

    public Boolean isPenFull() {
        int densityRatio = this.getAnimalDensityRatio();
        return densityRatio < this.animalSize;
    }

    protected void clearData() {
        this.structureId = rand.nextInt();
        this.structureType = null;
        this.framePosition = null;
        this.isValid = false;
        this.floorTileCount = 0;
        this.tilesPerOccupant = 0;
        this.isAnimalPen = false;
        this.animalCount = 0;
        this.animalSize = 0;
        this.occupants = new ArrayList<ResidentData>();
    }

    protected void populateData(VillageStructure structure) {
        this.clearData();
        if (structure != null) {
            this.structureId = structure.getItemFrame().func_145782_y();
            this.structureType = structure.type;
            this.framePosition = structure.getFramePos();
            this.isValid = structure.isValid();
            List<BlockPos> floorTiles = TektopiaUtils.getStructureFloorTiles(structure);
            this.floorTileCount = floorTiles == null ? 0 : floorTiles.size();
            this.tilesPerOccupant = structure.type.tilesPerVillager;
            List occupants = structure.getEntitiesInside(EntityVillagerTek.class);
            for (EntityVillagerTek occupant : occupants) {
                if (occupant.isRole(VillagerRole.VISITOR)) {
                    this.occupants.add(new VisitorData(occupant));
                    continue;
                }
                this.occupants.add(new ResidentData(occupant));
            }
            if (structure instanceof VillageStructureRancherPen) {
                VillageStructureRancherPen rancherPen = (VillageStructureRancherPen)structure;
                this.isAnimalPen = true;
                this.animalCount = TektopiaUtils.getStructureAnimalCount(rancherPen);
                this.animalSize = rancherPen.getAnimalSize();
            }
        }
    }

    public void readNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        this.structureId = nbtTag.func_74764_b(NBTTAG_VILLAGE_STRUCTUREID) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_STRUCTUREID) : rand.nextInt();
        this.structureType = nbtTag.func_74764_b(NBTTAG_VILLAGE_STRUCTURETYPE) ? VillageStructureType.valueOf((String)nbtTag.func_74779_i(NBTTAG_VILLAGE_STRUCTURETYPE)) : null;
        this.framePosition = nbtTag.func_74764_b(NBTTAG_VILLAGE_STRUCTUREPOSITION) ? BlockPos.func_177969_a((long)nbtTag.func_74763_f(NBTTAG_VILLAGE_STRUCTUREPOSITION)) : null;
        this.isValid = nbtTag.func_74764_b(NBTTAG_VILLAGE_STRUCTUREVALID) && nbtTag.func_74767_n(NBTTAG_VILLAGE_STRUCTUREPOSITION);
        this.floorTileCount = nbtTag.func_74764_b(NBTTAG_VILLAGE_STRUCTUREFLOORTILECOUNT) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_STRUCTUREFLOORTILECOUNT) : 0;
        this.tilesPerOccupant = nbtTag.func_74764_b(NBTTAG_VILLAGE_STRUCTURETILESPEROCCUPANT) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_STRUCTURETILESPEROCCUPANT) : 0;
        this.isAnimalPen = nbtTag.func_74764_b(NBTTAG_VILLAGE_STRUCTUREANIMALPEN) && nbtTag.func_74767_n(NBTTAG_VILLAGE_STRUCTUREANIMALPEN);
        this.animalCount = nbtTag.func_74764_b(NBTTAG_VILLAGE_STRUCTUREANIMALCOUNT) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_STRUCTUREANIMALCOUNT) : 0;
        int n = this.animalSize = nbtTag.func_74764_b(NBTTAG_VILLAGE_STRUCTUREANIMALSIZE) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_STRUCTUREANIMALSIZE) : 0;
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_STRUCTUREOCCUPANTS)) {
            NBTTagList nbtTagListOccupants = nbtTag.func_150295_c(NBTTAG_VILLAGE_STRUCTUREOCCUPANTS, 3);
            for (int index = 0; index < nbtTagListOccupants.func_74745_c(); ++index) {
                int nbtTagId = nbtTagListOccupants.func_186858_c(index);
                if (this.villageData == null) continue;
                ResidentData occupant = this.villageData.getResidentsData().getResidentById(nbtTagId);
                if (occupant == null) {
                    occupant = this.villageData.getVisitorsData().getVisitorById(nbtTagId);
                }
                if (occupant == null) continue;
                this.occupants.add(occupant);
            }
        }
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        nbtTag.func_74768_a(NBTTAG_VILLAGE_STRUCTUREID, this.structureId);
        if (this.structureType != null) {
            nbtTag.func_74778_a(NBTTAG_VILLAGE_STRUCTURETYPE, this.structureType.name());
        }
        if (this.framePosition != null) {
            nbtTag.func_74772_a(NBTTAG_VILLAGE_STRUCTUREPOSITION, this.framePosition.func_177986_g());
        }
        if (this.isValid) {
            nbtTag.func_74757_a(NBTTAG_VILLAGE_STRUCTUREVALID, this.isValid);
        }
        if (this.floorTileCount > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_STRUCTUREFLOORTILECOUNT, this.floorTileCount);
        }
        if (this.tilesPerOccupant > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_STRUCTURETILESPEROCCUPANT, this.tilesPerOccupant);
        }
        if (this.isAnimalPen) {
            nbtTag.func_74757_a(NBTTAG_VILLAGE_STRUCTUREANIMALPEN, this.isAnimalPen);
            nbtTag.func_74768_a(NBTTAG_VILLAGE_STRUCTUREANIMALCOUNT, this.animalCount);
            nbtTag.func_74768_a(NBTTAG_VILLAGE_STRUCTUREANIMALSIZE, this.animalSize);
        }
        if (this.occupants != null && this.occupants.size() > 0) {
            NBTTagList nbtTagListOccupants = new NBTTagList();
            for (ResidentData occupant : this.occupants) {
                nbtTagListOccupants.func_74742_a((NBTBase)new NBTTagInt(occupant.getId()));
            }
            nbtTag.func_74782_a(NBTTAG_VILLAGE_STRUCTUREOCCUPANTS, (NBTBase)nbtTagListOccupants);
        }
        return nbtTag;
    }
}

