/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.common.Interfaces.IVillageEnemy;
import bletch.common.utils.StringUtils;
import bletch.tektopiainformation.network.data.EntityData;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.nbt.NBTTagCompound;
import net.tangotek.tektopia.entities.EntityNecromancer;
import net.tangotek.tektopia.entities.EntityVillageNavigator;

public class EnemyData
extends EntityData {
    protected static final String NBTTAG_VILLAGE_ENEMYTYPE = "type";
    protected static final String NBTTAG_VILLAGE_ENEMYCURRENTTASK = "task";
    protected String enemyType;
    protected String currentTask;

    public EnemyData(EntityVillageNavigator enemy) {
        super(enemy, false);
        this.populateData(enemy);
    }

    public EnemyData(NBTTagCompound nbtTag) {
        this.readNBT(nbtTag);
    }

    public String getEnemyType() {
        return this.enemyType;
    }

    public String getCurrentTask() {
        return this.currentTask;
    }

    @Override
    protected void clearData() {
        super.clearData();
        this.enemyType = null;
        this.currentTask = null;
    }

    @Override
    protected void populateData(EntityVillageNavigator entity) {
        super.populateData(entity);
        if (entity != null) {
            String className = entity.getClass().getSimpleName().toUpperCase();
            if (className.startsWith("ENTITY")) {
                this.enemyType = className.substring("ENTITY".length());
            }
            if (entity instanceof EntityNecromancer) {
                this.level = ((EntityNecromancer)entity).getLevel();
            }
            if (entity instanceof IVillageEnemy) {
                this.level = ((IVillageEnemy)entity).getLevel();
            }
            for (EntityAITasks.EntityAITaskEntry task : entity.field_70714_bg.field_75782_a) {
                if (task == null || task.field_75733_a == null || !task.field_188524_c) continue;
                this.currentTask = task.field_75733_a.getClass().getSimpleName();
            }
        }
    }

    @Override
    public void readNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        super.readNBT(nbtTag);
        this.enemyType = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENEMYTYPE) ? nbtTag.func_74779_i(NBTTAG_VILLAGE_ENEMYTYPE) : null;
        this.currentTask = nbtTag.func_74764_b(NBTTAG_VILLAGE_ENEMYCURRENTTASK) ? nbtTag.func_74779_i(NBTTAG_VILLAGE_ENEMYCURRENTTASK) : null;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        nbtTag = super.writeNBT(nbtTag);
        if (!StringUtils.isNullOrWhitespace(this.enemyType).booleanValue()) {
            nbtTag.func_74778_a(NBTTAG_VILLAGE_ENEMYTYPE, this.enemyType);
        }
        if (!StringUtils.isNullOrWhitespace(this.currentTask).booleanValue()) {
            nbtTag.func_74778_a(NBTTAG_VILLAGE_ENEMYCURRENTTASK, this.currentTask);
        }
        return nbtTag;
    }
}

