/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.utils;

import bletch.common.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

@ParametersAreNonnullByDefault
public class TextUtils {
    public static final String SEPARATOR_COLON = " : ";
    public static final String SEPARATOR_DASH = " - ";
    public static final String SEPARATOR_FSLASH = "/";
    public static final String SEPARATOR_TIMES = " x ";
    public static final String INDENT = "  ";
    public static final String SYMBOL_BULLET = "\u2022";
    public static final String SYMBOL_GREENTICK = TextFormatting.DARK_GREEN + "\u2714";
    public static final String SYMBOL_GREENCROSS = TextFormatting.DARK_GREEN + "\u2718";
    public static final String SYMBOL_REDCROSS = TextFormatting.RED + "\u2718";
    public static final String SYMBOL_REDTICK = TextFormatting.RED + "\u2714";
    public static final String SYMBOL_UNKNOWN = TextFormatting.GOLD + "?";
    public static final String SYMBOL_FEMALE = TextFormatting.LIGHT_PURPLE + "\u2640";
    public static final String SYMBOL_MALE = TextFormatting.BLUE + "\u2642";
    public static final String KEY_HELP = "gui.help";
    public static final String KEY_INFO = "gui.info";
    public static final String KEY_CONTROLHELP = "gui.showcontrolhelp";
    public static final String KEY_CONTROLINFO = "gui.showcontrolinfo";
    public static final String KEY_SHIFTHELP = "gui.showshifthelp";
    public static final String KEY_SHIFTINFO = "gui.showshiftinfo";

    public static boolean canTranslate(String translateKey) {
        if (StringUtils.isNullOrWhitespace(translateKey).booleanValue()) {
            return false;
        }
        String translate = TextUtils.translate(translateKey, new Object[0]);
        return StringUtils.isNullOrWhitespace(translate) == false && !translate.equalsIgnoreCase(translateKey);
    }

    public static String translate(String translateKey, Object ... translationArgs) {
        if (StringUtils.isNullOrWhitespace(translateKey).booleanValue()) {
            return null;
        }
        TextComponentTranslation itextcomponent = new TextComponentTranslation(translateKey, translationArgs);
        String translate = itextcomponent.func_150260_c();
        return StringUtils.isNullOrWhitespace(translate) != false || translate.equalsIgnoreCase(translateKey) ? null : translate;
    }

    public static List<String> translateMulti(String translateKey, Object ... translationArgs) {
        if (StringUtils.isNullOrWhitespace(translateKey).booleanValue()) {
            return null;
        }
        String translate = TextUtils.translate(translateKey, translationArgs);
        if (StringUtils.isNullOrWhitespace(translate).booleanValue() || translate.equalsIgnoreCase(translateKey)) {
            return null;
        }
        String[] values = translate.split("\\\\n");
        return Arrays.asList(values);
    }
}

