/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.player;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.world.World;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.adts.ADTSDemultiplexer;

public class AACPlayer {
    private final Deque<SourceDataLine> linesPlaying = new ConcurrentLinkedDeque<SourceDataLine>();
    private float volume = 0.0f;
    private int posX;
    private int posY;
    private int posZ;
    private World world;
    private String streamURL;
    private SourceDataLine line;

    public void setID(World world, int x, int y, int z) {
    }

    public void play(String streamURL) throws IOException, LineUnavailableException, URISyntaxException {
        this.streamURL = streamURL;
        SampleBuffer buf = new SampleBuffer();
        DataLine line = null;
        try {
            String x;
            URI uri = new URI(this.streamURL);
            Socket sock = new Socket(uri.getHost(), uri.getPort() > 0 ? uri.getPort() : 80);
            PrintStream out = new PrintStream(sock.getOutputStream());
            String path = uri.getPath();
            if (path == null || path.equals("")) {
                path = "/";
            }
            if (uri.getQuery() != null) {
                path = path + "?" + uri.getQuery();
            }
            out.println("GET " + path + " HTTP/1.1");
            out.println("Host: " + uri.getHost());
            out.println();
            DataInputStream in = new DataInputStream(sock.getInputStream());
            while ((x = in.readLine()) != null && !x.trim().equals("")) {
            }
            ADTSDemultiplexer adts = new ADTSDemultiplexer((InputStream)in);
            AudioFormat aufmt = new AudioFormat(adts.getSampleFrequency(), 16, adts.getChannelCount(), true, true);
            Decoder dec = new Decoder(adts.getDecoderSpecificInfo());
            while (true) {
                byte[] b = adts.readNextFrame();
                dec.decodeFrame(b, buf);
                if (line != null && AACPlayer.formatChanged(line.getFormat(), buf)) {
                    line.stop();
                    line.close();
                    line = null;
                    aufmt = new AudioFormat(buf.getSampleRate(), buf.getBitsPerSample(), buf.getChannels(), true, true);
                }
                if (line == null) {
                    line = AudioSystem.getSourceDataLine((AudioFormat)aufmt);
                    line.open();
                    line.start();
                }
                b = buf.getData();
                line.write(b, 0, b.length);
            }
        }
        catch (Throwable throwable) {
            if (line != null) {
                line.stop();
                line.close();
            }
            throw throwable;
        }
    }

    public boolean isPlaying() {
        return this.line.isActive();
    }

    public void setVolume(float f) {
    }

    public float getVolume() {
        return 0.0f;
    }

    public void stop() {
        this.line.drain();
        this.line.stop();
        this.line.close();
    }

    private static boolean formatChanged(AudioFormat af, SampleBuffer buf) {
        return af.getSampleRate() != (float)buf.getSampleRate() || af.getChannels() != buf.getChannels() || af.getSampleSizeInBits() != buf.getBitsPerSample() || af.isBigEndian() != buf.isBigEndian();
    }
}

