/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.network.message;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import pcl.OpenFM.TileEntity.TileEntityRadio;
import pcl.OpenFM.network.message.BaseRadioMessage;

public class MessageRadioSync
extends BaseRadioMessage {
    private String streamURL = "";
    private int screenColor = 255;
    private String screenText = "OpenFM";
    private boolean playing;
    private float volume;

    public MessageRadioSync() {
    }

    public MessageRadioSync(TileEntityRadio radio) {
        super(radio);
        this.streamURL = radio.streamURL;
        this.screenColor = radio.getScreenColor();
        this.screenText = radio.getScreenText();
        this.playing = radio.isPlaying;
        this.volume = radio.volume;
    }

    @Override
    public void onMessage(TileEntityRadio radio, MessageContext ctx) {
        radio.streamURL = this.streamURL;
        radio.screenColor = this.screenColor;
        radio.screenText = this.screenText;
        radio.volume = this.volume;
        if (this.playing) {
            if (radio.isValid) {
                try {
                    radio.startStream();
                }
                catch (Exception e) {
                    radio.stopStream();
                }
            }
        } else {
            radio.stopStream();
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.streamURL = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.screenColor = buf.readInt();
        this.screenText = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.playing = buf.readBoolean();
        this.volume = buf.readFloat();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.streamURL);
        buf.writeInt(this.screenColor);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.screenText);
        buf.writeBoolean(this.playing);
        buf.writeFloat(this.volume);
    }
}

