/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pcl.OpenFM.Block.BlockRadio;
import pcl.OpenFM.Block.BlockSpeaker;
import pcl.OpenFM.Handler.OFMBreakEvent;
import pcl.OpenFM.Items.ItemMemoryCard;
import pcl.OpenFM.Items.ItemTuner;
import pcl.OpenFM.TileEntity.TileEntityRadio;
import pcl.OpenFM.TileEntity.TileEntitySpeaker;

@Mod.EventBusSubscriber
public class ContentRegistry {
    public static Block blockRadio;
    public static Block blockSpeaker;
    public static Item itemRadioTuner;
    public static Item itemMemoryCard;
    public static CreativeTabs creativeTab;

    public static Item init(Item item, String name) {
        return (Item)item.func_77655_b(name).setRegistryName("openfm:" + name);
    }

    public static Block init(Block block, String name) {
        return (Block)block.func_149663_c(name).setRegistryName("openfm:" + name);
    }

    public static void preInit() {
        blockRadio = ContentRegistry.init(new BlockRadio(), "radio");
        GameRegistry.registerTileEntity(TileEntityRadio.class, (String)"OpenFMRadio");
        blockSpeaker = ContentRegistry.init(new BlockSpeaker(), "speaker");
        GameRegistry.registerTileEntity(TileEntitySpeaker.class, (String)"OpenFMSpeaker");
        itemRadioTuner = ContentRegistry.init(new ItemTuner(), "radiotuner");
        itemMemoryCard = ContentRegistry.init(new ItemMemoryCard(), "memorycard");
        ContentRegistry.registerEvents();
        ContentRegistry.registerTabs();
        blockRadio.func_149647_a(creativeTab);
        blockSpeaker.func_149647_a(creativeTab);
        itemRadioTuner.func_77637_a(creativeTab);
        itemMemoryCard.func_77637_a(creativeTab);
        if (Loader.isModLoaded((String)"computercraft")) {
            ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)((IPeripheralProvider)blockRadio));
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> register) {
        register.getRegistry().register((IForgeRegistryEntry)blockRadio);
        register.getRegistry().register((IForgeRegistryEntry)blockSpeaker);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> register) {
        register.getRegistry().register((IForgeRegistryEntry)itemRadioTuner);
        register.getRegistry().register((IForgeRegistryEntry)itemMemoryCard);
        register.getRegistry().register(new ItemBlock(blockRadio).func_77637_a(creativeTab).setRegistryName(blockRadio.getRegistryName()));
        register.getRegistry().register(new ItemBlock(blockSpeaker).func_77637_a(creativeTab).setRegistryName(blockSpeaker.getRegistryName()));
    }

    public static void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new OFMBreakEvent());
    }

    public static void registerTabs() {
        creativeTab = new CreativeTabs("tabOpenFM"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(Item.func_150898_a((Block)blockRadio));
            }

            @SideOnly(value=Side.CLIENT)
            public String func_78024_c() {
                return I18n.func_74838_a((String)"itemgroup.tabopenfm");
            }
        };
    }

    public static boolean checkBlock(World w, BlockPos pos) {
        return w.func_180495_p(pos).func_177230_c() instanceof BlockRadio;
    }
}

