/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.callback;

import com.google.common.base.Preconditions;
import net.malisis.core.util.callback.CallbackResult;

public interface ICallback<T> {
    public CallbackResult<T> call(Object ... var1);

    public static class CallbackOption<P extends ICallbackPredicate> {
        private static final CallbackOption<ICallbackPredicate> DEFAULT = new CallbackOption<Object>(null, Priority.NORMAL);
        private P predicate = params -> true;
        private Priority priority;

        private CallbackOption(P predicate, Priority priority) {
            this.predicate = predicate;
            this.priority = priority;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public boolean apply(Object ... params) {
            return this.predicate != null ? this.predicate.apply(params) : true;
        }

        public static <P extends ICallbackPredicate> CallbackOption<P> of() {
            return DEFAULT;
        }

        public static <P extends ICallbackPredicate> CallbackOption<P> of(P predicate) {
            return new CallbackOption<ICallbackPredicate>((ICallbackPredicate)Preconditions.checkNotNull(predicate), Priority.NORMAL);
        }

        public static <P extends ICallbackPredicate> CallbackOption<P> of(Priority priority) {
            return new CallbackOption<Object>(null, priority);
        }

        public static <P extends ICallbackPredicate> CallbackOption<P> of(P predicate, Priority priority) {
            return new CallbackOption<ICallbackPredicate>((ICallbackPredicate)Preconditions.checkNotNull(predicate), priority);
        }
    }

    public static interface ICallbackPredicate {
        public static final ICallbackPredicate ALWAYS_TRUE = params -> true;
        public static final ICallbackPredicate ALWAYS_FALSE = params -> false;

        public boolean apply(Object ... var1);

        default public ICallbackPredicate and(ICallbackPredicate predicate) {
            Preconditions.checkNotNull((Object)predicate);
            return params -> this.apply(params) && predicate.apply(params);
        }

        default public ICallbackPredicate negate() {
            return params -> !this.apply(params);
        }

        default public ICallbackPredicate or(ICallbackPredicate predicate) {
            Preconditions.checkNotNull((Object)predicate);
            return params -> this.apply(params) || predicate.apply(params);
        }

        public static ICallbackPredicate alwaysTrue() {
            return ALWAYS_TRUE;
        }

        public static ICallbackPredicate alwaysFalse() {
            return ALWAYS_FALSE;
        }
    }

    public static enum Priority {
        LOWEST,
        LOW,
        NORMAL,
        HIGH,
        HIGHEST;

    }
}

