/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.advancements.ARAdvancements;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.IPlanetDefiner;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleData;
import zmaster587.advancedRocketry.inventory.modules.ModulePlanetImage;
import zmaster587.advancedRocketry.inventory.modules.ModulePlanetSelector;
import zmaster587.advancedRocketry.item.ItemData;
import zmaster587.advancedRocketry.item.ItemPlanetIdentificationChip;
import zmaster587.advancedRocketry.network.PacketSpaceStationInfo;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.tile.multiblock.TileWarpCore;
import zmaster587.advancedRocketry.util.IDataInventory;
import zmaster587.advancedRocketry.world.util.MultiData;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.client.util.IndicatorBarImage;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IDataSync;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ISelectionNotify;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleScaledImage;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleSync;
import zmaster587.libVulpes.inventory.modules.ModuleTab;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTexturedSlotArray;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileWarpController
extends TileEntity
implements ITickable,
IModularInventory,
ISelectionNotify,
INetworkMachine,
IButtonInventory,
IProgressBar,
IDataSync,
IGuiCallback,
IDataInventory,
IPlanetDefiner {
    protected ModulePlanetSelector container;
    private ModuleText canWarp;
    private DimensionProperties dimCache;
    private SpaceStationObject station;
    private static final int ARTIFACT_BEGIN_RANGE = 4;
    private static final int ARTIFACT_END_RANGE = 8;
    private ModulePlanetImage srcPlanetImg;
    private ModulePlanetImage dstPlanetImg;
    private ModuleSync sync1;
    private ModuleSync sync2;
    private ModuleSync sync3;
    private ModuleText srcPlanetText;
    private ModuleText dstPlanetText;
    private ModuleText warpFuel;
    private ModuleText status;
    private ModuleText warpCapacity;
    private int warpCost = -1;
    private int dstPlanet;
    private int srcPlanet;
    private ModuleTab tabModule = new ModuleTab(4, 0, 0, (IGuiCallback)this, 3, new String[]{LibVulpes.proxy.getLocalizedString("msg.warpmon.tab.warp"), LibVulpes.proxy.getLocalizedString("msg.warpmon.tab.data"), LibVulpes.proxy.getLocalizedString("msg.warpmon.tab.tracking")}, (ResourceLocation[][])new ResourceLocation[][]{TextureResources.tabWarp, TextureResources.tabData, TextureResources.tabPlanetTracking});
    private static final byte TAB_SWITCH = 4;
    private static final byte STORE_DATA = 10;
    private static final byte LOAD_DATA = 20;
    private static final byte SEARCH = 5;
    private static final byte PROGRAMFROMCHIP = 6;
    private MultiData data = new MultiData();
    private EmbeddedInventory inv;
    private static final int DISTANCESLOT = 0;
    private static final int MASSSLOT = 1;
    private static final int COMPOSITION = 2;
    private static final int PLANETSLOT = 3;
    private static final int MAX_PROGRESS = 1000;
    private ModuleProgress programmingProgress;
    private int progress;

    public TileWarpController() {
        this.data.setMaxData(10000);
        this.inv = new EmbeddedInventory(9);
        this.programmingProgress = new ModuleProgress(35, 80, 3, TextureResources.terraformProgressBar, (IProgressBar)this);
        this.progress = -1;
    }

    private SpaceStationObject getSpaceObject() {
        ISpaceObject spaceObject;
        if (this.station == null && this.field_145850_b.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId && (spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) instanceof SpaceStationObject) {
            this.station = (SpaceStationObject)spaceObject;
        }
        return this.station;
    }

    protected int getTravelCost() {
        if (this.getSpaceObject() != null) {
            DimensionProperties properties = this.getSpaceObject().getProperties().getParentProperties();
            DimensionProperties destProperties = DimensionManager.getInstance().getDimensionProperties(this.getSpaceObject().getDestOrbitingBody());
            if (properties == DimensionManager.defaultSpaceDimensionProperties) {
                return Integer.MAX_VALUE;
            }
            if (destProperties.getStar() != properties.getStar()) {
                return 500;
            }
            while (destProperties.getParentProperties() != null && destProperties.isMoon()) {
                destProperties = destProperties.getParentProperties();
            }
            if (destProperties.isMoon() && destProperties.getParentPlanet() == properties.getId() || properties.isMoon() && properties.getParentPlanet() == destProperties.getId()) {
                return 1;
            }
            while (properties.isMoon()) {
                properties = properties.getParentProperties();
            }
            if (properties.getStar().getId() == destProperties.getStar().getId()) {
                double x1 = (float)properties.orbitalDist * MathHelper.func_76134_b((float)((float)properties.orbitTheta));
                double y1 = (float)properties.orbitalDist * MathHelper.func_76126_a((float)((float)properties.orbitTheta));
                double x2 = (float)destProperties.orbitalDist * MathHelper.func_76134_b((float)((float)destProperties.orbitTheta));
                double y2 = (float)destProperties.orbitalDist * MathHelper.func_76126_a((float)((float)destProperties.orbitTheta));
                return Math.max((int)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0)), 1);
            }
        }
        return Integer.MAX_VALUE;
    }

    public int getTravelCostToDimension(int destinationID) {
        if (this.getSpaceObject() != null) {
            DimensionProperties properties = this.getSpaceObject().getProperties().getParentProperties();
            DimensionProperties destProperties = DimensionManager.getInstance().getDimensionProperties(destinationID);
            if (properties == DimensionManager.defaultSpaceDimensionProperties) {
                return Integer.MAX_VALUE;
            }
            if (destProperties.getStar() != properties.getStar()) {
                return 500;
            }
            while (destProperties.getParentProperties() != null && destProperties.isMoon()) {
                destProperties = destProperties.getParentProperties();
            }
            if (destProperties.isMoon() && destProperties.getParentPlanet() == properties.getId() || properties.isMoon() && properties.getParentPlanet() == destProperties.getId()) {
                return 1;
            }
            while (properties.isMoon()) {
                properties = properties.getParentProperties();
            }
            if (properties.getStar().getId() == destProperties.getStar().getId()) {
                double x1 = (float)properties.orbitalDist * MathHelper.func_76134_b((float)((float)properties.orbitTheta));
                double y1 = (float)properties.orbitalDist * MathHelper.func_76126_a((float)((float)properties.orbitTheta));
                double x2 = (float)destProperties.orbitalDist * MathHelper.func_76134_b((float)((float)destProperties.orbitTheta));
                double y2 = (float)destProperties.orbitalDist * MathHelper.func_76126_a((float)((float)destProperties.orbitTheta));
                return Math.max((int)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0)), 1);
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        return this.data.addData(maxAmount, type, dir, commit);
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        return this.data.extractData(maxAmount, type, dir, commit);
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        if (ID == GuiHandler.guiId.MODULARNOINV.ordinal()) {
            if (this.tabModule.getTab() == 0) {
                boolean artifactFlag;
                boolean isOnStation;
                modules.add((ModuleBase)this.tabModule);
                if (this.sync1 == null) {
                    this.sync1 = new ModuleSync(0, (IDataSync)this);
                    this.sync2 = new ModuleSync(1, (IDataSync)this);
                    this.sync3 = new ModuleSync(2, (IDataSync)this);
                }
                modules.add((ModuleBase)this.sync1);
                modules.add((ModuleBase)this.sync2);
                modules.add((ModuleBase)this.sync3);
                SpaceStationObject station = this.getSpaceObject();
                boolean bl = isOnStation = station != null;
                if (this.field_145850_b.field_72995_K) {
                    this.setPlanetModuleInfo();
                }
                int baseX = 10;
                int baseY = 20;
                int sizeX = 70;
                int sizeY = 70;
                if (this.field_145850_b.field_72995_K) {
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY, sizeX, sizeY, zmaster587.libVulpes.inventory.TextureResources.starryBG));
                    modules.add(this.srcPlanetImg);
                    ModuleText text = new ModuleText(baseX + 4, baseY + 4, "Orbiting:", 0xFFFFFF);
                    text.setAlwaysOnTop(true);
                    modules.add((ModuleBase)text);
                    modules.add((ModuleBase)this.srcPlanetText);
                    modules.add((ModuleBase)new ModuleScaledImage(baseX - 3, baseY, 3, sizeY, TextureResources.verticalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX + sizeX, baseY, -3, sizeY, TextureResources.verticalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY, 70, 3, TextureResources.horizontalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY + sizeY - 3, 70, -3, TextureResources.horizontalBar));
                }
                modules.add((ModuleBase)new ModuleButton(baseX - 3, baseY + sizeY, 0, LibVulpes.proxy.getLocalizedString("msg.warpmon.selectplanet"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, sizeX + 6, 16));
                modules.add((ModuleBase)new ModuleText(baseX, baseY + sizeY + 20, LibVulpes.proxy.getLocalizedString("msg.warpmon.corestatus"), 0x1B1B1B));
                boolean flag = isOnStation && this.getSpaceObject().getFuelAmount() >= this.getTravelCost() && this.getSpaceObject().hasUsableWarpCore();
                flag = flag && this.getSpaceObject().getDestOrbitingBody() != -2147483647 && this.getSpaceObject().getOrbitingPlanetId() != this.getSpaceObject().getDestOrbitingBody();
                boolean bl2 = artifactFlag = this.dimCache != null && this.meetsArtifactReq(this.dimCache);
                this.canWarp = new ModuleText(baseX, baseY + sizeY + 30, isOnStation && this.getSpaceObject().isAnchored() ? LibVulpes.proxy.getLocalizedString("msg.warpmon.anchored") : (isOnStation && (this.getSpaceObject().getDestOrbitingBody() == -2147483647 || this.getSpaceObject().getOrbitingPlanetId() == this.getSpaceObject().getDestOrbitingBody()) ? LibVulpes.proxy.getLocalizedString("msg.warpmon.nowhere") : (!artifactFlag ? LibVulpes.proxy.getLocalizedString("msg.warpmon.missingart") : (flag ? LibVulpes.proxy.getLocalizedString("msg.warpmon.ready") : LibVulpes.proxy.getLocalizedString("msg.warpmon.notready")))), flag && artifactFlag && !this.getSpaceObject().isAnchored() ? 0x1BAA1B : 0xFF1B1B);
                modules.add((ModuleBase)this.canWarp);
                modules.add((ModuleBase)new ModuleProgress(baseX, baseY + sizeY + 40, 10, (ProgressBarImage)new IndicatorBarImage(70, 58, 53, 8, 122, 58, 5, 8, EnumFacing.EAST, TextureResources.progressBars), (IProgressBar)this));
                this.warpCost = this.getTravelCost();
                baseX = 94;
                baseY = 20;
                sizeX = 70;
                sizeY = 70;
                ModuleButton warp = new ModuleButton(baseX - 3, baseY + sizeY, 1, LibVulpes.proxy.getLocalizedString("msg.warpmon.warp"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, sizeX + 6, 16);
                modules.add((ModuleBase)warp);
                if (this.dimCache == null && isOnStation && station.getOrbitingPlanetId() != Integer.MIN_VALUE) {
                    this.dimCache = DimensionManager.getInstance().getDimensionProperties(station.getOrbitingPlanetId());
                }
                if (!this.field_145850_b.field_72995_K && isOnStation) {
                    PacketHandler.sendToPlayer((BasePacket)new PacketSpaceStationInfo(this.getSpaceObject().getId(), this.getSpaceObject()), (EntityPlayer)player);
                }
                if (this.field_145850_b.field_72995_K) {
                    this.warpFuel.setText(LibVulpes.proxy.getLocalizedString("msg.warpmon.fuelcost") + (flag ? String.valueOf(this.warpCost) : LibVulpes.proxy.getLocalizedString("msg.warpmon.na")));
                    this.warpCapacity.setText(LibVulpes.proxy.getLocalizedString("msg.warpmon.fuel") + (isOnStation ? Integer.valueOf(this.getSpaceObject().getFuelAmount()) : LibVulpes.proxy.getLocalizedString("msg.warpmon.na")));
                    modules.add((ModuleBase)this.warpFuel);
                    modules.add((ModuleBase)this.warpCapacity);
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY, sizeX, sizeY, zmaster587.libVulpes.inventory.TextureResources.starryBG));
                    if (this.dimCache != null && this.field_145850_b.field_72995_K) {
                        modules.add(this.dstPlanetImg);
                    }
                    ModuleText text = new ModuleText(baseX + 4, baseY + 4, LibVulpes.proxy.getLocalizedString("msg.warpmon.dest"), 0xFFFFFF);
                    text.setAlwaysOnTop(true);
                    modules.add((ModuleBase)text);
                    modules.add((ModuleBase)this.dstPlanetText);
                    modules.add((ModuleBase)new ModuleScaledImage(baseX - 3, baseY, 3, sizeY, TextureResources.verticalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX + sizeX, baseY, -3, sizeY, TextureResources.verticalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY, 70, 3, TextureResources.horizontalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY + sizeY - 3, 70, -3, TextureResources.horizontalBar));
                }
            } else if (this.tabModule.getTab() == 1) {
                modules.add((ModuleBase)this.tabModule);
                modules.add(new ModuleData(35, 20, 0, this, this.data.getDataStorageForType(DataStorage.DataType.DISTANCE)));
                modules.add(new ModuleData(75, 20, 1, this, this.data.getDataStorageForType(DataStorage.DataType.MASS)));
                modules.add(new ModuleData(115, 20, 2, this, this.data.getDataStorageForType(DataStorage.DataType.COMPOSITION)));
            } else {
                modules.add((ModuleBase)this.tabModule);
                modules.add((ModuleBase)new ModuleText(65, 20, LibVulpes.proxy.getLocalizedString("msg.warpmon.artifact"), 0x202020));
                modules.add((ModuleBase)new ModuleSlotArray(30, 35, (IInventory)this, 4, 5));
                modules.add((ModuleBase)new ModuleSlotArray(55, 60, (IInventory)this, 5, 6));
                modules.add((ModuleBase)new ModuleSlotArray(80, 35, (IInventory)this, 6, 7));
                modules.add((ModuleBase)new ModuleSlotArray(105, 60, (IInventory)this, 7, 8));
                modules.add((ModuleBase)new ModuleSlotArray(130, 35, (IInventory)this, 8, 9));
                modules.add((ModuleBase)new ModuleButton(50, 117, 3, LibVulpes.proxy.getLocalizedString("msg.warpmon.search"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, LibVulpes.proxy.getLocalizedString("msg.warpmon.datareq"), 100, 10));
                modules.add((ModuleBase)new ModuleButton(50, 127, 4, LibVulpes.proxy.getLocalizedString("msg.warpmon.chip"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, 100, 10));
                modules.add((ModuleBase)new ModuleTexturedSlotArray(30, 120, (IInventory)this, 3, 4, TextureResources.idChip));
                modules.add((ModuleBase)this.programmingProgress);
            }
        } else if (ID == GuiHandler.guiId.MODULARFULLSCREEN.ordinal()) {
            SpaceStationObject station = this.getSpaceObject();
            int starId = 0;
            if (station != null) {
                starId = station.getProperties().getParentProperties().getStar().getId();
            }
            this.container = new ModulePlanetSelector(starId, zmaster587.libVulpes.inventory.TextureResources.starryBG, this, this, true);
            this.container.setOffset(1000, 1000);
            this.container.setAllowStarSelection(true);
            modules.add((ModuleBase)this.container);
        }
        return modules;
    }

    private void setPlanetModuleInfo() {
        boolean flag;
        String planetName;
        DimensionProperties location;
        boolean isOnStation;
        SpaceStationObject station = this.getSpaceObject();
        boolean bl = isOnStation = station != null;
        if (isOnStation) {
            DimensionProperties properties;
            location = properties = DimensionManager.getInstance().getDimensionProperties(station.getOrbitingPlanetId());
            planetName = properties.getName();
        } else {
            location = DimensionManager.getInstance().getDimensionProperties(this.field_145850_b.field_73011_w.getDimension());
            planetName = DimensionManager.getInstance().getDimensionProperties(this.field_145850_b.field_73011_w.getDimension()).getName();
            if (planetName.isEmpty()) {
                planetName = "???";
            }
        }
        boolean bl2 = flag = isOnStation && this.getSpaceObject().getFuelAmount() >= this.warpCost && this.getSpaceObject().hasUsableWarpCore();
        if (this.canWarp != null) {
            boolean artifactFlag;
            flag = flag && this.getSpaceObject().getDestOrbitingBody() != -2147483647 && this.getSpaceObject().getOrbitingPlanetId() != this.getSpaceObject().getDestOrbitingBody();
            boolean bl3 = artifactFlag = this.dimCache != null && this.meetsArtifactReq(this.dimCache);
            this.canWarp.setText(isOnStation && this.getSpaceObject().isAnchored() ? LibVulpes.proxy.getLocalizedString("msg.warpmon.anchored") : (isOnStation && (this.getSpaceObject().getDestOrbitingBody() == -2147483647 || this.getSpaceObject().getOrbitingPlanetId() == this.getSpaceObject().getDestOrbitingBody()) ? LibVulpes.proxy.getLocalizedString("msg.warpmon.nowhere") : (!artifactFlag ? LibVulpes.proxy.getLocalizedString("msg.warpmon.missingart") : (flag ? LibVulpes.proxy.getLocalizedString("msg.warpmon.ready") : LibVulpes.proxy.getLocalizedString("msg.warpmon.notready")))));
            this.canWarp.setColor(flag && artifactFlag && !this.getSpaceObject().isAnchored() ? 0x1BAA1B : 0xFF1B1B);
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.srcPlanetImg == null) {
                int baseX = 10;
                int baseY = 20;
                int sizeX = 65;
                int sizeY = 65;
                this.srcPlanetImg = new ModulePlanetImage(baseX + 10, baseY + 10, sizeX - 20, location);
                this.srcPlanetText = new ModuleText(baseX + 4, baseY + 56, "", 0xFFFFFF);
                this.srcPlanetText.setAlwaysOnTop(true);
                this.warpFuel = new ModuleText(baseX + 100, baseY + sizeY + 25, "", 0x1B1B1B);
                this.warpCapacity = new ModuleText(baseX + 100, baseY + sizeY + 35, "", 0x1B1B1B);
                baseX = 94;
                baseY = 20;
                sizeX = 65;
                this.dstPlanetImg = new ModulePlanetImage(baseX + 10, baseY + 10, sizeX - 20, location);
                this.dstPlanetText = new ModuleText(baseX + 4, baseY + 56, "", 0xFFFFFF);
                this.dstPlanetText.setAlwaysOnTop(true);
            }
            this.srcPlanetImg.setDimProperties(location);
            this.srcPlanetText.setText(planetName);
            this.warpFuel.setText(LibVulpes.proxy.getLocalizedString("msg.warpmon.fuelcost") + (this.warpCost < Integer.MAX_VALUE ? String.valueOf(this.warpCost) : LibVulpes.proxy.getLocalizedString("msg.warpmon.na")));
            this.warpCapacity.setText(LibVulpes.proxy.getLocalizedString("msg.warpmon.fuel") + (isOnStation ? Integer.valueOf(station.getFuelAmount()) : LibVulpes.proxy.getLocalizedString("msg.warpmon.na")));
            DimensionProperties dstProps = null;
            if (isOnStation && station.getOrbitingPlanetId() != Integer.MIN_VALUE) {
                dstProps = DimensionManager.getInstance().getDimensionProperties(this.dstPlanet);
            }
            if (dstProps != null) {
                planetName = dstProps.getName();
                location = dstProps;
                this.dstPlanetImg.setDimProperties(location);
                this.dstPlanetText.setText(planetName);
                this.dstPlanetImg.setVisible(true);
            } else {
                this.dstPlanetText.setText("???");
                this.dstPlanetImg.setVisible(false);
            }
        }
    }

    public String getModularInventoryName() {
        return AdvancedRocketryBlocks.blockWarpShipMonitor.func_149732_F();
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (this.getSpaceObject() != null) {
            if (buttonId == 0) {
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
            } else if (buttonId == 1) {
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 2));
            } else if (buttonId == 3) {
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 5));
            } else if (buttonId == 4) {
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 6));
            }
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 1 || id == 3) {
            out.writeInt(this.container.getSelectedSystem());
        } else if (id == 4) {
            out.writeShort(this.tabModule.getTab());
        } else if (id >= 10 && id < 20) {
            out.writeByte(id - 10);
        } else if (id >= 20 && id < 30) {
            out.writeByte(id - 20);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 1 || packetId == 3) {
            nbt.func_74768_a("id", in.readInt());
        } else if (packetId == 4) {
            nbt.func_74777_a("tab", in.readShort());
        } else if (packetId >= 10 && packetId < 20) {
            nbt.func_74774_a("id", (byte)(in.readByte() - 10));
        } else if (packetId >= 20 && packetId < 30) {
            nbt.func_74774_a("id", (byte)(in.readByte() - 20));
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        ItemStack stack;
        SpaceStationObject spaceStationObject;
        if (id == 0) {
            player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARFULLSCREEN.ordinal(), this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        } else if (id == 1 || id == 3) {
            int dimId = nbt.func_74762_e("id");
            if (this.isPlanetKnown(DimensionManager.getInstance().getDimensionProperties(dimId))) {
                this.container.setSelectedSystem(dimId);
                this.selectSystem(dimId);
            }
            this.func_70296_d();
            if (id == 3) {
                player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            }
        } else if (id == 2) {
            SpaceStationObject station = this.getSpaceObject();
            if (station != null && !station.isAnchored() && station.hasUsableWarpCore() && station.useFuel(this.getTravelCost()) != 0 && this.meetsArtifactReq(DimensionManager.getInstance().getDimensionProperties(station.getDestOrbitingBody()))) {
                SpaceObjectManager.getSpaceManager().moveStationToBody((ISpaceObject)station, station.getDestOrbitingBody(), Math.max(Math.min(this.getTravelCost() * 5, 5000), 0));
                for (EntityPlayer player2 : this.field_145850_b.func_175661_b(EntityPlayer.class, input -> SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(input.func_180425_c()) == station)) {
                    ARAdvancements.ALL_SHE_GOT.trigger((EntityPlayerMP)player2);
                    if (DimensionManager.hasReachedWarp) continue;
                    ARAdvancements.FLIGHT_OF_PHOENIX.trigger((EntityPlayerMP)player2);
                }
                DimensionManager.hasReachedWarp = true;
                for (HashedBlockPosition vec : station.getWarpCoreLocations()) {
                    TileEntity tile = this.field_145850_b.func_175625_s(vec.getBlockPos());
                    if (!(tile instanceof TileWarpCore)) continue;
                    ((TileWarpCore)tile).onInventoryUpdated();
                }
            }
        } else if (id == 4 && !this.field_145850_b.field_72995_K) {
            this.tabModule.setTab((int)nbt.func_74765_d("tab"));
            player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), this.func_145831_w(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        } else if (id >= 10 && id < 20) {
            this.storeData(nbt.func_74771_c("id") + 10);
        } else if (id >= 20 && id < 30) {
            this.loadData(nbt.func_74771_c("id") + 20);
        } else if (id == 5) {
            if (this.progress == -1 && this.data.getDataAmount(DataStorage.DataType.COMPOSITION) >= 100 && this.data.getDataAmount(DataStorage.DataType.DISTANCE) >= 100 && this.data.getDataAmount(DataStorage.DataType.MASS) >= 100) {
                this.progress = 0;
            }
        } else if (id == 6 && (spaceStationObject = this.getSpaceObject()) != null && !(stack = this.func_70301_a(3)).func_190926_b() && stack.func_77973_b() instanceof ItemPlanetIdentificationChip && DimensionManager.getInstance().isDimensionCreated(((ItemPlanetIdentificationChip)stack.func_77973_b()).getDimensionId(stack))) {
            spaceStationObject.discoverPlanet(((ItemPlanetIdentificationChip)stack.func_77973_b()).getDimensionId(stack));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.inv.writeToNBT(compound);
        this.data.writeToNBT(compound);
        compound.func_74768_a("progress", this.progress);
        return super.func_189515_b(compound);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inv.readFromNBT(compound);
        this.data.readFromNBT(compound);
        this.progress = compound.func_74762_e("progress");
    }

    public void onSelectionConfirmed(Object sender) {
        this.onSelected(sender);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 3));
    }

    public void onSelected(Object sender) {
        this.selectSystem(this.container.getSelectedSystem());
    }

    private void selectSystem(int id) {
        if (this.getSpaceObject().getOrbitingPlanetId() == Integer.MIN_VALUE || id == Integer.MIN_VALUE) {
            this.dimCache = null;
        } else {
            this.dimCache = DimensionManager.getInstance().getDimensionProperties(this.container.getSelectedSystem());
            ISpaceObject station = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.func_174877_v());
            if (station != null) {
                station.setDestOrbitingBody(id);
            }
        }
    }

    public void onSystemFocusChanged(Object sender) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 1));
    }

    public float getNormallizedProgress(int id) {
        if (this.field_145850_b.field_72995_K) {
            this.setPlanetModuleInfo();
        }
        return (float)this.getProgress(id) / (float)this.getTotalProgress(id);
    }

    public void setProgress(int id, int progress) {
        if (id == 10) {
            if (this.getSpaceObject() != null) {
                this.getSpaceObject().setFuelAmount(progress);
            }
        } else if (id == 3) {
            this.progress = progress;
        }
    }

    public int getProgress(int id) {
        if (id == 10 && this.getSpaceObject() != null) {
            return this.getSpaceObject().getFuelAmount();
        }
        if (id == 0) {
            return 30;
        }
        if (id == 1) {
            return 30;
        }
        if (id == 2) {
            return 30;
        }
        if (id == 3) {
            return this.progress == -1 ? 0 : this.progress;
        }
        return 0;
    }

    public int getTotalProgress(int id) {
        if (id == 10 && this.getSpaceObject() != null) {
            return this.getSpaceObject().getMaxFuelAmount();
        }
        if (this.dimCache == null) {
            return 0;
        }
        if (id == 0) {
            return this.dimCache.getAtmosphereDensity() / 2;
        }
        if (id == 1) {
            return this.dimCache.orbitalDist / 2;
        }
        if (id == 2) {
            return (int)(this.dimCache.gravitationalMultiplier * 50.0f);
        }
        if (id == 3) {
            return 1000;
        }
        return 0;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void setData(int id, int value) {
        if (id == 2) {
            this.warpCost = value;
        }
        if (id == 1) {
            this.srcPlanet = value;
        } else if (id == 0) {
            this.dstPlanet = value;
        }
        this.setPlanetModuleInfo();
    }

    public int getData(int id) {
        boolean isOnStation;
        if (id == 2) {
            return this.getTravelCost();
        }
        SpaceStationObject station = this.getSpaceObject();
        boolean bl = isOnStation = station != null;
        if (isOnStation) {
            if (id == 1) {
                return station.getOrbitingPlanetId();
            }
            return station.getDestOrbitingBody();
        }
        return 0;
    }

    public void onModuleUpdated(ModuleBase module) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 4));
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return this.inv.func_70301_a(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return this.inv.func_70298_a(index, count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.inv.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public void func_174889_b(EntityPlayer player) {
        this.inv.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inv.func_174886_c(player);
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return this.inv.func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Nonnull
    public String func_70005_c_() {
        return this.getModularInventoryName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public void loadData(int id) {
        ItemData item;
        ItemStack stack = ItemStack.field_190927_a;
        DataStorage.DataType type = DataStorage.DataType.HUMIDITY;
        if (id == 0) {
            stack = this.inv.func_70301_a(0);
            type = DataStorage.DataType.DISTANCE;
        } else if (id == 1) {
            stack = this.inv.func_70301_a(1);
            type = DataStorage.DataType.MASS;
        } else if (id == 2) {
            stack = this.inv.func_70301_a(2);
            type = DataStorage.DataType.COMPOSITION;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemData && (item = (ItemData)stack.func_77973_b()).getDataType(stack) == type) {
            item.removeData(stack, this.addData(item.getData(stack), item.getDataType(stack), EnumFacing.UP, true), type);
        }
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(20 + id)));
        }
    }

    @Override
    public void storeData(int id) {
        ItemStack stack = ItemStack.field_190927_a;
        DataStorage.DataType type = null;
        if (id == 0) {
            stack = this.inv.func_70301_a(0);
            type = DataStorage.DataType.DISTANCE;
        } else if (id == 1) {
            stack = this.inv.func_70301_a(1);
            type = DataStorage.DataType.MASS;
        } else if (id == 2) {
            stack = this.inv.func_70301_a(2);
            type = DataStorage.DataType.COMPOSITION;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemData) {
            ItemData item = (ItemData)stack.func_77973_b();
            this.data.extractData(item.addData(stack, this.data.getDataAmount(type), type), type, EnumFacing.UP, true);
        }
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(10 + id)));
        }
    }

    private boolean meetsArtifactReq(DimensionProperties properties) {
        if (properties.getRequiredArtifacts().isEmpty()) {
            return true;
        }
        LinkedList<ItemStack> list = new LinkedList<ItemStack>(properties.getRequiredArtifacts());
        for (int i = 4; i <= 8; ++i) {
            ItemStack stack2 = this.func_70301_a(i);
            if (stack2.func_190926_b()) continue;
            list.removeIf(stackInList -> stackInList.func_77973_b().equals(stack2.func_77973_b()) && stackInList.func_77952_i() == stack2.func_77952_i() && ItemStack.func_77970_a((ItemStack)stackInList, (ItemStack)stack2) && stack2.func_190916_E() >= stackInList.func_190916_E());
        }
        return list.isEmpty();
    }

    public boolean itemListContainsRequiredArtifacts(List<ItemStack> items, DimensionProperties properties) {
        if (properties.getRequiredArtifacts().isEmpty()) {
            return true;
        }
        LinkedList<ItemStack> list = new LinkedList<ItemStack>(properties.getRequiredArtifacts());
        boolean hasArtifacts = true;
        for (ItemStack item : items) {
            boolean foundArtifact = false;
            for (ItemStack item2 : list) {
                if (item.func_77973_b() != item2.func_77973_b() || item.func_77952_i() != item2.func_77952_i() || !ItemStack.func_77970_a((ItemStack)item, (ItemStack)item2) || item.func_190916_E() < item2.func_190916_E()) continue;
                foundArtifact = true;
            }
            hasArtifacts = foundArtifact;
        }
        return hasArtifacts;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.progress != -1) {
            ++this.progress;
            if (this.progress >= 1000) {
                ItemStack stack;
                SpaceStationObject spaceStationObject = this.getSpaceObject();
                if (Math.abs(this.field_145850_b.field_73012_v.nextInt()) % ARConfiguration.getCurrentConfig().planetDiscoveryChance == 0 && spaceStationObject != null && !(stack = this.func_70301_a(3)).func_190926_b() && stack.func_77973_b() instanceof ItemPlanetIdentificationChip) {
                    DimensionProperties props;
                    int id;
                    int n;
                    ItemPlanetIdentificationChip item = (ItemPlanetIdentificationChip)stack.func_77973_b();
                    LinkedList<Integer> unknownPlanets = new LinkedList<Integer>();
                    Integer[] integerArray = DimensionManager.getInstance().getLoadedDimensions();
                    int n2 = integerArray.length;
                    for (n = 0; n < n2; ++n) {
                        id = integerArray[n];
                        props = DimensionManager.getInstance().getDimensionProperties(id);
                        if (this.isPlanetKnown(props) || props.getRequiredArtifacts().isEmpty() || !this.meetsArtifactReq(props)) continue;
                        unknownPlanets.add(id);
                    }
                    if (unknownPlanets.isEmpty()) {
                        integerArray = DimensionManager.getInstance().getLoadedDimensions();
                        n2 = integerArray.length;
                        for (n = 0; n < n2; ++n) {
                            id = integerArray[n];
                            props = DimensionManager.getInstance().getDimensionProperties(id);
                            if (this.isPlanetKnown(props) || !props.getRequiredArtifacts().isEmpty()) continue;
                            unknownPlanets.add(id);
                        }
                    }
                    if (!unknownPlanets.isEmpty()) {
                        int newId = (int)(this.field_145850_b.field_73012_v.nextFloat() * (float)unknownPlanets.size());
                        newId = (Integer)unknownPlanets.get(newId);
                        item.setDimensionId(stack, newId);
                        spaceStationObject.discoverPlanet(newId);
                    }
                }
                this.data.extractData(100, DataStorage.DataType.COMPOSITION, EnumFacing.UP, true);
                this.data.extractData(100, DataStorage.DataType.DISTANCE, EnumFacing.UP, true);
                this.data.extractData(100, DataStorage.DataType.MASS, EnumFacing.UP, true);
                this.progress = -1;
            }
        }
    }

    @Override
    public boolean isPlanetKnown(IDimensionProperties properties) {
        SpaceStationObject spaceStationObject = this.getSpaceObject();
        if (spaceStationObject != null) {
            return spaceStationObject.isPlanetKnown(properties);
        }
        return false;
    }

    @Override
    public boolean isStarKnown(StellarBody body) {
        SpaceStationObject spaceStationObject = this.getSpaceObject();
        if (spaceStationObject != null) {
            return spaceStationObject.isStarKnown(body);
        }
        return false;
    }
}

