/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.energy;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerProducer;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.MultiBattery;

public class TileBlackHoleGenerator
extends TileMultiPowerProducer
implements ITickable {
    static final Object[][][] structure = new Object[][][]{{{null, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, null}}, {{null, Character.valueOf('c'), null}, {Character.valueOf('*'), LibVulpesBlocks.blockAdvStructureBlock, Character.valueOf('*')}, {null, Character.valueOf('*'), null}}, {{null, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, null}}, {{null, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, null}}, {{null, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, null}}};
    private int powerMadeLastTick;
    private int prevPowerMadeLastTick;
    private ModuleText textModule = new ModuleText(40, 20, LibVulpes.proxy.getLocalizedString("msg.microwaverec.notgenerating"), 0x2B2B2B);
    private boolean initialCheck = false;
    private long last_usage;

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List modules = super.getModules(ID, player);
        modules.add(this.textModule);
        return modules;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(0.0, 2000.0, 0.0).func_72317_d(0.0, 1000.0, 0.0);
    }

    public boolean shouldHideBlock(World world, BlockPos pos, IBlockState tile) {
        return world.func_180495_p(pos).func_177230_c() == AdvancedRocketryBlocks.blockBlackHoleGenerator;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        List blocks = super.getAllowableWildCardBlocks();
        blocks.addAll(TileMultiBlock.getMapping((char)'I'));
        blocks.add(new BlockMeta(LibVulpesBlocks.blockAdvStructureBlock));
        blocks.addAll(TileMultiBlock.getMapping((char)'p'));
        return blocks;
    }

    public String getMachineName() {
        return AdvancedRocketryBlocks.blockBlackHoleGenerator.func_149732_F();
    }

    public int getPowerMadeLastTick() {
        return this.powerMadeLastTick;
    }

    public void onInventoryUpdated() {
        super.onInventoryUpdated();
        this.attemptFire();
    }

    @Nonnull
    private ItemStack consumeItem() {
        for (IInventory i : this.getItemInPorts()) {
            for (int slot = 0; slot < i.func_70302_i_(); ++slot) {
                ItemStack stack = i.func_70301_a(slot);
                if (stack.func_190926_b()) continue;
                return i.func_70298_a(slot, 1);
            }
        }
        return ItemStack.field_190927_a;
    }

    private int getTimeFromStack(@Nonnull ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> i : ARConfiguration.getCurrentConfig().blackHoleGeneratorBlocks.entrySet()) {
            if (i.getKey().func_77973_b() != stack.func_77973_b() || i.getKey().func_77952_i() != stack.func_77952_i()) continue;
            return i.getValue();
        }
        return ARConfiguration.getCurrentConfig().defaultItemTimeBlackHole;
    }

    private void attemptFire() {
        ItemStack stack;
        if (this.enabled && this.isAroundBlackHole() && this.last_usage <= this.field_145850_b.func_82737_E() && !this.isEnergyFull() && !(stack = this.consumeItem()).func_190926_b()) {
            this.last_usage = this.field_145850_b.func_82737_E() + (long)this.getTimeFromStack(stack);
        }
    }

    private boolean isEnergyFull() {
        MultiBattery battery = this.getBatteries();
        return battery.getMaxEnergyStored() == battery.getUniversalEnergyStored();
    }

    public boolean isProducingPower() {
        return this.powerMadeLastTick > 0;
    }

    private boolean isAroundBlackHole() {
        ISpaceObject spaceObject;
        if (this.field_145850_b.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId && (spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) != null) {
            DimensionProperties properties = (DimensionProperties)spaceObject.getProperties().getParentProperties();
            return properties != null && properties.isStar() && properties.getStarData().isBlackHole();
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.initialCheck && !this.field_145850_b.field_72995_K) {
            this.completeStructure = this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
            this.onInventoryUpdated();
            this.initialCheck = true;
        }
        if (!this.isComplete()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.isAroundBlackHole()) {
            this.attemptFire();
            float energyReceived = this.last_usage > this.field_145850_b.func_82737_E() ? 500.0f : 0.0f;
            this.powerMadeLastTick = (int)(energyReceived * ARConfiguration.getCurrentConfig().blackHolePowerMultiplier);
            if (this.powerMadeLastTick != this.prevPowerMadeLastTick) {
                this.prevPowerMadeLastTick = this.powerMadeLastTick;
                PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 1), (int)this.field_145850_b.field_73011_w.getDimension(), (BlockPos)this.field_174879_c, (double)128.0);
            }
            this.producePower(this.powerMadeLastTick);
        }
        if (this.field_145850_b.field_72995_K) {
            this.textModule.setText(LibVulpes.proxy.getLocalizedString("msg.microwaverec.generating") + ": " + this.powerMadeLastTick + " " + LibVulpes.proxy.getLocalizedString("msg.powerunit.rfpertick") + "\n\nStatus: " + (this.isAroundBlackHole() ? "ready" : "No black hole"));
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("canRender", this.canRender);
        nbt.func_74768_a("amtPwr", this.powerMadeLastTick);
        this.writeNetworkData(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.canRender = nbt.func_74767_n("canRender");
        this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        this.readNetworkData(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("canRender", this.canRender);
        nbt.func_74768_a("amtPwr", this.powerMadeLastTick);
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        this.canRender = nbt.func_74767_n("canRender");
        this.readNetworkData(nbt);
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 1) {
            out.writeInt(this.powerMadeLastTick);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
        if (packetId == 1) {
            nbt.func_74768_a("amtPwr", in.readInt());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        super.useNetworkData(player, side, id, nbt);
        if (id == 1) {
            this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }
}

