/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.tileentitys;

import com.troblecodings.core.NBTWrapper;
import com.troblecodings.linkableapi.ILinkableTile;
import com.troblecodings.signals.blocks.SignalBox;
import com.troblecodings.signals.core.TrainNumber;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxTileEntity;
import com.troblecodings.signals.tileentitys.SyncableTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TrainNumberTileEntity
extends SyncableTileEntity
implements ILinkableTile {
    private static final String LINKED_SIGNALBOX = "linkedSignalBox";
    private BlockPos linkedSignalBox = null;
    private Point point = new Point();
    private TrainNumber number = TrainNumber.DEFAULT;

    @Override
    public void loadWrapper(NBTWrapper wrapper) {
        this.point.read(wrapper);
        this.number = TrainNumber.of(wrapper);
        this.linkedSignalBox = wrapper.getBlockPos(LINKED_SIGNALBOX);
    }

    @Override
    public void saveWrapper(NBTWrapper wrapper) {
        this.point.write(wrapper);
        this.number.writeTag(wrapper);
        if (this.linkedSignalBox != null) {
            wrapper.putBlockPos(LINKED_SIGNALBOX, this.linkedSignalBox);
        }
    }

    public void updateTrainNumberManually() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateTrainNumberViaRedstone();
        this.number = TrainNumber.DEFAULT;
    }

    public void updateTrainNumberViaRedstone() {
        if (this.field_145850_b.field_72995_K || this.number == TrainNumber.DEFAULT) {
            return;
        }
        this.loadChunkAndGetTile(SignalBoxTileEntity.class, this.field_145850_b, this.linkedSignalBox, (tile, _u) -> tile.getSignalBoxGrid().updateTrainNumber(this.point, this.number));
    }

    @Override
    public boolean link(BlockPos pos, NBTTagCompound tag) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("opensignals", tag.func_74779_i(pos.toString())));
        if (block instanceof SignalBox) {
            this.linkedSignalBox = pos;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLink() {
        return this.linkedSignalBox != null;
    }

    @Override
    public boolean unlink() {
        this.linkedSignalBox = null;
        return true;
    }

    public Point getCurrentPoint() {
        return this.point;
    }

    public BlockPos getLinkedSignalBox() {
        return this.linkedSignalBox;
    }

    public TrainNumber getTrainNumber() {
        return this.number;
    }

    public void setNewTrainNumber(TrainNumber number) {
        this.number = number;
    }

    public void setNewPoint(Point point) {
        this.point = point;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }
}

