/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.init;

import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.blocks.BasicBlock;
import com.troblecodings.signals.blocks.CombinedRedstoneInput;
import com.troblecodings.signals.blocks.GhostBlock;
import com.troblecodings.signals.blocks.PathwayRequester;
import com.troblecodings.signals.blocks.Post;
import com.troblecodings.signals.blocks.RedstoneIO;
import com.troblecodings.signals.blocks.RedstoneInput;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.blocks.SignalBox;
import com.troblecodings.signals.blocks.SignalController;
import com.troblecodings.signals.blocks.TrainNumberBlock;
import com.troblecodings.signals.core.SignalLoader;
import com.troblecodings.signals.init.OSItems;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

public final class OSBlocks {
    public static final SignalController HV_SIGNAL_CONTROLLER = new SignalController();
    public static final Post POST = new Post();
    public static final GhostBlock GHOST_BLOCK = new GhostBlock();
    public static final SignalBox SIGNAL_BOX = new SignalBox();
    public static final RedstoneInput REDSTONE_IN = new RedstoneInput();
    public static final RedstoneIO REDSTONE_OUT = new RedstoneIO();
    public static final CombinedRedstoneInput COMBI_REDSTONE_INPUT = new CombinedRedstoneInput();
    public static final PathwayRequester PATHWAY_REQUESTER = new PathwayRequester();
    public static final TrainNumberBlock TRAIN_NUMBER_BLOCK = new TrainNumberBlock();
    public static final List<BasicBlock> BLOCKS_TO_REGISTER = new ArrayList<BasicBlock>();

    private OSBlocks() {
    }

    public static void init() {
        Field[] fields;
        BasicBlock.prepare();
        for (Field field : fields = OSBlocks.class.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers)) continue;
            String name = field.getName().toLowerCase().replace("_", "");
            try {
                Object object = field.get(null);
                if (!(object instanceof BasicBlock)) continue;
                OSBlocks.loadBlock((BasicBlock)((Object)object), name);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
        OSItems.init();
        SignalLoader.loadAllSignals();
    }

    public static void loadBlock(BasicBlock block, String pName) {
        if (BLOCKS_TO_REGISTER.contains((Object)block)) {
            return;
        }
        String name = pName.toLowerCase().trim();
        ResourceLocation location = new ResourceLocation("opensignals", name);
        block.setRegistryName(location);
        block.func_149663_c(name);
        BLOCKS_TO_REGISTER.add(block);
        if (block instanceof ITileEntityProvider && block.func_149716_u()) {
            BasicBlock provider = block;
            try {
                Class<?> tileclass = provider.func_149915_a(null, 0).getClass();
                if (TileEntity.func_190559_a(tileclass) == null) {
                    TileEntity.func_190560_a((String)tileclass.getSimpleName().toLowerCase(), tileclass);
                }
            }
            catch (NullPointerException ex) {
                OpenSignalsMain.getLogger().trace("All tileentity provide need to call back a default entity if the world is null!", (Throwable)ex);
            }
        }
        if (block instanceof Signal) {
            if (Signal.SIGNALS.containsKey(name)) {
                throw new IllegalArgumentException("A Signal with the name '" + name + "' alredy exists!");
            }
            Signal.SIGNALS.put(name, (Signal)block);
        }
    }

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        BLOCKS_TO_REGISTER.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @SubscribeEvent
    public static void registerItem(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        BLOCKS_TO_REGISTER.forEach(block -> {
            if (block instanceof GhostBlock || block instanceof Signal) {
                return;
            }
            registry.register(new ItemBlock((Block)block).setRegistryName(block.getRegistryName()));
        });
    }
}

