/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.handler;

import com.troblecodings.core.NBTWrapper;
import com.troblecodings.signals.blocks.BasicBlock;
import com.troblecodings.signals.blocks.RedstoneIO;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.core.ChunkLoadable;
import com.troblecodings.signals.core.LinkedPositions;
import com.troblecodings.signals.core.LinkingUpdates;
import com.troblecodings.signals.core.PathGetter;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.core.SubsidiaryState;
import com.troblecodings.signals.enums.EnumGuiMode;
import com.troblecodings.signals.enums.LinkType;
import com.troblecodings.signals.init.OSBlocks;
import com.troblecodings.signals.signalbox.ModeSet;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxGrid;
import com.troblecodings.signals.signalbox.SignalBoxNode;
import com.troblecodings.signals.signalbox.SignalBoxPathway;
import com.troblecodings.signals.signalbox.SignalBoxTileEntity;
import com.troblecodings.signals.signalbox.entrys.PathEntryType;
import com.troblecodings.signals.signalbox.entrys.PathOptionEntry;
import com.troblecodings.signals.tileentitys.RedstoneIOTileEntity;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class SignalBoxHandler {
    private static final Map<StateInfo, SignalBoxGrid> ALL_GRIDS = new HashMap<StateInfo, SignalBoxGrid>();
    private static final Map<StateInfo, LinkedPositions> ALL_LINKED_POS = new HashMap<StateInfo, LinkedPositions>();
    private static final Map<StateInfo, LinkingUpdates> POS_UPDATES = new HashMap<StateInfo, LinkingUpdates>();
    private static final Map<StateInfo, Boolean> OUTPUT_UPDATES = new HashMap<StateInfo, Boolean>();
    private static final String LINKING_UPDATE = "linkingUpdates";
    private static final String OUTPUT_UPDATE = "ouputUpdates";
    private static final String BOOL_STATE = "boolState";

    private SignalBoxHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putGrid(StateInfo info, SignalBoxGrid grid) {
        Map<StateInfo, SignalBoxGrid> map = ALL_GRIDS;
        synchronized (map) {
            ALL_GRIDS.put(info, grid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignalBoxGrid getGrid(StateInfo info) {
        Map<StateInfo, SignalBoxGrid> map = ALL_GRIDS;
        synchronized (map) {
            return ALL_GRIDS.get(info);
        }
    }

    public static boolean requesetInterSignalBoxPathway(StateInfo startBox, Point start, Point end) {
        if (startBox.worldNullOrClientSide()) {
            return false;
        }
        AtomicBoolean returnBoolean = new AtomicBoolean(true);
        ChunkLoadable chunkLoader = new ChunkLoadable();
        chunkLoader.loadChunkAndGetTile(SignalBoxTileEntity.class, startBox.world, startBox.pos, (startTile, _u) -> {
            SignalBoxGrid startGrid = startTile.getSignalBoxGrid();
            SignalBoxNode endNode = startGrid.getNode(end);
            PathOptionEntry outConnectionEntry = null;
            for (Rotation rot : Rotation.values()) {
                Optional<PathOptionEntry> entry = endNode.getOption(new ModeSet(EnumGuiMode.OUT_CONNECTION, rot));
                if (!entry.isPresent()) continue;
                outConnectionEntry = entry.get();
                break;
            }
            if (outConnectionEntry == null) {
                returnBoolean.set(false);
                return;
            }
            Optional<BlockPos> otherPos = outConnectionEntry.getEntry(PathEntryType.SIGNALBOX);
            Optional<Point> otherStartPoint = outConnectionEntry.getEntry(PathEntryType.POINT);
            if (!otherPos.isPresent() || !otherStartPoint.isPresent()) {
                returnBoolean.set(false);
                return;
            }
            chunkLoader.loadChunkAndGetTile(SignalBoxTileEntity.class, startBox.world, otherPos.get(), (endTile, _u2) -> {
                SignalBoxGrid endGrid = endTile.getSignalBoxGrid();
                SignalBoxNode otherStartNode = endGrid.getNode((Point)otherStartPoint.get());
                if (otherStartNode == null) {
                    returnBoolean.set(false);
                    return;
                }
                PathOptionEntry inConnectionEntry = null;
                for (Rotation rot : Rotation.values()) {
                    Optional<PathOptionEntry> entry = otherStartNode.getOption(new ModeSet(EnumGuiMode.IN_CONNECTION, rot));
                    if (!entry.isPresent()) continue;
                    inConnectionEntry = entry.get();
                    break;
                }
                if (inConnectionEntry == null) {
                    returnBoolean.set(false);
                    return;
                }
                Optional<Point> otherEndPoint = inConnectionEntry.getEntry(PathEntryType.POINT);
                if (!otherEndPoint.isPresent()) {
                    returnBoolean.set(false);
                    return;
                }
                boolean startRequeset = startGrid.requestWay(start, end);
                boolean endRequeset = endGrid.requestWay((Point)otherStartPoint.get(), otherEndPoint.get());
                if (!startRequeset || !endRequeset) {
                    if (startRequeset) {
                        startGrid.resetPathway(start);
                    }
                    if (endRequeset) {
                        endGrid.resetPathway((Point)otherStartPoint.get());
                    }
                    returnBoolean.set(false);
                    return;
                }
                SignalBoxPathway startPath = startGrid.getPathwayByLastPoint(end);
                SignalBoxPathway endPath = endGrid.getPathwayByLastPoint(otherEndPoint.get());
                startPath.setOtherPathwayToBlock(endPath);
                endPath.setOtherPathwayToReset(startPath);
            });
        });
        return returnBoolean.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTileNBT(StateInfo identifier, NBTWrapper wrapper) {
        LinkedPositions holder;
        if (identifier.worldNullOrClientSide()) {
            return;
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            holder = ALL_LINKED_POS.get(identifier);
        }
        if (holder == null) {
            return;
        }
        holder.write(wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readTileNBT(StateInfo identifier, NBTWrapper wrapper) {
        LinkedPositions holder;
        if (identifier.worldNullOrClientSide()) {
            return;
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            holder = ALL_LINKED_POS.computeIfAbsent(identifier, _u -> new LinkedPositions(identifier.pos));
        }
        holder.read(wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTileEmpty(StateInfo identifier) {
        LinkedPositions holder;
        if (identifier.worldNullOrClientSide()) {
            return true;
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            holder = ALL_LINKED_POS.get(identifier);
        }
        if (holder == null) {
            return true;
        }
        return holder.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean linkPosToSignalBox(StateInfo identifier, BlockPos linkPos, BasicBlock block, LinkType type) {
        LinkedPositions holder;
        if (identifier.worldNullOrClientSide()) {
            return false;
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            holder = ALL_LINKED_POS.computeIfAbsent(identifier, _u -> new LinkedPositions(identifier.pos));
        }
        boolean linked = holder.addLinkedPos(linkPos, type);
        if (!linked) {
            return false;
        }
        if (block instanceof Signal) {
            holder.addSignal(linkPos, (Signal)block, identifier.world);
        }
        if (block == OSBlocks.REDSTONE_IN || block == OSBlocks.REDSTONE_OUT || block == OSBlocks.COMBI_REDSTONE_INPUT) {
            SignalBoxHandler.linkTileToPos(identifier, linkPos);
        }
        return linked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void relinkAllRedstoneIOs(StateInfo identifier) {
        LinkedPositions holder;
        if (identifier.worldNullOrClientSide()) {
            return;
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            holder = ALL_LINKED_POS.get(identifier);
        }
        if (holder == null) {
            return;
        }
        holder.getAllRedstoneIOs().forEach(pos -> SignalBoxHandler.linkTileToPos(identifier, pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<BlockPos, List<SubsidiaryState>> getPossibleSubsidiaries(StateInfo identifier) {
        LinkedPositions holder;
        if (identifier.world.field_72995_K) {
            return new HashMap<BlockPos, List<SubsidiaryState>>();
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            holder = ALL_LINKED_POS.get(identifier);
        }
        if (holder == null) {
            return new HashMap<BlockPos, List<SubsidiaryState>>();
        }
        return holder.getValidSubsidiariesForPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Signal getSignal(StateInfo identifier, BlockPos signalPos) {
        LinkedPositions signals;
        if (identifier.worldNullOrClientSide()) {
            return null;
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            signals = ALL_LINKED_POS.get(identifier);
        }
        if (signals == null) {
            return null;
        }
        return signals.getSignal(signalPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlinkPosFromSignalBox(StateInfo identifier, BlockPos pos) {
        LinkedPositions holder;
        if (identifier.worldNullOrClientSide()) {
            return;
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            holder = ALL_LINKED_POS.get(identifier);
        }
        if (holder == null) {
            return;
        }
        holder.removeLinkedPos(pos, identifier.world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<BlockPos, LinkType> getAllLinkedPos(StateInfo identifier) {
        LinkedPositions holder;
        if (identifier.worldNullOrClientSide()) {
            return new HashMap<BlockPos, LinkType>();
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            holder = ALL_LINKED_POS.get(identifier);
        }
        if (holder == null) {
            return new HashMap<BlockPos, LinkType>();
        }
        return holder.getAllLinkedPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPosRemove(StateInfo identifier) {
        if (identifier.worldNullOrClientSide()) {
            return;
        }
        Map<StateInfo, Object> map = ALL_LINKED_POS;
        synchronized (map) {
            ALL_LINKED_POS.forEach((pos, holder) -> {
                if (pos.world.equals(identifier.world)) {
                    holder.removeLinkedPos(identifier.pos, identifier.world);
                }
            });
        }
        map = POS_UPDATES;
        synchronized (map) {
            POS_UPDATES.remove(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlinkAll(StateInfo identifier) {
        LinkedPositions allPos;
        if (identifier.worldNullOrClientSide()) {
            return;
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            allPos = ALL_LINKED_POS.get(identifier);
        }
        if (allPos == null) {
            return;
        }
        allPos.unlink(identifier.pos, identifier.world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlinkTileFromPos(StateInfo identifier, BlockPos posToUnlink) {
        LinkingUpdates update;
        if (identifier.worldNullOrClientSide() || SignalBoxHandler.tryDirectUnlink(identifier, posToUnlink)) {
            return;
        }
        Map<StateInfo, LinkingUpdates> map = POS_UPDATES;
        synchronized (map) {
            update = POS_UPDATES.computeIfAbsent(new StateInfo(identifier.world, posToUnlink), _u -> new LinkingUpdates());
        }
        update.addPosToUnlink(posToUnlink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void linkTileToPos(StateInfo identifier, BlockPos posToLink) {
        LinkingUpdates update;
        if (identifier.worldNullOrClientSide() || SignalBoxHandler.tryDirectLink(identifier, posToLink)) {
            return;
        }
        Map<StateInfo, LinkingUpdates> map = POS_UPDATES;
        synchronized (map) {
            update = POS_UPDATES.computeIfAbsent(new StateInfo(identifier.world, posToLink), _u -> new LinkingUpdates());
        }
        update.addPosToLink(posToLink);
    }

    private static boolean tryDirectLink(StateInfo identifier, BlockPos posToLink) {
        if (identifier.worldNullOrClientSide()) {
            return false;
        }
        TileEntity entity = identifier.world.func_175625_s(posToLink);
        if (entity != null && entity instanceof RedstoneIOTileEntity) {
            ((RedstoneIOTileEntity)entity).link(identifier.pos);
            return true;
        }
        return false;
    }

    private static boolean tryDirectUnlink(StateInfo identifier, BlockPos posToUnlink) {
        if (identifier.worldNullOrClientSide()) {
            return false;
        }
        TileEntity entity = identifier.world.func_175625_s(posToUnlink);
        if (entity != null && entity instanceof RedstoneIOTileEntity) {
            ((RedstoneIOTileEntity)entity).unlink(identifier.pos);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSignalBox(StateInfo identifier) {
        if (identifier.worldNullOrClientSide()) {
            return;
        }
        Map<StateInfo, Object> map = ALL_GRIDS;
        synchronized (map) {
            ALL_GRIDS.remove(identifier);
        }
        map = ALL_LINKED_POS;
        synchronized (map) {
            ALL_LINKED_POS.remove(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkingUpdates getPosUpdates(StateInfo identifier) {
        if (identifier.worldNullOrClientSide()) {
            return null;
        }
        Map<StateInfo, LinkingUpdates> map = POS_UPDATES;
        synchronized (map) {
            return POS_UPDATES.remove(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRedstoneOutput(StateInfo identifier, boolean state) {
        if (identifier.worldNullOrClientSide()) {
            return;
        }
        IBlockState blockState = identifier.world.func_180495_p(identifier.pos);
        if (blockState != null && blockState.func_177230_c() == OSBlocks.REDSTONE_OUT) {
            blockState = blockState.func_177226_a((IProperty)RedstoneIO.POWER, (Comparable)Boolean.valueOf(state));
            identifier.world.func_175656_a(identifier.pos, blockState);
            return;
        }
        Map<StateInfo, Boolean> map = OUTPUT_UPDATES;
        synchronized (map) {
            OUTPUT_UPDATES.put(identifier, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsOutputUpdates(StateInfo identifier) {
        if (identifier.worldNullOrClientSide()) {
            return false;
        }
        Map<StateInfo, Boolean> map = OUTPUT_UPDATES;
        synchronized (map) {
            return OUTPUT_UPDATES.containsKey(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getNewOutputState(StateInfo identifier) {
        if (identifier.worldNullOrClientSide()) {
            return false;
        }
        Map<StateInfo, Boolean> map = OUTPUT_UPDATES;
        synchronized (map) {
            return OUTPUT_UPDATES.remove(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSignals(StateInfo identifier) {
        LinkedPositions holder;
        if (identifier.worldNullOrClientSide()) {
            return;
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            holder = ALL_LINKED_POS.get(identifier);
        }
        if (holder == null) {
            return;
        }
        holder.loadSignals(identifier.world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadSignals(StateInfo identifier) {
        LinkedPositions holder;
        if (identifier.worldNullOrClientSide()) {
            return;
        }
        Map<StateInfo, LinkedPositions> map = ALL_LINKED_POS;
        synchronized (map) {
            holder = ALL_LINKED_POS.get(identifier);
        }
        if (holder == null) {
            return;
        }
        holder.unloadSignals(identifier.world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        NBTWrapper wrapper = new NBTWrapper();
        ArrayList<NBTWrapper> wrapperList = new ArrayList<NBTWrapper>();
        String levelName = ((WorldServer)world).func_73046_m().func_71270_I() + "_" + ((WorldServer)world).field_73011_w.func_186058_p().func_186065_b().replace(":", "_");
        Map<StateInfo, Object> map = POS_UPDATES;
        synchronized (map) {
            POS_UPDATES.forEach((pos, update) -> {
                if (!levelName.equals(((WorldServer)world).func_73046_m().func_71270_I() + "_" + ((WorldServer)world).field_73011_w.func_186058_p().func_186065_b().replace(":", "_"))) {
                    return;
                }
                NBTWrapper posWrapper = NBTWrapper.getBlockPosWrapper(pos.pos);
                update.writeNBT(posWrapper);
                wrapperList.add(posWrapper);
            });
        }
        wrapper.putList(LINKING_UPDATE, wrapperList);
        wrapperList.clear();
        map = OUTPUT_UPDATES;
        synchronized (map) {
            OUTPUT_UPDATES.forEach((pos, state) -> {
                if (!levelName.equals(((WorldServer)world).func_73046_m().func_71270_I() + "_" + ((WorldServer)world).field_73011_w.func_186058_p().func_186065_b().replace(":", "_"))) {
                    return;
                }
                NBTWrapper posWrapper = NBTWrapper.getBlockPosWrapper(pos.pos);
                posWrapper.putBoolean(BOOL_STATE, (boolean)state);
                wrapperList.add(posWrapper);
            });
        }
        wrapper.putList(OUTPUT_UPDATE, wrapperList);
        try {
            File file;
            Path path = PathGetter.getNewPathForFiles(world, "signalboxhandlerfiles");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            if ((file = path.toFile()).exists()) {
                file.delete();
            }
            file.createNewFile();
            CompressedStreamTools.func_74795_b((NBTTagCompound)wrapper.tag, (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        SignalBoxHandler.migrateFilesToNewDirectory(world);
        try {
            Path newPath = PathGetter.getNewPathForFiles(world, "signalboxhandlerfiles");
            if (!Files.exists(newPath, new LinkOption[0])) {
                return;
            }
            NBTWrapper wrapper = new NBTWrapper(CompressedStreamTools.func_74797_a((File)newPath.toFile()));
            wrapper.getList(LINKING_UPDATE).forEach(tag -> {
                LinkingUpdates updates = new LinkingUpdates();
                updates.readNBT((NBTWrapper)tag);
                Map<StateInfo, LinkingUpdates> map = POS_UPDATES;
                synchronized (map) {
                    StateInfo identifier = new StateInfo(world, tag.getAsPos());
                    POS_UPDATES.put(identifier, updates);
                }
            });
            wrapper.getList(OUTPUT_UPDATE).forEach(tag -> {
                Map<StateInfo, Boolean> map = OUTPUT_UPDATES;
                synchronized (map) {
                    OUTPUT_UPDATES.put(new StateInfo(world, tag.getAsPos()), tag.getBoolean(BOOL_STATE));
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migrateFilesToNewDirectory(World world) {
        Path oldPath = Paths.get("osfiles/signalboxhandler/", ((WorldServer)world).func_73046_m().func_70005_c_().replace("/", "") + "_" + ((WorldServer)world).field_73011_w.func_186058_p().func_186065_b().replace(":", "_"));
        if (!Files.exists(oldPath, new LinkOption[0])) {
            return;
        }
        Path newPath = PathGetter.getNewPathForFiles(world, "signalboxhandlerfiles");
        try {
            Files.createDirectories(newPath, new FileAttribute[0]);
            Files.copy(oldPath, newPath, StandardCopyOption.REPLACE_EXISTING);
            if (Files.isDirectory(oldPath, new LinkOption[0])) {
                Files.list(oldPath).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Files.delete(oldPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

