/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.handler;

import com.troblecodings.signals.handler.SignalStateFile;
import com.troblecodings.signals.handler.SignalStatePos;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import net.minecraft.util.math.BlockPos;

public class NameHandlerFile
extends SignalStateFile {
    public NameHandlerFile(Path path) {
        super(path);
    }

    public synchronized SignalStatePos createState(BlockPos pos, String name) {
        if (name.length() > 128) {
            throw new IllegalArgumentException("Max Name length is 128!");
        }
        return this.create(pos, name.getBytes());
    }

    public synchronized void writeString(SignalStatePos pos, String name) {
        if (name.length() > 128) {
            throw new IllegalArgumentException("Max Name length is 128!");
        }
        this.write(pos, ByteBuffer.allocate(256).put(name.getBytes()));
    }

    public synchronized String getString(BlockPos pos) {
        return this.getString(this.find(pos));
    }

    public synchronized String getString(SignalStatePos pos) {
        if (pos == null) {
            return "";
        }
        return new String(this.read(pos).array()).trim();
    }
}

