/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.core.I18Wrapper;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.DrawUtil;
import com.troblecodings.guilib.ecs.GuiBase;
import com.troblecodings.guilib.ecs.GuiElements;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.guilib.ecs.entitys.UIBox;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.render.UILabel;
import com.troblecodings.guilib.ecs.interfaces.IIntegerable;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.guis.PathwayRequesterContainer;
import com.troblecodings.signals.signalbox.Point;
import net.minecraft.entity.player.EntityPlayer;

public class PathwayRequesterGui
extends GuiBase {
    private final PathwayRequesterContainer container;
    private final EntityPlayer player;

    public PathwayRequesterGui(GuiInfo info) {
        super(info);
        this.container = (PathwayRequesterContainer)info.base;
        this.player = info.player;
        this.entity.clear();
        this.entity.add(new UILabel("Not connected"));
    }

    private void initOwn() {
        UILabel infoLabel;
        UIEntity infoLabelEntity;
        this.entity.clear();
        this.entity.add(new UIBox(UIBox.VBOX, 5));
        UIEntity inner = new UIEntity();
        inner.setWidth(200.0);
        inner.setInheritHeight(true);
        inner.setX(70.0);
        inner.add(new UIBox(UIBox.VBOX, 5));
        inner.add(GuiElements.createSpacerV(10));
        UIEntity label = GuiElements.createLabel(I18Wrapper.format("tile.pathwayrequester", new Object[0]), 7764128);
        label.setScaleX(1.5f);
        label.setScaleY(1.5f);
        label.setX(-6.0);
        inner.add(label);
        inner.add(GuiElements.createSpacerV(20));
        IIntegerable<String> start = DrawUtil.SizeIntegerables.of("StartPoint", this.container.validStarts.size(), e -> {
            if (e == -1) {
                return "Disabled";
            }
            return this.container.validStarts.get(e).toShortString();
        });
        IIntegerable<String> end = DrawUtil.SizeIntegerables.of("EndPoint", this.container.validEnds.size(), e -> {
            if (e == -1) {
                return "Disabled";
            }
            return this.container.validEnds.get(e).toShortString();
        });
        if (!this.container.validStarts.isEmpty()) {
            inner.add(GuiElements.createEnumElement(new DrawUtil.DisableIntegerable<String>(start), e -> {
                if (e == -1) {
                    this.container.start = new Point(-1, -1);
                    return;
                }
                this.container.start = this.container.validStarts.get(e);
            }, this.container.start != null ? (this.container.start.equals(new Point(-1, -1)) ? -1 : this.container.validStarts.indexOf(this.container.start)) : -1));
        } else {
            infoLabelEntity = new UIEntity();
            infoLabelEntity.setInheritWidth(true);
            infoLabelEntity.setHeight(20.0);
            infoLabel = new UILabel("No start to set!");
            infoLabel.setCenterY(false);
            infoLabelEntity.add(infoLabel);
            inner.add(infoLabelEntity);
        }
        if (!this.container.validEnds.isEmpty()) {
            inner.add(GuiElements.createEnumElement(new DrawUtil.DisableIntegerable<String>(end), e -> {
                if (e == -1) {
                    this.container.end = new Point(-1, -1);
                    return;
                }
                this.container.end = this.container.validEnds.get(e);
            }, this.container.end != null ? (this.container.end.equals(new Point(-1, -1)) ? -1 : this.container.validEnds.indexOf(this.container.end)) : -1));
        } else {
            infoLabelEntity = new UIEntity();
            infoLabelEntity.setInheritWidth(true);
            infoLabelEntity.setHeight(20.0);
            infoLabel = new UILabel("No end to set!");
            infoLabel.setCenterY(false);
            infoLabelEntity.add(infoLabel);
            inner.add(infoLabelEntity);
        }
        if (!this.container.validStarts.isEmpty() && !this.container.validEnds.isEmpty()) {
            inner.add(GuiElements.createButton(I18Wrapper.format("btn.save", new Object[0]), e -> this.sendToServer()));
        } else {
            infoLabelEntity = new UIEntity();
            infoLabelEntity.setInheritWidth(true);
            infoLabelEntity.setHeight(20.0);
            infoLabel = new UILabel("Nothing to save!");
            infoLabel.setCenterY(false);
            infoLabelEntity.add(infoLabel);
            inner.add(infoLabelEntity);
        }
        inner.add(GuiElements.createSpacerV(5));
        UILabel linkedlabel = new UILabel("Linked SignalBox: " + (this.container.linkedPos == null ? "Not linked!" : this.container.linkedPos.toString()));
        linkedlabel.setCenterY(false);
        UIEntity posLabel = new UIEntity();
        posLabel.setHeight(20.0);
        posLabel.setInheritWidth(true);
        posLabel.add(linkedlabel);
        inner.add(posLabel);
        this.entity.add(inner);
    }

    @Override
    public void updateFromContainer() {
        this.initOwn();
    }

    private void sendToServer() {
        WriteBuffer buffer = new WriteBuffer();
        this.container.start.writeNetwork(buffer);
        this.container.end.writeNetwork(buffer);
        OpenSignalsMain.network.sendTo(this.player, buffer);
    }

    @Override
    public ContainerBase getNewGuiContainer(GuiInfo info) {
        return new PathwayRequesterContainer(info);
    }
}

