/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.core;

import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.signals.signalbox.ModeSet;
import com.troblecodings.signals.signalbox.Point;
import java.util.Objects;

public class ModeIdentifier {
    public final Point point;
    public final ModeSet mode;

    public ModeIdentifier(Point point, ModeSet mode) {
        this.point = point;
        this.mode = mode;
    }

    public void writeNetwork(WriteBuffer buffer) {
        this.point.writeNetwork(buffer);
        this.mode.writeNetwork(buffer);
    }

    public static ModeIdentifier of(ReadBuffer buffer) {
        return new ModeIdentifier(Point.of(buffer), ModeSet.of(buffer));
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.point);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModeIdentifier other = (ModeIdentifier)obj;
        return Objects.equals(this.mode, other.mode) && Objects.equals(this.point, other.point);
    }

    public String toString() {
        return "ModeIdentifier [point=" + this.point + ",mode=" + this.mode + "]";
    }
}

