/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.core;

import com.google.common.collect.ImmutableMap;
import com.troblecodings.core.NBTWrapper;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.contentpacks.SubsidiarySignalParser;
import com.troblecodings.signals.core.LoadHolder;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.core.StateLoadHolder;
import com.troblecodings.signals.core.SubsidiaryState;
import com.troblecodings.signals.enums.LinkType;
import com.troblecodings.signals.handler.SignalBoxHandler;
import com.troblecodings.signals.handler.SignalStateHandler;
import com.troblecodings.signals.handler.SignalStateInfo;
import com.troblecodings.signals.properties.PredicatedPropertyBase;
import com.troblecodings.signals.signalbox.config.ResetInfo;
import com.troblecodings.signals.signalbox.config.SignalConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LinkedPositions {
    private static final String LINKED_POS_LIST = "linkedPos";
    private static final String LINKED_SIGNALS = "linkedSignals";
    private static final String SIGNAL_NAME = "signalName";
    private static final String ALL_POS = "allPos";
    private final BlockPos thisPos;
    private final Map<BlockPos, Signal> signals = new HashMap<BlockPos, Signal>();
    private final Map<BlockPos, LinkType> linkedBlocks = new HashMap<BlockPos, LinkType>();
    private final Map<BlockPos, List<SubsidiaryState>> possibleSubsidiaries = new HashMap<BlockPos, List<SubsidiaryState>>();

    public LinkedPositions(BlockPos thisPos) {
        this.thisPos = thisPos;
    }

    public void addSignal(BlockPos signalPos, Signal signal, World world) {
        if (world.field_72995_K) {
            return;
        }
        this.signals.put(signalPos, signal);
        SignalStateInfo info = new SignalStateInfo(world, signalPos, signal);
        SignalStateHandler.runTaskWhenSignalLoaded(info, (stateInfo, properties, _u) -> this.loadPossibleSubsidiaires(stateInfo, properties));
        SignalConfig.reset(new ResetInfo(info, false));
    }

    public Signal getSignal(BlockPos pos) {
        return this.signals.get(pos);
    }

    public boolean addLinkedPos(BlockPos pos, LinkType type) {
        if (this.linkedBlocks.containsKey(pos)) {
            return false;
        }
        this.linkedBlocks.put(pos, type);
        return true;
    }

    public void removeLinkedPos(BlockPos pos, World world) {
        if (world.field_72995_K) {
            return;
        }
        this.linkedBlocks.remove(pos);
        this.signals.remove(pos);
        this.possibleSubsidiaries.remove(pos);
    }

    public boolean isEmpty() {
        return this.linkedBlocks.isEmpty();
    }

    public Map<BlockPos, LinkType> getAllLinkedPos() {
        return ImmutableMap.copyOf(this.linkedBlocks);
    }

    public void unlink(BlockPos tilePos, World world) {
        if (world.field_72995_K) {
            return;
        }
        ArrayList<StateLoadHolder> signalsToUnload = new ArrayList<StateLoadHolder>();
        this.signals.forEach((pos, signal) -> {
            SignalStateInfo info = new SignalStateInfo(world, (BlockPos)pos, (Signal)((Object)signal));
            SignalConfig.reset(new ResetInfo(info, false));
            signalsToUnload.add(new StateLoadHolder(info, new LoadHolder<StateInfo>(new StateInfo(world, tilePos))));
        });
        this.linkedBlocks.entrySet().stream().filter(entry -> !((LinkType)entry.getValue()).equals(LinkType.SIGNAL)).forEach(entry -> SignalBoxHandler.unlinkTileFromPos(new StateInfo(world, tilePos), (BlockPos)entry.getKey()));
        this.linkedBlocks.clear();
        this.signals.clear();
        this.possibleSubsidiaries.clear();
        SignalStateHandler.unloadSignals(signalsToUnload);
    }

    public void write(NBTWrapper wrapper) {
        NBTWrapper posWrapper = new NBTWrapper();
        posWrapper.putList(LINKED_POS_LIST, this.linkedBlocks.entrySet().stream().filter(entry -> !((LinkType)entry.getValue()).equals(LinkType.SIGNAL)).map(entry -> {
            NBTWrapper item = NBTWrapper.getBlockPosWrapper((BlockPos)entry.getKey());
            ((LinkType)entry.getValue()).write(item);
            return item;
        })::iterator);
        posWrapper.putList(LINKED_SIGNALS, this.signals.entrySet().stream().map(entry -> {
            NBTWrapper signal = NBTWrapper.getBlockPosWrapper((BlockPos)entry.getKey());
            signal.putString(SIGNAL_NAME, ((Signal)((Object)((Object)entry.getValue()))).getSignalTypeName());
            return signal;
        })::iterator);
        wrapper.putWrapper(ALL_POS, posWrapper);
    }

    public void read(NBTWrapper wrapper) {
        if (!wrapper.contains(ALL_POS)) {
            return;
        }
        NBTWrapper posWrapper = wrapper.getWrapper(ALL_POS);
        this.linkedBlocks.clear();
        this.signals.clear();
        posWrapper.getList(LINKED_POS_LIST).forEach(nbt -> this.linkedBlocks.put(nbt.getAsPos(), LinkType.of(nbt)));
        posWrapper.getList(LINKED_SIGNALS).forEach(nbt -> {
            BlockPos pos = nbt.getAsPos();
            Signal signal = Signal.SIGNALS.get(nbt.getString(SIGNAL_NAME));
            this.signals.put(pos, signal);
        });
    }

    public void loadSignals(World world) {
        if (world.field_72995_K) {
            return;
        }
        ArrayList<StateLoadHolder> signalInfos = new ArrayList<StateLoadHolder>();
        this.signals.forEach((pos, signal) -> {
            SignalStateInfo info = new SignalStateInfo(world, (BlockPos)pos, (Signal)((Object)signal));
            signalInfos.add(new StateLoadHolder(info, new LoadHolder<StateInfo>(new StateInfo(world, this.thisPos))));
            SignalStateHandler.runTaskWhenSignalLoaded(info, (stateInfo, properties, _u) -> this.loadPossibleSubsidiaires(stateInfo, properties));
        });
        SignalStateHandler.loadSignals(signalInfos);
    }

    public void unloadSignals(World world) {
        if (world.field_72995_K) {
            return;
        }
        ArrayList<StateLoadHolder> signalInfos = new ArrayList<StateLoadHolder>();
        this.signals.forEach((pos, signal) -> signalInfos.add(new StateLoadHolder(new SignalStateInfo(world, (BlockPos)pos, (Signal)((Object)signal)), new LoadHolder<StateInfo>(new StateInfo(world, this.thisPos)))));
        SignalStateHandler.unloadSignals(signalInfos);
    }

    private void loadPossibleSubsidiaires(SignalStateInfo info, Map<SEProperty, String> properties) {
        Map<SubsidiaryState, PredicatedPropertyBase.ConfigProperty> subsidiaries = SubsidiarySignalParser.SUBSIDIARY_SIGNALS.get((Object)info.signal);
        if (subsidiaries == null) {
            return;
        }
        ArrayList validStates = new ArrayList();
        subsidiaries.forEach((state, config) -> {
            for (SEProperty property : ((Map)config.state).keySet()) {
                if (!properties.containsKey(property)) continue;
                validStates.add(state);
                break;
            }
        });
        this.possibleSubsidiaries.put(info.pos, validStates);
    }

    public List<BlockPos> getAllRedstoneIOs() {
        return this.linkedBlocks.entrySet().stream().filter(entry -> !((LinkType)entry.getValue()).equals(LinkType.SIGNAL)).map(entry -> (BlockPos)entry.getKey()).collect(Collectors.toList());
    }

    public Map<BlockPos, List<SubsidiaryState>> getValidSubsidiariesForPos() {
        return ImmutableMap.copyOf(this.possibleSubsidiaries);
    }

    public String toString() {
        return "LinkedPos [AllSignals = " + this.signals + ", AllLinkedPos = " + this.linkedBlocks + "]";
    }
}

