/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys.render;

import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIScissor
extends UIComponent {
    private int x;
    private int y;
    private int width;
    private int height;

    @Override
    public void draw(DrawInfo info) {
        info.scissorOn(this.x, this.y, this.width, this.height);
    }

    @Override
    public void exitDraw(DrawInfo info) {
        info.scissorOff();
    }

    @Override
    public void updateEvent(UIEntity.UpdateEvent lastUpdateEvent) {
        this.height = (int)(this.parent.getHeight() * lastUpdateEvent.scaleFactor);
        this.width = (int)(this.parent.getWidth() * lastUpdateEvent.scaleFactor);
        if (this.height < 0) {
            this.height = 0;
        }
        if (this.width < 0) {
            this.width = 0;
        }
        this.x = (int)(this.parent.getLevelX() * lastUpdateEvent.scaleFactor / (double)lastUpdateEvent.guiScale);
        this.y = (int)((double)(lastUpdateEvent.height - (int)this.parent.getLevelY() - (int)this.parent.getHeight()) * lastUpdateEvent.scaleFactor);
    }

    @Override
    public void update() {
        UIEntity.UpdateEvent lastUpdateEvent = this.parent.getLastUpdateEvent();
        if (lastUpdateEvent == null) {
            return;
        }
        this.updateEvent(lastUpdateEvent);
    }
}

