/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs;

import com.troblecodings.guilib.ecs.DrawUtil;
import com.troblecodings.guilib.ecs.GuiBase;
import com.troblecodings.guilib.ecs.entitys.UIBox;
import com.troblecodings.guilib.ecs.entitys.UICheckBox;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.UIEnumerable;
import com.troblecodings.guilib.ecs.entitys.UIScrollBox;
import com.troblecodings.guilib.ecs.entitys.UITextInput;
import com.troblecodings.guilib.ecs.entitys.input.UIClickable;
import com.troblecodings.guilib.ecs.entitys.input.UIOnUpdate;
import com.troblecodings.guilib.ecs.entitys.input.UIScroll;
import com.troblecodings.guilib.ecs.entitys.input.UIScrollBar;
import com.troblecodings.guilib.ecs.entitys.render.UIBorder;
import com.troblecodings.guilib.ecs.entitys.render.UIButton;
import com.troblecodings.guilib.ecs.entitys.render.UIColor;
import com.troblecodings.guilib.ecs.entitys.render.UILabel;
import com.troblecodings.guilib.ecs.entitys.render.UIScissor;
import com.troblecodings.guilib.ecs.entitys.render.UITexture;
import com.troblecodings.guilib.ecs.entitys.render.UIToolTip;
import com.troblecodings.guilib.ecs.entitys.transform.UIIndependentTranslate;
import com.troblecodings.guilib.ecs.interfaces.IBoxMode;
import com.troblecodings.guilib.ecs.interfaces.IIntegerable;
import com.troblecodings.guilib.ecs.interfaces.UIPagable;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class GuiElements {
    public static final Consumer<UIEntity> NULL_CONSUMER = e -> {};

    private GuiElements() {
    }

    public static UIEntity createSpacerH(int space) {
        UIEntity spacer = new UIEntity();
        spacer.setInheritHeight(true);
        spacer.setWidth(space);
        return spacer;
    }

    public static UIEntity createSpacerV(int space) {
        UIEntity spacer = new UIEntity();
        spacer.setInheritWidth(true);
        spacer.setHeight(space);
        return spacer;
    }

    public static UIEntity createInputElement(IIntegerable<?> property, IntConsumer consumer) {
        UIEntity middle = new UIEntity();
        middle.setHeight(20.0);
        middle.setInheritWidth(true);
        UITextInput textInput = new UITextInput(property.getLocalizedName());
        textInput.setOnTextUpdate(str -> consumer.accept(str.length()));
        middle.add(textInput);
        middle.add(new UIToolTip(property.getDescriptionForName()));
        return middle;
    }

    public static UIEntity createBoolElement(IIntegerable<?> property, IntConsumer consumer) {
        return GuiElements.createBoolElement(property, consumer, 0);
    }

    public static UIEntity createBoolElement(IIntegerable<?> property, IntConsumer consumer, int defaultValue) {
        UIEntity middle = new UIEntity();
        middle.setHeight(20.0);
        middle.setInheritWidth(true);
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        UICheckBox middleButton = new UICheckBox(property.getName());
        middleButton.setChecked(defaultValue != 0);
        UIClickable clickable = new UIClickable(e -> {
            middleButton.setChecked(!middleButton.isChecked());
            consumer.accept(middleButton.isChecked() ? 1 : 0);
            handler.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        });
        middleButton.setOnChange(consumer);
        middleButton.setText(property.getLocalizedName());
        middle.add(middleButton);
        middle.add(clickable);
        middle.add(new UIToolTip(property.getDescriptionForName()));
        return middle;
    }

    public static UIEntity createEnumElement(IIntegerable<?> property, IntConsumer consumer) {
        return GuiElements.createEnumElement(property, consumer, 0);
    }

    public static UIEntity createEnumElement(IIntegerable<?> property, IntConsumer consumer, int value) {
        return GuiElements.createEnumElement(new UIEnumerable(property.count(), property.getName()), property, consumer, value);
    }

    public static UIEntity createEnumElement(UIEnumerable enumerable, IIntegerable<?> property, IntConsumer consumer) {
        Minecraft mc = Minecraft.func_71410_x();
        return GuiElements.createEnumElement(enumerable, property, consumer, property.getMaxWidth(mc.field_71466_p) + 8, 0);
    }

    public static UIEntity createEnumElement(UIEnumerable enumerable, IIntegerable<?> property, IntConsumer consumer, int value) {
        Minecraft mc = Minecraft.func_71410_x();
        return GuiElements.createEnumElement(enumerable, property, consumer, property.getMaxWidth(mc.field_71466_p) + 8, value);
    }

    public static UIEntity createScrollBar(UIScrollBox scrollbox, int insets, UIScroll scroll) {
        IBoxMode mode = scrollbox.getMode();
        IBoxMode orthogonal = mode.getOrthogonal();
        UIEntity entity = new UIEntity();
        UIEntity button = new UIEntity();
        mode.inheritsBounds(entity, true);
        mode.inheritsBounds(button, true);
        button.setHeight(insets);
        button.setWidth(insets);
        orthogonal.setBounds(entity, insets);
        entity.add(button);
        button.add(new UITexture(GuiBase.CREATIVE_TAB, 0.90625, 0.0, 0.953125, 0.05859375));
        entity.add(new UIColor(-12763843));
        entity.add(new UIScrollBar(scrollbox, insets, input -> {
            int position = (int)Math.floor((double)(mode.getBounds(entity) - insets) * input);
            mode.setPos(button, position);
            int positionOfList = (int)Math.floor((double)(scrollbox.getWholeBounds() - mode.getBounds(scrollbox.getParent())) * input);
            mode.setPos(scrollbox.getParent(), -positionOfList);
            scrollbox.getParent().update();
        }, scroll));
        return entity;
    }

    public static UIEntity createSelectionScreen(UIEnumerable enumerable, IIntegerable<?> property) {
        return GuiElements.createScreen(searchPanel -> {
            UIEntity searchBar = new UIEntity();
            searchBar.setInheritWidth(true);
            searchBar.setHeight(20.0);
            UITextInput input = new UITextInput("");
            searchBar.add(input);
            searchPanel.add(searchBar);
            UIEntity listWithScroll = new UIEntity();
            listWithScroll.setInheritHeight(true);
            listWithScroll.setInheritWidth(true);
            listWithScroll.add(new UIBox(UIBox.HBOX, 2));
            listWithScroll.add(new UIScissor());
            listWithScroll.add(new UIBorder(-16711681));
            searchPanel.add(listWithScroll);
            UIEntity list = new UIEntity();
            listWithScroll.add(list);
            list.setInheritHeight(true);
            list.setInheritWidth(true);
            UIScrollBox scrollbox = new UIScrollBox(UIBox.VBOX, 2);
            list.add(scrollbox);
            HashMap<String, UIEntity> nameToUIEntity = new HashMap<String, UIEntity>();
            if (property instanceof DrawUtil.DisableIntegerable) {
                list.add(GuiElements.createButton(property.getNamedObj(-1), e -> {
                    enumerable.setIndex(-1);
                    e.getLastUpdateEvent().base.pop();
                }));
            }
            for (int i = 0; i < property.count(); ++i) {
                int index = i;
                String name = property.getNamedObj(i);
                UIEntity button = GuiElements.createButton(name, e -> {
                    enumerable.setIndex(index);
                    e.getLastUpdateEvent().base.pop();
                });
                nameToUIEntity.put(name.toLowerCase(), button);
                list.add(button);
            }
            UIScroll scroll = new UIScroll();
            UIEntity scrollBar = GuiElements.createScrollBar(scrollbox, 10, scroll);
            scrollbox.setConsumer(size -> {
                if ((double)size > list.getHeight()) {
                    listWithScroll.add(scroll);
                    listWithScroll.add(scrollBar);
                } else {
                    listWithScroll.remove(scrollBar);
                    listWithScroll.remove(scroll);
                }
            });
            input.setOnTextUpdate(string -> nameToUIEntity.forEach((name, entity) -> {
                if (!name.contains(string.toLowerCase())) {
                    list.remove((UIEntity)entity);
                } else {
                    list.add((UIEntity)entity);
                }
            }));
        });
    }

    public static UIEntity createScreen(Consumer<UIEntity> entityConsumer) {
        int insets = 40;
        UIEntity entity = new UIEntity();
        entity.add(new UIBox(UIBox.HBOX, 0));
        UIEntity inner = new UIEntity();
        entity.add(GuiElements.createSpacerH(40));
        entity.add(inner);
        entity.add(GuiElements.createSpacerH(40));
        inner.add(new UIBox(UIBox.VBOX, 0));
        inner.setInheritHeight(true);
        inner.setInheritWidth(true);
        UIEntity searchPanel = new UIEntity();
        searchPanel.add(new UIBox(UIBox.VBOX, 3));
        searchPanel.setInheritHeight(true);
        searchPanel.setInheritWidth(true);
        inner.add(GuiElements.createSpacerV(40));
        inner.add(searchPanel);
        inner.add(GuiElements.createSpacerV(40));
        searchPanel.add(new UIColor(0x6F000000, 5));
        entityConsumer.accept(searchPanel);
        entity.add(new UIIndependentTranslate(0.0, 0.0, 1.0));
        return entity;
    }

    public static UIEntity createEnumElement(UIEnumerable enumerable, IIntegerable<?> property, IntConsumer consumer, int minWidth, int value) {
        if (property instanceof DrawUtil.DisableIntegerable) {
            enumerable.setMin(-1);
        }
        enumerable.setIndex(value);
        UIEntity middle = new UIEntity();
        UIEntity hbox = new UIEntity();
        middle.setInheritWidth(true);
        middle.setInheritHeight(true);
        UIButton middleButton = new UIButton("");
        IntConsumer acceptOr = in -> {
            if (in >= property.count()) {
                return;
            }
            middleButton.setText(property.getNamedObj(in));
        };
        enumerable.setOnChange(consumer.andThen(acceptOr));
        middle.add(new UIOnUpdate(() -> acceptOr.accept(enumerable.getIndex())));
        middle.add(middleButton);
        middle.add(enumerable);
        middle.add(new UIClickable(entity -> middle.getLastUpdateEvent().base.push(GuiElements.createSelectionScreen(enumerable, property))));
        acceptOr.accept(value);
        hbox.add(new UIBox(UIBox.VBOX, 1));
        String desc = property.getDescriptionForName();
        if (desc != null) {
            hbox.add(new UIToolTip(desc));
        }
        hbox.add(middle);
        hbox.setInheritWidth(true);
        hbox.setHeight(22.0);
        return hbox;
    }

    public static UIEntity createPageSelect(UIPagable vbox) {
        UIEntity hbox = new UIEntity();
        UIEntity middle = new UIEntity();
        middle.setInheritWidth(true);
        middle.setInheritHeight(true);
        UIButton leftButton = new UIButton("<");
        UIButton rightButton = new UIButton(">");
        UILabel middleButton = new UILabel("DDDD");
        middle.add(middleButton);
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        UIEnumerable enumerable = new UIEnumerable(0, "pageselect");
        IntConsumer acceptOn = in -> {
            middleButton.setText("Page: " + (in + 1) + "/" + vbox.getMaxPages());
            rightButton.setEnabled(true);
            leftButton.setEnabled(true);
            if (in <= enumerable.getMin()) {
                leftButton.setEnabled(false);
            }
            if (in >= enumerable.getMax() - 1) {
                rightButton.setEnabled(false);
            }
            vbox.setPage(in);
        };
        enumerable.setOnChange(acceptOn);
        vbox.getParent().add(new UIOnUpdate(() -> {
            int max = vbox.getMaxPages();
            if (max < 1) {
                return;
            }
            hbox.setVisible(max != 1);
            enumerable.setMax(max);
            int current = enumerable.getIndex();
            enumerable.setIndex(current >= max ? max - 1 : current);
            acceptOn.accept(enumerable.getIndex());
        }));
        middle.add(enumerable);
        UIEntity left = new UIEntity();
        left.setWidth(20.0);
        left.setHeight(20.0);
        UIClickable leftclickable = new UIClickable(e -> {
            int min;
            int id = enumerable.getIndex();
            if (id <= (min = enumerable.getMin())) {
                return;
            }
            enumerable.setIndex(id - 1);
            handler.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        });
        left.add(leftButton);
        left.add(leftclickable);
        UIEntity right = new UIEntity();
        right.setWidth(20.0);
        right.setHeight(20.0);
        UIClickable rightclickable = new UIClickable(e -> {
            int max;
            int id = enumerable.getIndex();
            if (id >= (max = enumerable.getMax() - 1)) {
                return;
            }
            enumerable.setIndex(id + 1);
            handler.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        });
        right.add(rightButton);
        right.add(rightclickable);
        hbox.add(new UIBox(UIBox.HBOX, 1));
        hbox.add(left);
        hbox.add(middle);
        hbox.add(right);
        hbox.setInheritWidth(true);
        hbox.setHeight(20.0);
        return hbox;
    }

    public static UIEntity createButton(String name) {
        return GuiElements.createButton(name, NULL_CONSUMER);
    }

    public static UIEntity createButton(String name, Consumer<UIEntity> consumer) {
        UIEntity entity = GuiElements.createButton(name, 0, consumer);
        entity.setInheritWidth(true);
        return entity;
    }

    public static UIEntity createButton(String name, int width) {
        return GuiElements.createButton(name, width, NULL_CONSUMER);
    }

    public static UIEntity createButton(String name, int width, Consumer<UIEntity> consumer) {
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        UIEntity settingsEnt = new UIEntity();
        settingsEnt.setHeight(20.0);
        settingsEnt.setWidth(width);
        settingsEnt.add(new UIButton(name));
        settingsEnt.add(new UIClickable(consumer.andThen(e -> handler.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f)))));
        return settingsEnt;
    }

    public static UIEntity createLabel(String name, int color, int background) {
        UIEntity entity = new UIEntity();
        entity.add(new UIColor(background));
        UILabel label = new UILabel(name);
        entity.setHeight(15.0);
        entity.setInheritWidth(true);
        label.setTextColor(color);
        entity.add(label);
        return entity;
    }

    public static UIEntity createLabel(String name, int color, float scale) {
        UIEntity entity = new UIEntity();
        UILabel label = new UILabel(name);
        entity.setHeight(15.0f * scale);
        entity.setInheritWidth(true);
        entity.setScaleX(scale);
        entity.setScaleY(scale);
        label.setTextColor(color);
        entity.add(label);
        return entity;
    }

    public static UIEntity createLabel(String name, int color) {
        return GuiElements.createLabel(name, color, 1);
    }

    public static UIEntity createLabel(String name, float scale) {
        return GuiElements.createLabel(name, 0x404040, scale);
    }

    public static UIEntity createLabel(String name) {
        return GuiElements.createLabel(name, 1);
    }
}

