/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.world.mobs.data.types;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import thut.core.common.world.mobs.data.types.Data_Base;

public class Data_UUID
extends Data_Base<UUID> {
    UUID value = null;

    @Override
    public void set(UUID value) {
        if (value == null) {
            if (this.value == null) {
                return;
            }
            this.value = null;
            return;
        }
        if (value.equals(this.value)) {
            return;
        }
        this.value = value;
    }

    @Override
    public UUID get() {
        return this.value;
    }

    @Override
    public void write(ByteBuf buf) {
        super.write(buf);
        long lsb = -1L;
        long msb = -1L;
        if (this.value != null) {
            lsb = this.value.getLeastSignificantBits();
            msb = this.value.getMostSignificantBits();
        }
        buf.writeLong(lsb);
        buf.writeLong(msb);
    }

    @Override
    public void read(ByteBuf buf) {
        super.read(buf);
        long lsb = buf.readLong();
        long msb = buf.readLong();
        this.value = lsb != -1L && msb != -1L ? new UUID(msb, lsb) : null;
    }
}

