/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.core.common.commands.CommandTools;
import thut.core.common.config.ConfigBase;
import thut.core.common.config.Configure;

public class CommandConfig
extends CommandBase {
    private final String editperm;
    private List<String> aliases;
    final ConfigBase config;
    ArrayList<String> fields = Lists.newArrayList();
    HashMap<String, Field> fieldMap = Maps.newHashMap();

    public CommandConfig(String name, ConfigBase config) {
        this.aliases = new ArrayList<String>();
        this.aliases.add(name);
        this.config = config;
        this.populateFields();
        this.editperm = "command." + name + ".edit";
        PermissionAPI.registerNode((String)this.editperm, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)("Can the player use " + name + " to edit config values?"));
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            CommandTools.sendBadArgumentsTryTab(sender);
            return;
        }
        boolean check = args.length <= 1;
        Field field = this.fieldMap.get(args[0]);
        if (field == null) {
            CommandTools.sendBadArgumentsTryTab(sender);
            return;
        }
        try {
            String text = "";
            Object o = field.get((Object)this.config);
            text = o instanceof String[] ? text + Arrays.toString((Object[])o) : (o instanceof int[] ? text + Arrays.toString((int[])o) : text + o);
            ITextComponent mess = CommandTools.makeTranslatedMessage("pokecube.command.settings.check", "gold", args[0], text);
            if (check) {
                sender.func_145747_a(mess);
                return;
            }
            if (!CommandTools.isOp(sender, this.editperm)) {
                CommandTools.sendNoPermissions(sender);
                return;
            }
            try {
                String val = args[1];
                if (val.equals("!set")) {
                    this.handleSet(sender, args, o, field);
                    return;
                }
                if (val.equals("!add")) {
                    this.handleAdd(sender, args, o, field);
                    return;
                }
                if (val.equals("!remove")) {
                    this.handleRemove(sender, args, o, field);
                    return;
                }
                if (args.length > 2) {
                    for (int i = 2; i < args.length; ++i) {
                        val = val + " " + args[i];
                    }
                }
                this.config.updateField(field, val);
            }
            catch (Exception e) {
                mess = CommandTools.makeTranslatedMessage("pokecube.command.settings.invalid", "gold", args[0]);
                sender.func_145747_a(mess);
                CommandTools.sendError(sender, text);
                return;
            }
            text = "";
            o = field.get((Object)this.config);
            text = o instanceof String[] ? text + Arrays.toString((Object[])o) : (o instanceof int[] ? text + Arrays.toString((int[])o) : text + o);
            mess = CommandTools.makeTranslatedMessage("pokecube.command.settings.set", "gold", args[0], text);
            sender.func_145747_a(mess);
            return;
        }
        catch (Exception e) {
            CommandTools.sendError(sender, "pokecube.command.settings.error");
            return;
        }
    }

    private void handleSet(ICommandSender sender, String[] args, Object o, Field field) throws Exception {
        int num = CommandConfig.func_175755_a((String)args[2]);
        String value = args[3];
        for (int i = 4; i < args.length; ++i) {
            value = value + " " + args[i];
        }
        String oldValue = "";
        Object toSet = null;
        if (o instanceof String[]) {
            oldValue = ((String[])o)[num];
            ((String[])o)[num] = value;
            toSet = ((String[])o).clone();
        } else if (o instanceof int[]) {
            oldValue = ((int[])o)[num] + "";
            ((int[])o)[num] = CommandConfig.func_175755_a((String)value);
            toSet = ((int[])o).clone();
        } else {
            throw new CommandException("This can only by done for arrays.", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Changed index " + num + " from " + oldValue + " to " + value));
        this.config.updateField(field, toSet);
    }

    private void handleAdd(ICommandSender sender, String[] args, Object o, Field field) throws Exception {
        String value = args[2];
        for (int i = 3; i < args.length; ++i) {
            value = value + " " + args[i];
        }
        Object[] toSet = null;
        if (o instanceof String[]) {
            int len = ((String[])o).length;
            toSet = Arrays.copyOf((String[])o, len + 1);
            toSet[len] = value;
        } else if (o instanceof int[]) {
            int len = ((int[])o).length;
            toSet = Arrays.copyOf((int[])o, len + 1);
            ((int[])toSet)[len] = CommandConfig.func_175755_a((String)value);
        } else {
            throw new CommandException("This can only by done for arrays.", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Added " + value + " to " + field.getName()));
        this.config.updateField(field, toSet);
    }

    private void handleRemove(ICommandSender sender, String[] args, Object o, Field field) throws Exception {
        String value = args[2];
        for (int i = 3; i < args.length; ++i) {
            value = value + " " + args[i];
        }
        Object[] toSet = null;
        if (o instanceof String[]) {
            Object[] arr = (String[])o;
            ArrayList values = Lists.newArrayList((Object[])arr);
            int index = values.indexOf(value);
            if (index != -1) {
                values.remove(index);
            }
            toSet = values.toArray(new String[values.size()]);
        } else if (o instanceof int[]) {
            int[] arr = (int[])o;
            int arg = CommandConfig.func_175755_a((String)value);
            ArrayList values = Lists.newArrayList();
            for (int i = 0; i < arr.length; ++i) {
                values.add(arr[i]);
            }
            int index = values.indexOf(arg);
            if (index != -1) {
                values.remove(index);
            }
            arr = new int[values.size()];
            toSet = arr;
            for (int i = 0; i < values.size(); ++i) {
                arr[i] = (Integer)values.get(i);
            }
        } else {
            throw new CommandException("This can only by done for arrays.", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Removed " + value + " from " + field.getName()));
        this.config.updateField(field, toSet);
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public String func_71517_b() {
        return this.aliases.get(0);
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.aliases.get(0) + "<option name> <optional:newvalue>";
    }

    public int func_82362_a() {
        return 4;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        List<String> ret = new ArrayList<String>();
        if (args.length == 1) {
            String text = args[0];
            for (String name : this.fields) {
                if (!name.contains(text)) continue;
                ret.add(name);
            }
            Collections.sort(ret, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            ret = CommandConfig.func_175762_a((String[])args, ret);
        }
        return ret;
    }

    private void populateFields() {
        Class<?> me = ((Object)((Object)this.config)).getClass();
        for (Field f : me.getDeclaredFields()) {
            Configure c = f.getAnnotation(Configure.class);
            if (c == null) continue;
            f.setAccessible(true);
            this.fields.add(f.getName());
            this.fieldMap.put(f.getName(), f);
        }
    }
}

