/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.handlers.ConfigHandler;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.items.ItemBase;
import com.tiviacz.travelersbackpack.tileentity.TileEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTravelersBackpack
extends ItemBase {
    public ItemTravelersBackpack(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < Reference.BACKPACK_NAMES.length; ++i) {
                ItemStack stack = new ItemStack((Item)this, 1, i);
                items.add((Object)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int meta = stack.func_77960_j();
        String name = Reference.BACKPACK_NAMES[meta];
        String localizedName = I18n.func_135052_a((String)("backpack." + name.toLowerCase() + ".name"), (Object[])new Object[0]);
        if (ConfigHandler.client.obtainTips) {
            if (meta == 2) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"backpack.obtain.bat", (Object[])new Object[0]));
            }
            if (meta == 11) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"backpack.obtain.iron_golem", (Object[])new Object[0]));
            }
            if (meta == 24) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"backpack.obtain.electric", (Object[])new Object[0]));
            }
            if (meta == 51) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"backpack.obtain.pigman", (Object[])new Object[0]));
            }
            if (meta == 25) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"backpack.obtain.deluxe", (Object[])new Object[0]));
            }
            if (meta == 71) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"backpack.obtain.villager", (Object[])new Object[0]));
            }
        }
        tooltip.add(localizedName);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (handIn == EnumHand.MAIN_HAND && itemstack.func_77973_b() == this && !playerIn.func_70093_af()) {
            playerIn.openGui((Object)TravelersBackpack.INSTANCE, 1, worldIn, playerIn.func_180425_c().func_177958_n(), playerIn.func_180425_c().func_177956_o(), playerIn.func_180425_c().func_177952_p());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        if (hand == EnumHand.MAIN_HAND && !player.func_70093_af()) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!(itemstack = player.func_184586_b(hand)).func_190926_b() && player.func_175151_a(pos, facing, itemstack) && worldIn.func_190527_a(ModBlocks.TRAVELERS_BACKPACK, pos, false, facing, (Entity)player)) {
            int i = this.func_77647_b(itemstack.func_77960_j());
            IBlockState iblockstate1 = ModBlocks.TRAVELERS_BACKPACK.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(itemstack, player, worldIn, pos, iblockstate1)) {
                if (itemstack.func_77978_p() != null) {
                    ((TileEntityTravelersBackpack)worldIn.func_175625_s(pos)).loadAllData(itemstack.func_77978_p());
                }
                ((TileEntityTravelersBackpack)worldIn.func_175625_s(pos)).setColorFromMeta(itemstack.func_77960_j());
                iblockstate1 = worldIn.func_180495_p(pos);
                SoundType soundtype = iblockstate1.func_177230_c().getSoundType(iblockstate1, worldIn, pos, (Entity)player);
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == ModBlocks.TRAVELERS_BACKPACK) {
            ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            ModBlocks.TRAVELERS_BACKPACK.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    @Override
    public void registerModels() {
        for (int i = 0; i < Reference.BACKPACK_NAMES.length; ++i) {
            TravelersBackpack.proxy.registerItemRenderer(this, i, "inventory");
        }
    }
}

