/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile.multiblock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.block.BlockTile;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.block.multiblock.BlockMultiBlockComponentVisible;
import zmaster587.libVulpes.block.multiblock.BlockMultiblockStructure;
import zmaster587.libVulpes.tile.IMultiblock;
import zmaster587.libVulpes.tile.TilePointer;
import zmaster587.libVulpes.tile.TileSchematic;
import zmaster587.libVulpes.tile.multiblock.TilePlaceholder;
import zmaster587.libVulpes.tile.multiblock.hatch.TileFluidHatch;
import zmaster587.libVulpes.tile.multiblock.hatch.TileInputHatch;
import zmaster587.libVulpes.tile.multiblock.hatch.TileOutputHatch;
import zmaster587.libVulpes.util.IFluidHandlerInternal;
import zmaster587.libVulpes.util.Vector3F;

public class TileMultiBlock
extends TileEntity {
    protected boolean completeStructure = false;
    protected boolean canRender = false;
    protected byte timeAlive = 0;
    protected LinkedList<IInventory> itemInPorts = new LinkedList();
    protected LinkedList<IInventory> itemOutPorts = new LinkedList();
    protected LinkedList<IFluidHandlerInternal> fluidInPorts = new LinkedList();
    protected LinkedList<IFluidHandlerInternal> fluidOutPorts = new LinkedList();
    protected static HashMap<Character, List<BlockMeta>> charMapping = new HashMap();

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public static void addMapping(char character, List<BlockMeta> listToAdd) {
        if (charMapping.containsKey(Character.valueOf(character))) {
            LibVulpes.logger.warn("Overwritting Multiblock mapping of \"" + character + "\"");
        }
        charMapping.put(Character.valueOf(character), listToAdd);
    }

    public static List<BlockMeta> getMapping(char character) {
        return charMapping.get(Character.valueOf(character));
    }

    public List<IInventory> getItemInPorts() {
        for (int i = 0; i < this.itemInPorts.size(); ++i) {
            TileEntity newTile;
            if (!(this.itemInPorts.get(i) instanceof TileEntity) || !((newTile = this.field_145850_b.func_175625_s(((TileEntity)this.itemInPorts.get(i)).func_174877_v())) instanceof IInventory)) continue;
            this.itemInPorts.set(i, (IInventory)newTile);
        }
        return this.itemInPorts;
    }

    public List<IInventory> getItemOutPorts() {
        for (int i = 0; i < this.itemOutPorts.size(); ++i) {
            TileEntity newTile;
            if (!(this.itemOutPorts.get(i) instanceof TileEntity) || !((newTile = this.field_145850_b.func_175625_s(((TileEntity)this.itemOutPorts.get(i)).func_174877_v())) instanceof IInventory)) continue;
            this.itemOutPorts.set(i, (IInventory)newTile);
        }
        return this.itemOutPorts;
    }

    public boolean isComplete() {
        return this.completeStructure;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRender() {
        return this.canRender;
    }

    public String getMachineName() {
        return "";
    }

    public void setMachineRunning(boolean running) {
        this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockTile.STATE, (Comparable)Boolean.valueOf(running)), 2);
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return player.func_70011_f((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) < 64.0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("canRender", this.canRender);
        this.writeNetworkData(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("canRender", this.canRender);
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        this.canRender = nbt.func_74767_n("canRender");
        this.readNetworkData(nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.canRender = nbt.func_74767_n("canRender");
        this.readNetworkData(nbt);
    }

    public void invalidateComponent(TileEntity tile) {
        this.setComplete(false);
    }

    public void onInventoryUpdated() {
    }

    public void deconstructMultiBlock(World world, BlockPos destroyedPos, boolean blockBroken, IBlockState state) {
        this.completeStructure = false;
        this.canRender = false;
        if (this.field_174879_c.compareTo((Vec3i)destroyedPos) != 0) {
            world.func_175656_a(this.field_174879_c, world.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockTile.STATE, (Comparable)Boolean.valueOf(false)));
        }
        EnumFacing front = this.getFrontDirection(state);
        Object[][][] structure = this.getStructure();
        Vector3F<Integer> offset = this.getControllerOffset(structure);
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                for (int x = 0; x < structure[0][0].length; ++x) {
                    int globalX = this.field_174879_c.func_177958_n() + (x - (Integer)offset.x) * front.func_82599_e() - (z - (Integer)offset.z) * front.func_82601_c();
                    int globalY = this.field_174879_c.func_177956_o() - y + (Integer)offset.y;
                    int globalZ = this.field_174879_c.func_177952_p() - (x - (Integer)offset.x) * front.func_82601_c() - (z - (Integer)offset.z) * front.func_82599_e();
                    TileEntity tile = world.func_175625_s(new BlockPos(globalX, globalY, globalZ));
                    if (blockBroken && globalX == destroyedPos.func_177958_n() && globalY == destroyedPos.func_177956_o() && globalZ == destroyedPos.func_177952_p()) {
                        if (tile instanceof IMultiblock) {
                            ((IMultiblock)tile).setIncomplete();
                        }
                        tile.func_145843_s();
                        continue;
                    }
                    Block block = world.func_180495_p(new BlockPos(globalX, globalY, globalZ)).func_177230_c();
                    this.destroyBlockAt(new BlockPos(globalX, globalY, globalZ), block, tile);
                }
            }
        }
        this.resetCache();
        this.func_70296_d();
        world.func_184138_a(this.field_174879_c, world.func_180495_p(this.field_174879_c), world.func_180495_p(this.field_174879_c), 3);
    }

    protected void destroyBlockAt(BlockPos destroyedPos, Block block, TileEntity tile) {
        if (block instanceof BlockMultiblockStructure) {
            ((BlockMultiblockStructure)block).destroyStructure(this.field_145850_b, destroyedPos, this.field_145850_b.func_180495_p(destroyedPos));
        }
        if (tile instanceof TilePlaceholder && !(tile instanceof TileSchematic)) {
            TilePlaceholder placeholder = (TilePlaceholder)tile;
            placeholder.setIncomplete();
            this.field_145850_b.func_175656_a(destroyedPos, placeholder.getReplacedState());
            if (placeholder.getReplacedTileEntity() != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                placeholder.getReplacedTileEntity().func_189515_b(nbt);
                this.field_145850_b.func_175625_s(destroyedPos).func_145839_a(nbt);
            } else if (this.field_145850_b.func_175625_s(destroyedPos) != null) {
                this.field_145850_b.func_175625_s(destroyedPos).func_145843_s();
            }
        } else if (tile instanceof IMultiblock) {
            ((IMultiblock)tile).setIncomplete();
            tile.func_145843_s();
        }
    }

    public EnumFacing getFrontDirection(IBlockState state) {
        return RotatableBlock.getFront(state);
    }

    public Object[][][] getStructure() {
        return null;
    }

    public boolean attemptCompleteStructure(IBlockState state) {
        this.canRender = this.completeStructure = this.completeStructure(state);
        return this.completeStructure;
    }

    public void setComplete(boolean complete) {
        this.completeStructure = complete;
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        ArrayList<BlockMeta> list = new ArrayList<BlockMeta>();
        return list;
    }

    public void resetCache() {
        this.itemInPorts.clear();
        this.itemOutPorts.clear();
        this.fluidInPorts.clear();
        this.fluidOutPorts.clear();
    }

    protected boolean completeStructure(IBlockState state) {
        int meta;
        Block block;
        IBlockState blockState;
        TileEntity tile;
        BlockPos globalPos;
        int globalZ;
        int globalY;
        int globalX;
        int x;
        int z;
        int y;
        this.resetCache();
        Object[][][] structure = this.getStructure();
        Vector3F<Integer> offset = this.getControllerOffset(structure);
        LinkedList<BlockPos> replacableBlocks = new LinkedList<BlockPos>();
        EnumFacing front = this.getFrontDirection(state);
        LinkedList<TileEntity> tiles = new LinkedList<TileEntity>();
        for (y = 0; y < structure.length; ++y) {
            for (z = 0; z < structure[0].length; ++z) {
                for (x = 0; x < structure[0][0].length; ++x) {
                    if (structure[y][z][x] == null) continue;
                    globalX = this.field_174879_c.func_177958_n() + (x - (Integer)offset.x) * front.func_82599_e() - (z - (Integer)offset.z) * front.func_82601_c();
                    globalPos = new BlockPos(globalX, globalY = this.field_174879_c.func_177956_o() - y + (Integer)offset.y, globalZ = this.field_174879_c.func_177952_p() - (x - (Integer)offset.x) * front.func_82601_c() - (z - (Integer)offset.z) * front.func_82599_e());
                    if (!this.field_145850_b.func_175726_f(globalPos).func_177410_o()) {
                        return false;
                    }
                    tile = this.field_145850_b.func_175625_s(globalPos);
                    blockState = this.field_145850_b.func_180495_p(globalPos);
                    block = blockState.func_177230_c();
                    meta = block.func_176201_c(blockState);
                    if (block == LibVulpesBlocks.blockPhantom) {
                        return false;
                    }
                    if (tile != null) {
                        tiles.add(tile);
                    }
                    if (tile instanceof TilePointer) {
                        TileEntity masterBlock;
                        if (((IMultiblock)tile).hasMaster() && (masterBlock = ((IMultiblock)tile).getMasterBlock()) != this) {
                            if (masterBlock == null) {
                                ((IMultiblock)tile).setMasterBlock(this.field_174879_c);
                            }
                            if (((IMultiblock)tile).getMasterBlock().func_174877_v().equals((Object)this.func_174877_v())) {
                                ((IMultiblock)tile).setMasterBlock(this.func_174877_v());
                                continue;
                            }
                        } else if (((IMultiblock)tile).getMasterBlock() == this) continue;
                    }
                    if (structure[y][z][x] instanceof Character && ((Character)structure[y][z][x]).charValue() == 'c' || structure[y][z][x] instanceof Block && structure[y][z][x] == Blocks.field_150350_a && this.field_145850_b.func_175623_d(globalPos) || this.getAllowableBlocks(structure[y][z][x]).contains(new BlockMeta(block, meta))) continue;
                    if (block.func_176200_f((IBlockAccess)this.field_145850_b, globalPos) && structure[y][z][x] instanceof Block && structure[y][z][x] == Blocks.field_150350_a) {
                        replacableBlocks.add(globalPos);
                        continue;
                    }
                    LibVulpes.proxy.spawnParticle("errorBox", this.field_145850_b, globalX, globalY, globalZ, 0.0, 0.0, 0.0);
                    return false;
                }
            }
        }
        for (y = 0; y < structure.length; ++y) {
            for (z = 0; z < structure[0].length; ++z) {
                for (x = 0; x < structure[0][0].length; ++x) {
                    globalX = this.field_174879_c.func_177958_n() + (x - (Integer)offset.x) * front.func_82599_e() - (z - (Integer)offset.z) * front.func_82601_c();
                    globalY = this.field_174879_c.func_177956_o() - y + (Integer)offset.y;
                    globalZ = this.field_174879_c.func_177952_p() - (x - (Integer)offset.x) * front.func_82601_c() - (z - (Integer)offset.z) * front.func_82599_e();
                    globalPos = new BlockPos(globalX, globalY, globalZ);
                    tile = this.field_145850_b.func_175625_s(globalPos);
                    blockState = this.field_145850_b.func_180495_p(globalPos);
                    block = blockState.func_177230_c();
                    meta = block.func_176201_c(blockState);
                    if (block instanceof BlockMultiBlockComponentVisible) {
                        ((BlockMultiBlockComponentVisible)block).hideBlock(this.field_145850_b, globalPos, blockState);
                        tile = this.field_145850_b.func_175625_s(globalPos);
                        if (tile instanceof IMultiblock) {
                            ((IMultiblock)tile).setComplete(globalPos);
                        }
                    } else if (block instanceof BlockMultiblockStructure && this.shouldHideBlock(this.field_145850_b, globalPos, blockState)) {
                        ((BlockMultiblockStructure)block).hideBlock(this.field_145850_b, globalPos, blockState);
                    }
                    if (structure[y][z][x] == null || block.isAir(blockState, (IBlockAccess)this.field_145850_b, globalPos) || tile instanceof IMultiblock || tile instanceof TileMultiBlock) continue;
                    this.replaceStandardBlock(globalPos, blockState, tile);
                }
            }
        }
        for (TileEntity tile2 : tiles) {
            this.integrateTile(tile2);
        }
        for (BlockPos pos : replacableBlocks) {
            this.field_145850_b.func_175698_g(pos);
        }
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        return true;
    }

    public List<BlockMeta> getAllowableBlocks(Object input) {
        if (input instanceof Character && ((Character)input).charValue() == '*') {
            return this.getAllowableWildCardBlocks();
        }
        if (input instanceof Character && charMapping.containsKey(input)) {
            return charMapping.get(input);
        }
        if (input instanceof String) {
            NonNullList stacks = OreDictionary.getOres((String)((String)input));
            LinkedList<BlockMeta> list = new LinkedList<BlockMeta>();
            for (ItemStack stack : stacks) {
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                list.add(new BlockMeta(block, stack.func_77973_b().func_77647_b(stack.func_77952_i())));
            }
            return list;
        }
        if (input instanceof Block) {
            ArrayList<BlockMeta> list = new ArrayList<BlockMeta>();
            list.add(new BlockMeta((Block)input, -1));
            return list;
        }
        if (input instanceof BlockMeta) {
            ArrayList<BlockMeta> list = new ArrayList<BlockMeta>();
            list.add((BlockMeta)input);
            return list;
        }
        if (input instanceof Block[]) {
            ArrayList<BlockMeta> list = new ArrayList<BlockMeta>();
            for (Block b : (Block[])input) {
                list.add(new BlockMeta(b));
            }
            return list;
        }
        if (input instanceof List) {
            return (List)input;
        }
        return new ArrayList<BlockMeta>();
    }

    public boolean shouldHideBlock(World world, BlockPos pos, IBlockState tile) {
        return false;
    }

    protected void replaceStandardBlock(BlockPos newPos, IBlockState state, TileEntity tile) {
        this.field_145850_b.func_175656_a(newPos, LibVulpesBlocks.blockPlaceHolder.func_176223_P());
        TilePlaceholder newTile = (TilePlaceholder)this.field_145850_b.func_175625_s(newPos);
        newTile.setReplacedBlockState(state);
        newTile.setReplacedTileEntity(tile);
        newTile.setMasterBlock(this.field_174879_c);
    }

    protected void integrateTile(TileEntity tile) {
        if (tile instanceof IMultiblock) {
            ((IMultiblock)tile).setComplete(this.field_174879_c);
        }
        if (tile instanceof TileInputHatch) {
            this.itemInPorts.add((IInventory)tile);
        } else if (tile instanceof TileOutputHatch) {
            this.itemOutPorts.add((IInventory)tile);
        } else if (tile instanceof TileFluidHatch) {
            TileFluidHatch liquidHatch = (TileFluidHatch)tile;
            if (liquidHatch.isOutputOnly()) {
                this.fluidOutPorts.add(liquidHatch);
            } else {
                this.fluidInPorts.add(liquidHatch);
            }
        }
    }

    protected Vector3F<Integer> getControllerOffset(Object[][][] structure) {
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                for (int x = 0; x < structure[0][0].length; ++x) {
                    if (!(structure[y][z][x] instanceof Character) || ((Character)structure[y][z][x]).charValue() != 'c') continue;
                    return new Vector3F<Integer>(x, y, z);
                }
            }
        }
        return null;
    }

    protected void writeNetworkData(NBTTagCompound nbt) {
    }

    protected void readNetworkData(NBTTagCompound nbt) {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeNetworkData(nbt);
        nbt.func_74757_a("completeStructure", this.completeStructure);
        nbt.func_74757_a("canRender", this.canRender);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNetworkData(nbt);
        this.completeStructure = nbt.func_74767_n("completeStructure");
        this.canRender = nbt.func_74767_n("canRender");
    }
}

