/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.items;

import com.mojang.realmsclient.gui.ChatFormatting;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.block.BlockTile;
import zmaster587.libVulpes.block.multiblock.BlockMultiblockMachine;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.network.INetworkItem;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketItemModifcation;
import zmaster587.libVulpes.tile.TileSchematic;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TilePlaceholder;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;
import zmaster587.libVulpes.util.ZUtils;

public class ItemProjector
extends Item
implements IModularInventory,
IButtonInventory,
INetworkItem {
    private ArrayList<TileMultiBlock> machineList = new ArrayList();
    private ArrayList<BlockTile> blockList = new ArrayList();
    private ArrayList<String> descriptionList = new ArrayList();
    private static final String IDNAME = "machineId";

    public void registerMachine(TileMultiBlock multiblock, BlockTile mainBlock) {
        Object[][][] structure;
        this.machineList.add(multiblock);
        this.blockList.add(mainBlock);
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (Object[][] objects2d : structure = multiblock.getStructure()) {
            Object[][] objectArray = objects2d;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object[] objects;
                for (Object object : objects = objectArray[i]) {
                    if (!map.containsKey(object)) {
                        map.put(object, 1);
                        continue;
                    }
                    map.put(object, (Integer)map.get(object) + 1);
                }
            }
        }
        StringBuilder str = new StringBuilder(Item.func_150898_a((Block)mainBlock).func_77653_i(new ItemStack((Block)mainBlock)) + " x1\n");
        for (Map.Entry entry : map.entrySet()) {
            List<BlockMeta> blockMeta = multiblock.getAllowableBlocks(entry.getKey());
            if (blockMeta.isEmpty() || Item.func_150898_a((Block)blockMeta.get(0).getBlock()) == Items.field_190931_a || blockMeta.get(0).getBlock() == Blocks.field_150350_a) continue;
            for (BlockMeta meta : blockMeta) {
                String itemStr = Item.func_150898_a((Block)meta.getBlock()).func_77653_i(new ItemStack(meta.getBlock(), 1, (int)meta.getMeta()));
                if (itemStr.contains("tile.")) continue;
                str.append(itemStr);
                str.append(" or ");
            }
            if (str.toString().endsWith(" or ")) {
                str = new StringBuilder(str.substring(0, str.length() - 4));
            }
            str.append(" x").append(entry.getValue()).append("\n");
        }
        this.descriptionList.add(str.toString());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void mouseEvent(MouseEvent event) {
        ItemStack stack;
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af() && event.getDwheel() != 0 && !(stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && stack.func_77973_b() == this && this.getMachineId(stack) != -1) {
            if (event.getDwheel() < 0) {
                this.setYLevel(stack, this.getYLevel(stack) + 1);
            } else {
                this.setYLevel(stack, this.getYLevel(stack) - 1);
            }
            event.setCanceled(true);
            PacketHandler.sendToServer(new PacketItemModifcation(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 1));
        }
    }

    private void clearStructure(World world, TileMultiBlock tile, @Nonnull ItemStack stack) {
        int id = this.getMachineId(stack);
        EnumFacing direction = EnumFacing.func_82600_a((int)this.getDirection(stack));
        TileMultiBlock multiblock = this.machineList.get(id);
        int prevMachineId = this.getPrevMachineId(stack);
        if (prevMachineId >= 0 && prevMachineId < this.machineList.size()) {
            Object[][][] structure = this.machineList.get(prevMachineId).getStructure();
            Vector3F<Integer> basepos = this.getBasePosition(stack);
            for (int y = 0; y < structure.length; ++y) {
                for (int z = 0; z < structure[0].length; ++z) {
                    for (int x = 0; x < structure[0][0].length; ++x) {
                        int globalX = (Integer)basepos.x - x * direction.func_82599_e() + z * direction.func_82601_c();
                        int globalZ = (Integer)basepos.z + x * direction.func_82601_c() + z * direction.func_82599_e();
                        BlockPos pos = new BlockPos(globalX, (Integer)basepos.y + y, globalZ);
                        if (world.func_180495_p(pos).func_177230_c() != LibVulpesBlocks.blockPhantom) continue;
                        world.func_175698_g(pos);
                    }
                }
            }
        }
    }

    private void RebuildStructure(World world, TileMultiBlock tile, @Nonnull ItemStack stack, int posX, int posY, int posZ, EnumFacing orientation) {
        int endNumber;
        int startNumber;
        int id = this.getMachineId(stack);
        EnumFacing direction = EnumFacing.func_82600_a((int)this.getDirection(stack));
        TileMultiBlock multiblock = this.machineList.get(id);
        this.clearStructure(world, tile, stack);
        Object[][][] structure = multiblock.getStructure();
        direction = orientation;
        int y = this.getYLevel(stack);
        if (y == -1) {
            startNumber = 0;
            endNumber = structure.length;
        } else {
            startNumber = y;
            endNumber = y + 1;
        }
        for (y = startNumber; y < endNumber; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                for (int x = 0; x < structure[0][0].length; ++x) {
                    List<Object> block;
                    if (structure[y][z][x] instanceof Character && ((Character)structure[y][z][x]).charValue() == 'c') {
                        block = new ArrayList<BlockMeta>();
                        block.add(new BlockMeta(this.blockList.get(id), orientation.func_176734_d().ordinal()));
                    } else {
                        if (multiblock.getAllowableBlocks(structure[y][z][x]).isEmpty()) continue;
                        block = multiblock.getAllowableBlocks(structure[y][z][x]);
                    }
                    int globalX = posX - x * direction.func_82599_e() + z * direction.func_82601_c();
                    int globalZ = posZ + x * direction.func_82601_c() + z * direction.func_82599_e();
                    int globalY = -y + structure.length + posY - 1;
                    BlockPos pos = new BlockPos(globalX, globalY, globalZ);
                    if (!world.func_175623_d(pos) && !world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || ((BlockMeta)block.get(0)).getBlock() == Blocks.field_150350_a) continue;
                    world.func_175656_a(pos, LibVulpesBlocks.blockPhantom.func_176203_a((int)((BlockMeta)block.get(0)).getMeta()));
                    TileEntity newTile = world.func_175625_s(pos);
                    if (!(newTile instanceof TilePlaceholder)) continue;
                    ((TileSchematic)newTile).setReplacedBlock(block);
                    ((TilePlaceholder)newTile).setReplacedTileEntity(((BlockMeta)block.get(0)).getBlock().createTileEntity(world, ((BlockMeta)block.get(0)).getBlock().func_176223_P()));
                }
            }
        }
        this.setPrevMachineId(stack, id);
        this.setBasePosition(stack, posX, posY, posZ);
        this.setDirection(stack, orientation.ordinal());
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), world, -1, -1, 0);
            }
            return super.func_77659_a(world, player, hand);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos blockPos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int id = this.getMachineId(stack);
        if (!player.func_70093_af() && id != -1 && world.field_72995_K) {
            EnumFacing dir = EnumFacing.func_82600_a((int)ZUtils.getDirectionFacing(player.field_70177_z - 180.0f));
            TileMultiBlock tile = this.machineList.get(this.getMachineId(stack));
            int x = tile.getStructure()[0][0].length;
            int z = tile.getStructure()[0].length;
            int globalX = (-x * dir.func_82599_e() + z * dir.func_82601_c()) / 2;
            int globalZ = (x * dir.func_82601_c() + z * dir.func_82599_e()) / 2;
            RayTraceResult pos = Minecraft.func_71410_x().field_71476_x;
            TileEntity tile2 = world.func_175625_s(pos.func_178782_a());
            if (tile2 instanceof TileMultiBlock) {
                for (TileMultiBlock tiles : this.machineList) {
                    if (tile2.getClass() != ((Object)((Object)tiles)).getClass()) continue;
                    this.setMachineId(stack, this.machineList.indexOf((Object)tiles));
                    Object[][][] structure = tiles.getStructure();
                    HashedBlockPosition controller = this.getControllerOffset(structure);
                    dir = BlockMultiblockMachine.getFront(world.func_180495_p(tile2.func_174877_v())).func_176734_d();
                    controller.y = (short)(structure.length - controller.y);
                    globalX = -controller.x * dir.func_82599_e() + controller.z * dir.func_82601_c();
                    globalZ = controller.x * dir.func_82601_c() + controller.z * dir.func_82599_e();
                    this.setDirection(stack, dir.ordinal());
                    this.setBasePosition(stack, pos.func_178782_a().func_177958_n() - globalX, pos.func_178782_a().func_177956_o() - controller.y + 1, pos.func_178782_a().func_177952_p() - globalZ);
                    PacketHandler.sendToServer(new PacketItemModifcation(this, player, 0));
                    PacketHandler.sendToServer(new PacketItemModifcation(this, player, 2));
                    return super.onItemUseFirst(player, world, blockPos, side, hitX, hitY, hitZ, hand);
                }
            }
            if (pos.field_178784_b == EnumFacing.DOWN) {
                this.setBasePosition(stack, pos.func_178782_a().func_177958_n() - globalX, pos.func_178782_a().func_177956_o() - tile.getStructure().length, pos.func_178782_a().func_177952_p() - globalZ);
            } else {
                this.setBasePosition(stack, pos.func_178782_a().func_177958_n() - globalX, pos.func_178782_a().func_177956_o() + 1, pos.func_178782_a().func_177952_p() - globalZ);
            }
            this.setDirection(stack, dir.ordinal());
            PacketHandler.sendToServer(new PacketItemModifcation(this, player, 2));
        }
        return super.onItemUseFirst(player, world, blockPos, side, hitX, hitY, hitZ, hand);
    }

    protected HashedBlockPosition getControllerOffset(Object[][][] structure) {
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                for (int x = 0; x < structure[0][0].length; ++x) {
                    if (!(structure[y][z][x] instanceof Character) || ((Character)structure[y][z][x]).charValue() != 'c') continue;
                    return new HashedBlockPosition(x, y, z);
                }
            }
        }
        return null;
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        LinkedList<ModuleBase> btns = new LinkedList<ModuleBase>();
        for (int i = 0; i < this.machineList.size(); ++i) {
            TileMultiBlock multiblock = this.machineList.get(i);
            btns.add(new ModuleButton(60, 4 + i * 24, i, LibVulpes.proxy.getLocalizedString(multiblock.getMachineName()), this, TextureResources.buttonBuild));
        }
        ModuleContainerPan panningContainer = new ModuleContainerPan(5, 20, btns, new LinkedList<ModuleBase>(), TextureResources.starryBG, 160, 100, 0, 500);
        modules.add(panningContainer);
        return modules;
    }

    @Override
    public String getModularInventoryName() {
        return "item.holoProjector.name";
    }

    @Override
    public boolean canInteractWithContainer(EntityPlayer entity) {
        return entity != null && !entity.field_70128_L && !entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        if (!stack.func_190926_b() && stack.func_77973_b() == this) {
            this.setMachineId(stack, buttonId);
            PacketHandler.sendToServer(new PacketItemModifcation(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0));
        }
    }

    private void setMachineId(@Nonnull ItemStack stack, int id) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a(IDNAME, id);
        stack.func_77982_d(nbt);
    }

    private int getMachineId(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(IDNAME);
        }
        return -1;
    }

    private void setYLevel(@Nonnull ItemStack stack, int level) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TileMultiBlock machine = this.machineList.get(this.getMachineId(stack));
        if (level == -2) {
            level = machine.getStructure().length - 1;
        } else if (level == machine.getStructure().length) {
            level = -1;
        }
        nbt.func_74768_a("yOffset", level);
        stack.func_77982_d(nbt);
    }

    private int getYLevel(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("yOffset");
        }
        return -1;
    }

    private void setPrevMachineId(@Nonnull ItemStack stack, int id) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("machineIdPrev", id);
        stack.func_77982_d(nbt);
    }

    private int getPrevMachineId(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("machineIdPrev");
        }
        return -1;
    }

    private Vector3F<Integer> getBasePosition(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            return new Vector3F<Integer>(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        }
        return null;
    }

    private void setBasePosition(@Nonnull ItemStack stack, int x, int y, int z) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("x", x);
        nbt.func_74768_a("y", y);
        nbt.func_74768_a("z", z);
        stack.func_77982_d(nbt);
    }

    public int getDirection(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("dir");
        }
        return -1;
    }

    public void setDirection(@Nonnull ItemStack stack, int dir) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("dir", dir);
        stack.func_77982_d(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World player, List<String> list, ITooltipFlag bool) {
        super.func_77624_a(stack, player, list, bool);
        list.add("Shift right-click: opens machine selection interface");
        list.add("Shift-scroll: moves cross-section");
        int id = this.getMachineId(stack);
        if (id != -1) {
            list.add("");
            list.add(ChatFormatting.GREEN + LibVulpes.proxy.getLocalizedString(this.machineList.get(id).getMachineName()));
            String str = this.descriptionList.get(id);
            String[] strList = str.split("\n");
            list.addAll(Arrays.asList(strList));
        }
    }

    @Override
    public void writeDataToNetwork(ByteBuf out, byte id, @Nonnull ItemStack stack) {
        if (id == 0) {
            out.writeInt(this.getMachineId(stack));
        } else if (id == 1) {
            out.writeInt(this.getYLevel(stack));
        } else if (id == 2) {
            Vector3F<Integer> pos = this.getBasePosition(stack);
            out.writeInt(((Integer)pos.x).intValue());
            out.writeInt(((Integer)pos.y).intValue());
            out.writeInt(((Integer)pos.z).intValue());
            out.writeInt(this.getDirection(stack));
        }
    }

    @Override
    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt, @Nonnull ItemStack stack) {
        if (packetId == 0) {
            nbt.func_74768_a(IDNAME, in.readInt());
        } else if (packetId == 1) {
            nbt.func_74768_a("yLevel", in.readInt());
        } else if (packetId == 2) {
            nbt.func_74768_a("x", in.readInt());
            nbt.func_74768_a("y", in.readInt());
            nbt.func_74768_a("z", in.readInt());
            nbt.func_74768_a("dir", in.readInt());
        }
    }

    @Override
    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt, @Nonnull ItemStack stack) {
        if (id == 0) {
            int machineId = nbt.func_74762_e(IDNAME);
            this.setMachineId(stack, nbt.func_74762_e(IDNAME));
            TileMultiBlock tile = this.machineList.get(machineId);
            this.setYLevel(stack, tile.getStructure().length - 1);
        } else if (id == 1) {
            this.setYLevel(stack, nbt.func_74762_e("yLevel"));
            Vector3F<Integer> vec = this.getBasePosition(stack);
            this.RebuildStructure(player.field_70170_p, this.machineList.get(this.getMachineId(stack)), stack, (Integer)vec.x, (Integer)vec.y, (Integer)vec.z, EnumFacing.func_82600_a((int)this.getDirection(stack)));
        } else if (id == 2) {
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            int dir = nbt.func_74762_e("dir");
            if (this.getMachineId(stack) != -1) {
                this.RebuildStructure(player.field_70170_p, this.machineList.get(this.getMachineId(stack)), stack, x, y, z, EnumFacing.func_82600_a((int)dir));
            }
        }
    }
}

