/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.storm;

import CoroUtil.block.TileEntityRepairingBlock;
import CoroUtil.forge.CULog;
import CoroUtil.forge.CommonProxy;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.UtilMining;
import CoroUtil.util.Vec3;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.ClientConfigData;
import weather2.ClientTickHandler;
import weather2.config.ConfigMisc;
import weather2.config.ConfigStorm;
import weather2.config.ConfigTornado;
import weather2.entity.EntityMovingBlock;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilEntity;
import weather2.util.WeatherUtilSound;
import weather2.weathersystem.storm.StormObject;

public class TornadoHelper {
    public StormObject storm;
    public int ripCount = 0;
    public long lastGrabTime = 0L;
    public int tickGrabCount = 0;
    public int removeCount = 0;
    public int tryRipCount = 0;
    public int tornadoBaseSize = 5;
    public int grabDist = 100;
    public boolean lastTickPlayerClose;
    private HashMap<BlockPos, BlockUpdateSnapshot> listBlockUpdateQueue = new HashMap();
    private int queueProcessRate = 10;
    public static boolean isOutsideCached = false;
    public boolean isBlockGrabbingBlockedCached = true;
    public long isBlockGrabbingBlockedCached_LastCheck = 0L;
    public static HashMap<Integer, Long> flyingBlock_LastQueryTime = new HashMap();
    public static HashMap<Integer, Integer> flyingBlock_LastCount = new HashMap();
    public static GameProfile fakePlayerProfile = null;

    public TornadoHelper(StormObject parStorm) {
        this.storm = parStorm;
    }

    public int getTornadoBaseSize() {
        int sizeChange = 10;
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE5) {
            return sizeChange * 9;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE4) {
            return sizeChange * 7;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE3) {
            return sizeChange * 5;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE2) {
            return sizeChange * 4;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE1) {
            return sizeChange * 3;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_FORMING) {
            return sizeChange * 1;
        }
        return 5;
    }

    public void tick(World parWorld) {
        Random rand;
        if (!parWorld.field_72995_K && parWorld.func_82737_E() % (long)this.queueProcessRate == 0L) {
            Iterator<BlockUpdateSnapshot> it = this.listBlockUpdateQueue.values().iterator();
            int count = 0;
            int entityCreateStaggerRate = 3;
            rand = new Random();
            while (it.hasNext()) {
                BlockUpdateSnapshot snapshot = it.next();
                WorldServer world = DimensionManager.getWorld((int)snapshot.getDimID());
                if (world != null) {
                    if (snapshot.getState().func_177230_c() == Blocks.field_150350_a && ConfigTornado.Storm_Tornado_grabbedBlocksRepairOverTime && UtilMining.canConvertToRepairingBlock((World)world, (IBlockState)snapshot.statePrev)) {
                        TileEntityRepairingBlock.replaceBlockAndBackup((World)world, (BlockPos)snapshot.getPos(), (int)ConfigTornado.Storm_Tornado_TicksToRepairBlock);
                    } else {
                        CULog.dbg((String)("cant use repairing block on: " + snapshot.statePrev));
                        world.func_180501_a(snapshot.getPos(), snapshot.getState(), 3);
                    }
                    if (snapshot.isCreateEntityForBlockRemoval()) {
                        EntityMovingBlock mBlock = new EntityMovingBlock(parWorld, snapshot.getPos().func_177958_n(), snapshot.getPos().func_177956_o(), snapshot.getPos().func_177952_p(), snapshot.statePrev, this.storm);
                        double speed = 1.0;
                        mBlock.field_70159_w += (rand.nextDouble() - rand.nextDouble()) * speed;
                        mBlock.field_70179_y += (rand.nextDouble() - rand.nextDouble()) * speed;
                        mBlock.field_70181_x = 1.0;
                        parWorld.func_72838_d((Entity)mBlock);
                    }
                }
                ++count;
            }
            this.listBlockUpdateQueue.clear();
        }
        if (this.storm == null) {
            return;
        }
        boolean seesLight = false;
        this.tickGrabCount = 0;
        this.removeCount = 0;
        this.tryRipCount = 0;
        int tryRipMax = 300;
        int firesPerTickMax = 1;
        if (this.storm.isFirenado) {
            // empty if block
        }
        this.tornadoBaseSize = this.getTornadoBaseSize();
        if (this.storm.stormType == StormObject.TYPE_WATER) {
            this.tornadoBaseSize *= 3;
        }
        this.forceRotate(parWorld);
        rand = new Random();
        int spawnYOffset = (int)this.storm.posBaseFormationPos.yCoord;
        if (!parWorld.field_72995_K && (ConfigTornado.Storm_Tornado_grabBlocks || this.storm.isFirenado)) {
            int yStart = 0;
            int yEnd = (int)this.storm.pos.yCoord;
            int yInc = 1;
            Biome bgb = parWorld.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)this.storm.pos.xCoord), 0, MathHelper.func_76128_c((double)this.storm.pos.zCoord)));
            if (bgb != null && ((double)bgb.func_185355_j() <= 0.7 || this.storm.isFirenado)) {
                for (int i = yStart; i < yEnd; i += yInc) {
                    int YRand = i;
                    int ii = YRand / 4;
                    if (i > 20 && rand.nextInt(2) != 0) continue;
                    if (this.tryRipCount > tryRipMax) break;
                    int extraTry = (int)(((float)(this.storm.levelCurIntensityStage + 1) - StormObject.levelStormIntensityFormingStartVal) * 5.0f);
                    int loopAmount = 5 + ii + extraTry;
                    if (this.storm.stormType == StormObject.TYPE_WATER) {
                        loopAmount = 1 + ii / 2;
                    }
                    for (int k = 0; k < loopAmount && this.tryRipCount <= tryRipMax; ++k) {
                        int tryY = (int)((double)(spawnYOffset + YRand) - 1.5);
                        if (tryY > 255) {
                            tryY = 255;
                        }
                        int tryX = (int)this.storm.pos.xCoord + rand.nextInt(this.tornadoBaseSize + ii) - (this.tornadoBaseSize / 2 + ii / 2);
                        int tryZ = (int)this.storm.pos.zCoord + rand.nextInt(this.tornadoBaseSize + ii) - (this.tornadoBaseSize / 2 + ii / 2);
                        double d0 = this.storm.pos.xCoord - (double)tryX;
                        double d2 = this.storm.pos.zCoord - (double)tryZ;
                        double dist = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                        BlockPos pos = new BlockPos(tryX, tryY, tryZ);
                        if (!(dist < (double)(this.tornadoBaseSize / 2 + ii / 2)) || this.tryRipCount >= tryRipMax) continue;
                        IBlockState state = parWorld.func_180495_p(pos);
                        Block blockID = state.func_177230_c();
                        boolean performed = false;
                        if (this.canGrab(parWorld, state, pos)) {
                            ++this.tryRipCount;
                            performed = seesLight = this.tryRip(parWorld, tryX, tryY, tryZ);
                        }
                        if (performed || !ConfigTornado.Storm_Tornado_RefinedGrabRules || blockID != Blocks.field_150349_c || this.listBlockUpdateQueue.containsKey(pos)) continue;
                        this.listBlockUpdateQueue.put(pos, new BlockUpdateSnapshot(parWorld.field_73011_w.getDimension(), Blocks.field_150346_d.func_176223_P(), state, pos, false));
                    }
                }
                for (int k = 0; k < 10; ++k) {
                    int randSize = 40;
                    randSize = 10;
                    int tryX = (int)this.storm.pos.xCoord + rand.nextInt(randSize) - randSize / 2;
                    int tryY = spawnYOffset - 2 + rand.nextInt(8);
                    double d0 = this.storm.pos.xCoord - (double)tryX;
                    int tryZ = (int)this.storm.pos.zCoord + rand.nextInt(randSize) - randSize / 2;
                    double d2 = this.storm.pos.zCoord - (double)tryZ;
                    double dist = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                    if (!(dist < (double)(this.tornadoBaseSize / 2 + randSize / 2)) || this.tryRipCount >= tryRipMax) continue;
                    BlockPos pos = new BlockPos(tryX, tryY, tryZ);
                    IBlockState state = parWorld.func_180495_p(pos);
                    Block blockID = state.func_177230_c();
                    if (!this.canGrab(parWorld, state, pos)) continue;
                    ++this.tryRipCount;
                    this.tryRip(parWorld, tryX, tryY, tryZ);
                }
            }
        } else {
            seesLight = true;
        }
        if (Math.abs((double)spawnYOffset - this.storm.pos.yCoord) > 5.0) {
            seesLight = true;
        }
        if (!parWorld.field_72995_K && this.storm.isFirenado) {
            if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE1) {
                for (int i = 0; i < firesPerTickMax; ++i) {
                    BlockPos posUp = new BlockPos(this.storm.posGround.xCoord, this.storm.posGround.yCoord + (double)rand.nextInt(30), this.storm.posGround.zCoord);
                    IBlockState state = parWorld.func_180495_p(posUp);
                    if (!CoroUtilBlock.isAir((Block)state.func_177230_c())) continue;
                    EntityMovingBlock mBlock = new EntityMovingBlock(parWorld, posUp.func_177958_n(), posUp.func_177956_o(), posUp.func_177952_p(), Blocks.field_150480_ab.func_176223_P(), this.storm);
                    mBlock.metadata = 15;
                    double speed = 2.0;
                    mBlock.field_70159_w += (rand.nextDouble() - rand.nextDouble()) * speed;
                    mBlock.field_70179_y += (rand.nextDouble() - rand.nextDouble()) * speed;
                    mBlock.field_70181_x = 1.0;
                    mBlock.mode = 0;
                    parWorld.func_72838_d((Entity)mBlock);
                }
            }
            int randSize = 10;
            int tryX = (int)this.storm.pos.xCoord + rand.nextInt(randSize) - randSize / 2;
            int tryZ = (int)this.storm.pos.zCoord + rand.nextInt(randSize) - randSize / 2;
            int tryY = parWorld.func_189649_b(tryX, tryZ) - 1;
            double d0 = this.storm.pos.xCoord - (double)tryX;
            double d2 = this.storm.pos.zCoord - (double)tryZ;
            double dist = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            if (dist < (double)(this.tornadoBaseSize / 2 + randSize / 2) && this.tryRipCount < tryRipMax) {
                BlockPos pos = new BlockPos(tryX, tryY, tryZ);
                Block block = parWorld.func_180495_p(pos).func_177230_c();
                BlockPos posUp = new BlockPos(tryX, tryY + 1, tryZ);
                Block blockUp = parWorld.func_180495_p(posUp).func_177230_c();
                if (!CoroUtilBlock.isAir((Block)block) && CoroUtilBlock.isAir((Block)blockUp)) {
                    parWorld.func_175656_a(posUp, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    public boolean isNoDigCoord(int x, int y, int z) {
        return false;
    }

    public boolean tryRip(World parWorld, int tryX, int tryY, int tryZ) {
        boolean tryRip = true;
        BlockPos pos = new BlockPos(tryX, tryY, tryZ);
        if (this.listBlockUpdateQueue.containsKey(pos)) {
            return true;
        }
        if (!tryRip) {
            return true;
        }
        if (!ConfigTornado.Storm_Tornado_grabBlocks) {
            return true;
        }
        if (this.isNoDigCoord(tryX, tryY, tryZ)) {
            return true;
        }
        boolean seesLight = false;
        IBlockState state = parWorld.func_180495_p(pos);
        Block blockID = state.func_177230_c();
        if (WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(tryX, 0, tryZ)).func_177956_o() - 1 == tryY || WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(tryX + 1, 0, tryZ)).func_177956_o() - 1 < tryY || WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(tryX, 0, tryZ + 1)).func_177956_o() - 1 < tryY || WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(tryX - 1, 0, tryZ)).func_177956_o() - 1 < tryY || WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(tryX, 0, tryZ - 1)).func_177956_o() - 1 < tryY) {
            int blockCount = TornadoHelper.getBlockCountForDim(parWorld);
            if (parWorld.func_175667_e(new BlockPos(this.storm.pos.xCoord, 128.0, this.storm.pos.zCoord)) && this.lastGrabTime < System.currentTimeMillis() && this.tickGrabCount < ConfigTornado.Storm_Tornado_maxBlocksGrabbedPerTick) {
                this.lastGrabTime = System.currentTimeMillis() - 5L;
                if (blockID != Blocks.field_150433_aE) {
                    boolean playerClose;
                    boolean bl = playerClose = parWorld.func_184137_a(this.storm.posBaseFormationPos.xCoord, this.storm.posBaseFormationPos.yCoord, this.storm.posBaseFormationPos.zCoord, 140.0, false) != null;
                    if (playerClose) {
                        ++this.tickGrabCount;
                        ++this.ripCount;
                        if (this.ripCount % 10 == 0) {
                            // empty if block
                        }
                        seesLight = true;
                    }
                    if (WeatherUtil.shouldRemoveBlock(blockID)) {
                        ++this.removeCount;
                        boolean shouldEntityify = blockCount <= ConfigTornado.Storm_Tornado_maxFlyingEntityBlocks;
                        this.listBlockUpdateQueue.put(pos, new BlockUpdateSnapshot(parWorld.field_73011_w.getDimension(), Blocks.field_150350_a.func_176223_P(), state, pos, playerClose && shouldEntityify));
                    }
                }
                if (blockID == Blocks.field_150359_w) {
                    parWorld.func_184133_a(null, new BlockPos(tryX, tryY, tryZ), SoundEvents.field_187561_bM, SoundCategory.AMBIENT, 5.0f, 1.0f);
                }
            }
        }
        return seesLight;
    }

    public boolean canGrab(World parWorld, IBlockState state, BlockPos pos) {
        if (!CoroUtilBlock.isAir((Block)state.func_177230_c()) && state.func_177230_c() != Blocks.field_150480_ab && state.func_177230_c() != CommonProxy.blockRepairingBlock && WeatherUtil.shouldGrabBlock(parWorld, state) && !this.isBlockGrabbingBlocked(parWorld, state, pos)) {
            return this.canGrabEventCheck(parWorld, state, pos);
        }
        return false;
    }

    public boolean canGrabEventCheck(World world, IBlockState state, BlockPos pos) {
        if (!ConfigMisc.blockBreakingInvokesCancellableEvent) {
            return true;
        }
        if (world instanceof WorldServer) {
            if (fakePlayerProfile == null) {
                fakePlayerProfile = new GameProfile(UUID.fromString("1396b887-2570-4948-86e9-0633d1d22946"), "weather2FakePlayer");
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)fakePlayerProfile));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        return false;
    }

    public boolean canGrabEntity(Entity ent) {
        if (ent.field_70170_p.field_72995_K) {
            return this.canGrabEntityClient(ent);
        }
        if (ent instanceof EntityPlayer) {
            return ConfigTornado.Storm_Tornado_grabPlayer;
        }
        if (ConfigTornado.Storm_Tornado_grabPlayersOnly) {
            return false;
        }
        if (ent instanceof INpc) {
            return ConfigTornado.Storm_Tornado_grabVillagers;
        }
        if (ent instanceof EntityItem) {
            return ConfigTornado.Storm_Tornado_grabItems;
        }
        if (ent instanceof IMob) {
            return ConfigTornado.Storm_Tornado_grabMobs;
        }
        if (ent instanceof EntityAnimal) {
            return ConfigTornado.Storm_Tornado_grabAnimals;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canGrabEntityClient(Entity ent) {
        ClientConfigData clientConfig = ClientTickHandler.clientConfigData;
        if (ent instanceof EntityPlayer) {
            return clientConfig.Storm_Tornado_grabPlayer;
        }
        if (clientConfig.Storm_Tornado_grabPlayersOnly) {
            return false;
        }
        if (ent instanceof INpc) {
            return clientConfig.Storm_Tornado_grabVillagers;
        }
        if (ent instanceof EntityItem) {
            return clientConfig.Storm_Tornado_grabItems;
        }
        if (ent instanceof IMob) {
            return clientConfig.Storm_Tornado_grabMobs;
        }
        if (ent instanceof EntityAnimal) {
            return clientConfig.Storm_Tornado_grabAnimals;
        }
        return true;
    }

    public boolean forceRotate(World parWorld) {
        double dist = this.grabDist;
        AxisAlignedBB aabb = new AxisAlignedBB(this.storm.pos.xCoord, (double)this.storm.currentTopYBlock, this.storm.pos.zCoord, this.storm.pos.xCoord, (double)this.storm.currentTopYBlock, this.storm.pos.zCoord);
        aabb = aabb.func_72314_b(dist, (double)(this.storm.maxHeight * 3), dist);
        List list = parWorld.func_72872_a(Entity.class, aabb);
        boolean foundEnt = false;
        boolean killCount = false;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (!this.canGrabEntity(entity1) || !(this.getDistanceXZ(this.storm.posBaseFormationPos, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v) < dist)) continue;
                if (entity1 instanceof EntityMovingBlock && !((EntityMovingBlock)entity1).collideFalling) {
                    this.storm.spinEntity(entity1);
                    foundEnt = true;
                    continue;
                }
                if (entity1 instanceof EntityPlayer) {
                    if (!WeatherUtilEntity.isEntityOutside(entity1)) continue;
                    this.storm.spinEntity(entity1);
                    foundEnt = true;
                    continue;
                }
                if (!(entity1 instanceof EntityLivingBase) && !(entity1 instanceof EntityItem) || !WeatherUtilEntity.isEntityOutside(entity1, true)) continue;
                this.storm.spinEntity(entity1);
                foundEnt = true;
            }
        }
        return foundEnt;
    }

    public double getDistanceXZ(Vec3 parVec, double var1, double var3, double var5) {
        double var7 = parVec.xCoord - var1;
        double var11 = parVec.zCoord - var5;
        return MathHelper.func_76133_a((double)(var7 * var7 + var11 * var11));
    }

    public double getDistanceXZ(Entity ent, double var1, double var3, double var5) {
        double var7 = ent.field_70165_t - var1;
        double var11 = ent.field_70161_v - var5;
        return MathHelper.func_76133_a((double)(var7 * var7 + var11 * var11));
    }

    @SideOnly(value=Side.CLIENT)
    public void soundUpdates(boolean playFarSound, boolean playNearSound) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71439_g == null) {
            return;
        }
        int far = 200;
        int close = 120;
        if (this.storm.stormType == StormObject.TYPE_WATER) {
            close = 200;
        }
        Vec3 plPos = new Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v);
        double distToPlayer = this.storm.posGround.distanceTo(plPos);
        float volScaleFar = (float)(((double)far - distToPlayer) / (double)far);
        float volScaleClose = (float)(((double)close - distToPlayer) / (double)close);
        if (volScaleFar < 0.0f) {
            volScaleFar = 0.0f;
        }
        if (volScaleClose < 0.0f) {
            volScaleClose = 0.0f;
        }
        if (distToPlayer < (double)close) {
            if (!this.lastTickPlayerClose) {
                // empty if block
            }
            this.lastTickPlayerClose = true;
        } else {
            this.lastTickPlayerClose = false;
        }
        if (distToPlayer < (double)far) {
            if (playFarSound) {
                if (mc.field_71441_e.func_82737_E() % 40L == 0L) {
                    isOutsideCached = WeatherUtilEntity.isPosOutside((World)mc.field_71441_e, new Vec3((double)((float)mc.field_71439_g.func_180425_c().func_177958_n() + 0.5f), (double)((float)mc.field_71439_g.func_180425_c().func_177956_o() + 0.5f), (double)((float)mc.field_71439_g.func_180425_c().func_177952_p() + 0.5f)));
                }
                if (isOutsideCached) {
                    this.tryPlaySound(WeatherUtilSound.snd_wind_far, 2, (Entity)mc.field_71439_g, volScaleFar, far);
                }
            }
            if (playNearSound) {
                this.tryPlaySound(WeatherUtilSound.snd_wind_close, 1, (Entity)mc.field_71439_g, volScaleClose, close);
            }
            if (this.storm.levelCurIntensityStage >= StormObject.STATE_FORMING) {
                if (this.storm.stormType == StormObject.TYPE_LAND) {
                    this.tryPlaySound(WeatherUtilSound.snd_tornado_dmg_close, 0, (Entity)mc.field_71439_g, volScaleClose, close);
                }
            }
        }
    }

    public boolean tryPlaySound(String[] sound, int arrIndex, Entity source, float vol, float parCutOffRange) {
        Entity soundTarget = source;
        Random rand = new Random();
        if (WeatherUtilSound.soundTimer[arrIndex] <= System.currentTimeMillis()) {
            WeatherUtilSound.playMovingSound(this.storm, "streaming." + sound[WeatherUtilSound.snd_rand[arrIndex]], vol, 1.0f, parCutOffRange);
            int length = WeatherUtilSound.soundToLength.get(sound[WeatherUtilSound.snd_rand[arrIndex]]);
            WeatherUtilSound.soundTimer[arrIndex] = System.currentTimeMillis() + (long)length - 500L;
            WeatherUtilSound.snd_rand[arrIndex] = rand.nextInt(3);
        }
        return false;
    }

    public static int getBlockCountForDim(World world) {
        int queryRate = 20;
        boolean perform = false;
        int flyingBlockCount = 0;
        int dimID = world.field_73011_w.getDimension();
        if (!flyingBlock_LastCount.containsKey(dimID) || !flyingBlock_LastQueryTime.containsKey(dimID)) {
            perform = true;
        } else if (flyingBlock_LastQueryTime.get(dimID) + (long)queryRate < world.func_82737_E()) {
            perform = true;
        }
        if (perform) {
            Entity ent;
            List entities = world.field_72996_f;
            for (int i = 0; !(i >= entities.size() || (ent = (Entity)entities.get(i)) instanceof EntityMovingBlock && ++flyingBlockCount > ConfigTornado.Storm_Tornado_maxFlyingEntityBlocks); ++i) {
            }
            flyingBlock_LastQueryTime.put(dimID, world.func_82737_E());
            flyingBlock_LastCount.put(dimID, flyingBlockCount);
        }
        return flyingBlock_LastCount.get(dimID);
    }

    public boolean isBlockGrabbingBlocked(World world, IBlockState state, BlockPos pos) {
        int queryRate = 40;
        if (this.isBlockGrabbingBlockedCached_LastCheck + (long)queryRate < world.func_82737_E()) {
            this.isBlockGrabbingBlockedCached_LastCheck = world.func_82737_E();
            this.isBlockGrabbingBlockedCached = false;
            for (Long hash : this.storm.manager.getListWeatherBlockDamageDeflector()) {
                BlockPos posDeflect = BlockPos.func_177969_a((long)hash);
                if (!(pos.func_177951_i((Vec3i)posDeflect) < (double)(ConfigStorm.Storm_Deflector_RadiusOfStormRemoval * ConfigStorm.Storm_Deflector_RadiusOfStormRemoval))) continue;
                this.isBlockGrabbingBlockedCached = true;
                break;
            }
        }
        return this.isBlockGrabbingBlockedCached;
    }

    public void cleanup() {
        this.listBlockUpdateQueue.clear();
        this.storm = null;
    }

    public static class BlockUpdateSnapshot {
        private int dimID;
        private IBlockState state;
        private IBlockState statePrev;
        private BlockPos pos;
        private boolean createEntityForBlockRemoval;

        public BlockUpdateSnapshot(int dimID, IBlockState state, IBlockState statePrev, BlockPos pos, boolean createEntityForBlockRemoval) {
            this.dimID = dimID;
            this.state = state;
            this.statePrev = statePrev;
            this.pos = pos;
            this.createEntityForBlockRemoval = createEntityForBlockRemoval;
        }

        public int getDimID() {
            return this.dimID;
        }

        public void setDimID(int dimID) {
            this.dimID = dimID;
        }

        public IBlockState getState() {
            return this.state;
        }

        public void setState(IBlockState state) {
            this.state = state;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void setPos(BlockPos pos) {
            this.pos = pos;
        }

        public boolean isCreateEntityForBlockRemoval() {
            return this.createEntityForBlockRemoval;
        }

        public void setCreateEntityForBlockRemoval(boolean createEntityForBlockRemoval) {
            this.createEntityForBlockRemoval = createEntityForBlockRemoval;
        }

        public IBlockState getStatePrev() {
            return this.statePrev;
        }

        public void setStatePrev(IBlockState statePrev) {
            this.statePrev = statePrev;
        }
    }
}

