/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.misc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;

public class OFMDepLoader
implements IFMLLoadingPlugin,
IFMLCallHook {
    public void load() throws IOException, URISyntaxException {
        System.out.println("Starting OpenFM DepLoader!");
        File f = new File("mods" + File.separator);
        f.mkdirs();
        String path = "assets/openfm/deps";
        File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        if (jarFile.isFile()) {
            JarFile jar = null;
            jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith("assets/openfm/deps/") || !name.endsWith(".jar")) continue;
                InputStream jarStream = this.getClass().getClassLoader().getResourceAsStream(name);
                Path p = Paths.get(name, new String[0]);
                String file = p.getFileName().toString();
                System.out.println("Extracting file: " + file);
                FileOutputStream fos = new FileOutputStream(f + File.separator + file);
                Throwable throwable = null;
                try {
                    int r;
                    byte[] buf = new byte[2048];
                    while (-1 != (r = jarStream.read(buf))) {
                        fos.write(buf, 0, r);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
            jar.close();
        } else {
            System.out.println("ERROR: Can't detect valid JAR");
        }
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public Void call() {
        try {
            this.load();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getAccessTransformerClass() {
        return null;
    }
}

