/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.TileEntity;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pcl.OpenFM.Block.BlockSpeaker;
import pcl.OpenFM.OFMConfiguration;
import pcl.OpenFM.OpenFM;
import pcl.OpenFM.misc.Speaker;
import pcl.OpenFM.network.MessageRadioBase;
import pcl.OpenFM.network.PacketHandler;
import pcl.OpenFM.network.message.MessageRadioAddSpeaker;
import pcl.OpenFM.network.message.MessageRadioAddStation;
import pcl.OpenFM.network.message.MessageRadioDelStation;
import pcl.OpenFM.network.message.MessageRadioPlaying;
import pcl.OpenFM.network.message.MessageRadioSync;
import pcl.OpenFM.player.PlayerDispatcher;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.ManagedPeripheral", modid="opencomputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft")})
public class TileEntityRadio
extends TileEntity
implements IPeripheral,
SimpleComponent,
ManagedPeripheral,
ITickable {
    public PlayerDispatcher player = null;
    public boolean isPlaying = false;
    public boolean isValid = true;
    public String streamURL = "";
    public float volume = 0.3f;
    private boolean redstoneInput = false;
    public boolean listenToRedstone = false;
    private boolean scheduledRedstoneInput = false;
    private boolean scheduleRedstoneInput = false;
    public ArrayList<Speaker> speakers = new ArrayList();
    public int screenColor = 720650;
    public String screenText = "OpenFM";
    public String screenOut = "";
    public List<String> stations = new ArrayList<String>();
    private int stationCount = 0;
    public boolean isLocked;
    public String owner = "";
    public ItemStackHandler inventory = new ItemStackHandler(1);
    int th = 0;
    int loops = 0;
    int ticks = 0;
    int renderCount = 0;
    public static final int numMethods;
    public static final String[] methodNames;
    public static final Map<String, Integer> methodIds;

    public TileEntityRadio(World w) {
        if (this.isPlaying) {
            try {
                this.startStream();
            }
            catch (Exception e) {
                this.stopStream();
            }
        }
    }

    public TileEntityRadio() {
        if (this.isPlaying) {
            try {
                this.startStream();
            }
            catch (Exception e) {
                this.stopStream();
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    public void startStream() {
        OFMConfiguration.init(OpenFM.configFile);
        if (OFMConfiguration.enableStreams) {
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            String decoder = null;
            if (!OpenFM.playerList.contains(this.player)) {
                if (side == Side.CLIENT) {
                    OkHttpClient client = new OkHttpClient();
                    Request request = new Request.Builder().url(this.streamURL).build();
                    Response response = null;
                    AudioFileFormat baseFileFormat = null;
                    try {
                        response = client.newCall(request).execute();
                    }
                    catch (IOException e1) {
                        this.isValid = false;
                        this.streamURL = null;
                        this.stopStream();
                    }
                    try {
                        BufferedInputStream bis = new BufferedInputStream(response.body().byteStream());
                        baseFileFormat = AudioSystem.getAudioFileFormat(bis);
                    }
                    catch (IOException | UnsupportedAudioFileException e1) {
                        this.isValid = false;
                        this.streamURL = null;
                        this.stopStream();
                    }
                    if (this.isValid) {
                        AudioFileFormat.Type type = baseFileFormat.getType();
                        OpenFM.logger.info((Object)baseFileFormat.getFormat());
                        OpenFM.logger.info(type.toString());
                        if (type.toString().equals("MP3")) {
                            decoder = "mp3";
                        } else if (type.toString().equals("AAC")) {
                            this.isValid = false;
                            this.stopStream();
                            OpenFM.logger.error("Stopping AAC Stream before catastrophic failure");
                        } else if (type.toString().equals("OGG")) {
                            decoder = "ogg";
                        }
                        if (decoder != null && this.isValid) {
                            this.isPlaying = true;
                            OpenFM.logger.info("Starting Stream: " + this.streamURL + " at X:" + this.field_174879_c.func_177958_n() + " Y:" + this.field_174879_c.func_177956_o() + " Z:" + this.field_174879_c.func_177952_p());
                            this.player = new PlayerDispatcher(decoder, this.streamURL, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                            OpenFM.playerList.add(this.player);
                        }
                    }
                } else if (this.isValid) {
                    this.isPlaying = true;
                }
            }
        } else {
            this.stopStream();
        }
    }

    public void stopStream() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (OpenFM.playerList.contains(this.player)) {
            if (side == Side.CLIENT) {
                this.player.stop();
            }
            OpenFM.playerList.remove(this.player);
            this.isPlaying = false;
        }
        this.isPlaying = false;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_145843_s() {
        this.stopStream();
        super.func_145843_s();
    }

    public void func_73660_a() {
        Side side;
        if (this.getTicks() <= 20 || this.getScreenText().length() > 6) {
            // empty if block
        }
        if ((side = FMLCommonHandler.instance().getEffectiveSide()) == Side.CLIENT) {
            ++this.th;
            if (this.th >= OFMConfiguration.maxSpeakers) {
                for (Speaker s : this.speakers) {
                    IBlockState sb = this.func_145831_w().func_180495_p(new BlockPos(s.x, s.y, s.z));
                    if (sb.func_177230_c() instanceof BlockSpeaker) continue;
                    if (!this.func_145831_w().func_175726_f(new BlockPos(s.x, s.y, s.z)).func_177410_o()) break;
                    this.speakers.remove(s);
                    break;
                }
                this.th = 0;
            }
            if (Minecraft.func_71410_x().field_71439_g != null && this.player != null && !this.func_145837_r()) {
                float vol = this.getClosest();
                if (vol > 10000.0f * this.volume) {
                    if (this.player != null) {
                        this.player.setVolume(0.0f);
                    }
                } else {
                    float v2 = 10000.0f / vol / 100.0f;
                    if (v2 > 1.0f) {
                        if (this.player != null) {
                            this.player.setVolume(1.0f * this.volume * this.volume);
                        }
                    } else if (this.player != null) {
                        this.player.setVolume(v2 * this.volume * this.volume);
                    }
                }
                if (vol == 0.0f) {
                    this.func_145843_s();
                }
            }
        } else {
            if (this.isPlaying()) {
                if (this.loops >= 40) {
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageRadioSync(this).wrap(), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
                    this.loops = 0;
                } else {
                    ++this.loops;
                }
                ++this.th;
                if (this.th >= 60) {
                    for (Speaker s : this.speakers) {
                        if (this.field_145850_b.func_180495_p(new BlockPos(s.x, s.y, s.z)).func_177230_c() instanceof BlockSpeaker) continue;
                        if (!this.field_145850_b.func_175726_f(new BlockPos(s.x, s.y, s.z)).func_177410_o()) break;
                        this.speakers.remove(s);
                        break;
                    }
                    this.th = 0;
                }
            }
            if (this.listenToRedstone && this.isPlaying != this.scheduledRedstoneInput) {
                boolean bl = this.isPlaying = !this.isPlaying || this.scheduledRedstoneInput;
                if (this.func_145831_w() != null) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageRadioPlaying(this, this.isPlaying).wrap());
                }
            }
        }
    }

    public void setStreamURL(String url) {
        this.streamURL = url;
    }

    public String getStreamURL() {
        return this.streamURL;
    }

    public void addStation(String station) {
        if (station != null && !this.stations.contains(station)) {
            this.stations.add(station);
            if (this.stations.size() > 0) {
                PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageRadioAddStation(this, station).wrap(), this.func_145831_w().field_73011_w.getDimension());
                this.func_189517_E_();
                this.func_70296_d();
            }
        }
    }

    public void delStation(String station) {
        if (station != null && this.stations.contains(station)) {
            this.stations.remove(station);
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageRadioDelStation(this, station).wrap(), this.func_145831_w().field_73011_w.getDimension());
            this.func_189517_E_();
            this.func_70296_d();
        }
    }

    public String getNext(String uid) {
        int idx = this.stations.indexOf(uid);
        if (idx < 0 || idx + 1 == this.stations.size()) {
            return uid;
        }
        return this.stations.get(idx + 1);
    }

    public String getPrevious(String uid) {
        int idx = this.stations.indexOf(uid);
        if (idx <= 0 || idx - 1 == this.stations.size()) {
            return uid;
        }
        return this.stations.get(idx - 1);
    }

    public void setVolume(float vol) {
        this.volume = vol;
    }

    public boolean isListeningToRedstoneInput() {
        return this.listenToRedstone;
    }

    public void setScreenColor(Integer color) {
        this.screenColor = color;
        this.func_189517_E_();
        this.func_70296_d();
    }

    public void setRedstoneInput(boolean input) {
        if (input != this.scheduledRedstoneInput) {
            this.scheduledRedstoneInput = input;
        }
    }

    public void setScreenText(String text) {
        this.screenText = text;
        this.func_189517_E_();
        this.func_70296_d();
    }

    public String getScreenText() {
        return this.screenText;
    }

    public int addSpeaker(World w, int x, int y, int z) {
        int ret = this.canAddSpeaker(w, x, y, z);
        if (ret == 0) {
            this.speakers.add(new Speaker(x, y, z, w));
        }
        return ret;
    }

    public int canAddSpeaker(World w, int x, int y, int z) {
        if (this.speakers.size() >= OFMConfiguration.maxSpeakers) {
            return 1;
        }
        for (Speaker s : this.speakers) {
            if (s.x != x || s.y != y || s.z != z) continue;
            return 2;
        }
        return 0;
    }

    public float getVolume() {
        return this.volume;
    }

    private float getClosest() {
        float closest = (float)this.func_145835_a(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v);
        if (!this.speakers.isEmpty()) {
            for (Speaker s : this.speakers) {
                float distance = (float)Math.pow(Minecraft.func_71410_x().field_71439_g.func_70011_f((double)s.x, (double)s.y, (double)s.z), 2.0);
                if (!(closest > distance)) continue;
                closest = distance;
            }
        }
        return closest;
    }

    public int getScreenColor() {
        return this.screenColor;
    }

    public String getComponentName() {
        return "openfm_radio";
    }

    public int getStationCount() {
        return this.stationCount;
    }

    public void setStationCount(int stationCount) {
        this.stationCount = stationCount;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCom = new NBTTagCompound();
        this.func_189515_b(tagCom);
        for (Speaker s : this.speakers) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageRadioAddSpeaker(this, s).wrap(), this.func_145831_w().field_73011_w.getDimension());
        }
        if (this.streamURL != null) {
            MessageRadioBase message = new MessageRadioSync(this).wrap();
            World world = this.func_145831_w();
            WorldProvider provider = world.field_73011_w;
            int dimID = provider.getDimension();
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(dimID, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 30.0);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)message, point);
        }
        return tagCom;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        super.func_145839_a(nbt);
        this.streamURL = nbt.func_74779_i("streamurl");
        this.volume = nbt.func_74760_g("volume");
        this.listenToRedstone = nbt.func_74767_n("input");
        this.redstoneInput = nbt.func_74767_n("lastInput");
        this.isPlaying = nbt.func_74767_n("lastState");
        int speakersCount = nbt.func_74762_e("speakersCount");
        this.setStationCount(nbt.func_74762_e("stationCount"));
        this.screenColor = nbt.func_74762_e("screenColor");
        this.isLocked = nbt.func_74767_n("isLocked");
        this.owner = nbt.func_74779_i("owner");
        this.screenText = nbt.func_74779_i("screenText").length() < 1 ? "OpenFM" : nbt.func_74779_i("screenText");
        for (i = 0; i < speakersCount; ++i) {
            int x = nbt.func_74762_e("speakerX" + i);
            int y = nbt.func_74762_e("speakerY" + i);
            int z = nbt.func_74762_e("speakerZ" + i);
            this.addSpeaker(this.func_145831_w(), x, y, z);
        }
        for (i = 0; i < this.getStationCount(); ++i) {
            this.stations.add(nbt.func_74779_i("station" + i));
        }
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        int i;
        super.func_189515_b(nbt);
        if (this.streamURL != null) {
            nbt.func_74778_a("streamurl", this.streamURL);
        }
        nbt.func_74776_a("volume", this.volume);
        nbt.func_74757_a("input", this.listenToRedstone);
        nbt.func_74757_a("lastInput", this.redstoneInput);
        nbt.func_74757_a("lastState", this.isPlaying);
        nbt.func_74768_a("speakersCount", this.speakers.size());
        nbt.func_74768_a("screenColor", this.screenColor);
        if (this.screenText != null) {
            nbt.func_74778_a("screenText", this.screenText);
        }
        nbt.func_74757_a("isLocked", this.isLocked);
        if (this.owner != null) {
            nbt.func_74778_a("owner", this.owner);
        }
        for (i = 0; i < this.speakers.size(); ++i) {
            nbt.func_74768_a("speakerX" + i, this.speakers.get((int)i).x);
            nbt.func_74768_a("speakerY" + i, this.speakers.get((int)i).y);
            nbt.func_74768_a("speakerZ" + i, this.speakers.get((int)i).z);
        }
        for (i = 0; i < this.stations.size(); ++i) {
            String s = this.stations.get(i);
            if (s == null) continue;
            nbt.func_74778_a("station" + i, s);
            nbt.func_74768_a("stationCount", i + 1);
        }
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return nbt;
    }

    public Object[] callMethod(int method, Object[] args) {
        if (method < 0 || method >= numMethods) {
            throw new IllegalArgumentException("Invalid method number");
        }
        ComputerMethod computerMethod = ComputerMethod.values()[method];
        switch (computerMethod) {
            case getAttachedSpeakerCount: {
                return new Object[]{this.speakers.size()};
            }
            case setScreenColor: {
                if (args.length != 1) {
                    return new Object[]{false, "Insufficient number of arguments, expected 1"};
                }
                this.setScreenColor((int)Math.round((Double)args[0]));
                this.func_189517_E_();
                this.func_70296_d();
                return new Object[]{true};
            }
            case getScreenColor: {
                return new Object[]{this.getScreenColor()};
            }
            case setListenRedstone: {
                if (args.length != 1) {
                    return new Object[]{false, "Insufficient number of arguments, expected 1"};
                }
                this.setRedstoneInput((Boolean)args[0]);
                return new Object[]{this.isListeningToRedstoneInput()};
            }
            case getListenRedstone: {
                return new Object[]{this.isListeningToRedstoneInput()};
            }
            case isPlaying: {
                return new Object[]{this.isPlaying()};
            }
            case stop: {
                this.stopStream();
                this.isPlaying = false;
                this.func_189517_E_();
                return new Object[]{true};
            }
            case start: {
                try {
                    this.startStream();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.func_189517_E_();
                return new Object[]{true};
            }
            case greet: {
                return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
            }
            case getAttachedSpeakers: {
                return new Object[]{this.speakers.size()};
            }
            case setScreenText: {
                if (args.length != 1) {
                    return new Object[]{false, "Insufficient number of arguments, expected 1"};
                }
                String tempString = new String((byte[])args[0], StandardCharsets.UTF_8);
                this.setScreenText(tempString);
                this.func_189517_E_();
                this.func_70296_d();
                return new Object[]{true};
            }
            case volDown: {
                float v = (float)((double)this.volume - 0.1);
                if (v > 0.0f && v <= 1.0f) {
                    this.setVolume(v);
                    this.func_189517_E_();
                    this.func_70296_d();
                    return new Object[]{Float.valueOf(this.getVolume())};
                }
                return new Object[]{false};
            }
            case volUp: {
                float v1 = (float)((double)this.volume + 0.1);
                if (v1 > 0.0f && v1 <= 1.0f) {
                    this.setVolume(v1);
                    this.func_189517_E_();
                    this.func_70296_d();
                    return new Object[]{Float.valueOf(this.getVolume())};
                }
                return new Object[]{false};
            }
            case setVol: {
                if (args.length != 1) {
                    return new Object[]{false, "Insufficient number of arguments, expected 1"};
                }
                float v2 = ((Float)args[0]).floatValue();
                if (v2 > 0.0f && v2 <= 1.0f) {
                    this.setVolume(v2);
                    this.func_189517_E_();
                    this.func_70296_d();
                    return new Object[]{Float.valueOf(this.getVolume())};
                }
                return new Object[]{false};
            }
            case getVol: {
                return new Object[]{Float.valueOf(this.getVolume())};
            }
            case setURL: {
                if (args.length != 1) {
                    return new Object[]{false, "Insufficient number of arguments, expected 1"};
                }
                if (args[0] != null) {
                    String tempURL = null;
                    tempURL = args[0] instanceof byte[] ? new String((byte[])args[0], StandardCharsets.UTF_8) : String.valueOf(args[0]);
                    if (tempURL == null || tempURL.length() <= 1) {
                        return new Object[]{false, "Error parsing URL in packet"};
                    }
                    this.streamURL = tempURL;
                    this.func_189517_E_();
                    this.func_70296_d();
                    return new Object[]{true};
                }
                return new Object[]{false, "Error parsing URL in packet"};
            }
        }
        return new Object[]{false, "Not implemented."};
    }

    @Optional.Method(modid="opencomputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        Object[] arguments = new Object[args.count()];
        for (int i = 0; i < args.count(); ++i) {
            arguments[i] = args.checkAny(i);
        }
        Integer methodId = methodIds.get(method);
        if (methodId == null) {
            throw new NoSuchMethodError();
        }
        return this.callMethod(methodId, arguments);
    }

    @Optional.Method(modid="opencomputers")
    public String[] methods() {
        return methodNames;
    }

    public void writeDataToCard() {
        if (this.inventory.getStackInSlot(0) != ItemStack.field_190927_a) {
            this.inventory.getStackInSlot(0).func_77982_d(new NBTTagCompound());
            this.inventory.getStackInSlot(0).func_77978_p().func_74778_a("screenText", this.screenText);
            this.inventory.getStackInSlot(0).func_77978_p().func_74768_a("screenColor", this.screenColor);
            this.inventory.getStackInSlot(0).func_77978_p().func_74778_a("streamURL", this.streamURL);
            this.inventory.getStackInSlot(0).func_77978_p().func_74768_a("stationCount", this.stationCount);
            for (int i = 0; i < this.getStationCount(); ++i) {
                this.inventory.getStackInSlot(0).func_77978_p().func_74778_a("station" + i, this.stations.get(i));
            }
            this.inventory.getStackInSlot(0).func_151001_c(this.screenText);
        }
    }

    public void readDataFromCard() {
        if (this.inventory.getStackInSlot(0) != ItemStack.field_190927_a && this.inventory.getStackInSlot(0).func_77942_o()) {
            this.screenText = this.inventory.getStackInSlot(0).func_77978_p().func_74779_i("screenText");
            this.screenColor = this.inventory.getStackInSlot(0).func_77978_p().func_74762_e("screenColor");
            this.streamURL = this.inventory.getStackInSlot(0).func_77978_p().func_74779_i("streamURL");
            this.stationCount = this.inventory.getStackInSlot(0).func_77978_p().func_74762_e("stationCount");
            for (int i = 0; i < this.getStationCount(); ++i) {
                this.stations.add(this.inventory.getStackInSlot(0).func_77978_p().func_74779_i("station" + i));
            }
            this.func_189517_E_();
            this.func_70296_d();
        }
    }

    public void setOwner(String inOwner) {
        this.owner = inOwner;
    }

    public void incTicks() {
        ++this.ticks;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getRenderCount() {
        return this.renderCount;
    }

    public void incRenderCount() {
        ++this.renderCount;
    }

    public void resetRenderCount() {
        this.renderCount = 0;
    }

    public void resetTicks() {
        this.ticks = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public String scrollText(TileEntityRadio radio) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.func_175598_ae().func_78716_a();
        String text = "       " + this.screenText + "        ";
        if (text.length() > radio.getRenderCount() + 6 && text.trim().length() > 6) {
            this.incTicks();
            if (this.getTicks() % 20 == 0) {
                this.screenOut = text.substring(radio.getRenderCount(), radio.getRenderCount() + 6);
                if (fontRenderer.func_78256_a(this.screenOut) / 6 < 5) {
                    this.screenOut = text.substring(radio.getRenderCount(), radio.getRenderCount() + 7);
                }
                radio.incRenderCount();
                radio.resetTicks();
                if (radio.getRenderCount() > text.length()) {
                    radio.resetRenderCount();
                }
            }
        } else if (text.trim().length() <= 6) {
            this.screenOut = this.screenText;
        } else {
            radio.resetRenderCount();
        }
        return this.screenOut;
    }

    @Optional.Method(modid="computercraft")
    public String getType() {
        return "OpenFM-Radio";
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return methodNames;
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        try {
            return this.callMethod(method, arguments);
        }
        catch (Exception e) {
            OpenFM.logger.info("Exception encountered when invoking computercraft method: %s", (Object)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(IPeripheral other) {
        return ((Object)((Object)this)).hashCode() == other.hashCode();
    }

    static {
        ComputerMethod[] methods;
        numMethods = ComputerMethod.values().length;
        methodNames = new String[numMethods];
        for (ComputerMethod method : methods = ComputerMethod.values()) {
            TileEntityRadio.methodNames[method.ordinal()] = method.toString();
        }
        methodIds = new HashMap<String, Integer>();
        for (int i = 0; i < numMethods; ++i) {
            methodIds.put(methodNames[i], i);
        }
    }

    public static enum ComputerMethod {
        getAttachedSpeakerCount,
        setScreenColor,
        getScreenColor,
        setListenRedstone,
        getListenRedstone,
        isPlaying,
        stop,
        start,
        greet,
        setURL,
        getVol,
        setVol,
        volUp,
        volDown,
        setScreenText,
        getAttachedSpeakers;

    }
}

