/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.ClassDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.signatures.FieldSignature;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import org.objectweb.asm.tree.MethodInsnNode;

public class ImmersiveRailroading {
    private static final MethodSignature FLUID_TANK_DRAIN = MethodSignature.of((String)"cam72cam.mod.fluid.FluidTank", (String)"drain", (MethodDescriptor)MethodDescriptor.of((Descriptor)FluidStack.DESCRIPTOR).withParameters(new Descriptor[]{FluidStack.DESCRIPTOR, Types.BOOLEAN.descriptor}));

    public static class LocomotiveSteam
    extends Locomotive {
        public static boolean enabled = true;

        public static void handle(Entity entity, net.minecraft.item.ItemStack stack) {
            if (enabled) {
                BlockPos pos = ForgeEntity.getCenterPosition((Entity)entity).toBlockPos();
                WorldData.onFuelBurned(entity.field_70170_p, pos, stack, 1);
            }
        }

        protected MethodSignature getHandler() {
            return this.getDefaultHandlerWith(MethodDescriptor.VOID.withParameters(new Classes[]{Classes.ENTITY, Classes.ITEM_STACK}));
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return ItemStack.SET_COUNT.complyWith(instruct);
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.swap().dup().loadThis().getField(this.internalEntity).swap().getField(ItemStack.INTERNAL).invokeStatic(this.getHandler()).swap().insertBefore();
        }
    }

    public static class LocomotiveDiesel
    extends Locomotive {
        public static float rate = 1.0f;

        public static void handle(Entity entity, net.minecraftforge.fluids.FluidStack stack) {
            if (stack != null) {
                BlockPos pos = ForgeEntity.getCenterPosition((Entity)entity).toBlockPos();
                WorldData.onFuelBurned(entity.field_70170_p, pos, stack.getFluid(), Math.round((float)stack.amount * rate));
            }
        }

        protected MethodSignature getHandler() {
            return this.getDefaultHandlerWith(MethodDescriptor.VOID.withParameters(new Classes[]{Classes.ENTITY, Classes.FLUID_STACK}));
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return FLUID_TANK_DRAIN.complyWith(instruct);
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.dup().loadThis().getField(this.internalEntity).swap().getField(FluidStack.INTERNAL).invokeStatic(this.getHandler()).insertAfter();
        }
    }

    private static abstract class Locomotive
    extends ForgeClassTransformer {
        protected final String className = "cam72cam.immersiverailroading.entity." + ((Object)((Object)this)).getClass().getSimpleName();
        protected final MethodSignature targetMethod = MethodSignature.of((String)this.className, (String)"onTick", (MethodDescriptor)MethodDescriptor.VOID);
        protected final FieldSignature internalEntity;

        private Locomotive() {
            this.internalEntity = FieldSignature.of((String)this.className, (String)"internal", (Descriptor)Classes.ENTITY.descriptor);
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return false;
        }

        public boolean isCompatibilityMode() {
            return true;
        }
    }

    private static class ItemStack {
        static final String CLASS_NAME = "cam72cam.mod.item.ItemStack";
        static final MethodSignature SET_COUNT = MethodSignature.of((String)"cam72cam.mod.item.ItemStack", (String)"setCount", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Types[]{Types.INT}));
        static final FieldSignature INTERNAL = FieldSignature.of((String)"cam72cam.mod.item.ItemStack", (String)"internal", (Descriptor)Classes.ITEM_STACK.descriptor);

        private ItemStack() {
        }
    }

    private static class FluidStack {
        static final String CLASS_NAME = "cam72cam.mod.fluid.FluidStack";
        static final ClassDescriptor DESCRIPTOR = ClassDescriptor.from((String)"cam72cam.mod.fluid.FluidStack");
        static final FieldSignature INTERNAL = FieldSignature.of((String)"cam72cam.mod.fluid.FluidStack", (String)"internal", (Descriptor)Classes.FLUID_STACK.descriptor);

        private FluidStack() {
        }
    }
}

